function viewdata;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% viewdata                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%   none
% OUTPUTS
%   none
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Visualize data                                     %
%        trajectories                                %
%        landscapes                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   20/01/2003   version 1.2                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mainfig=findobj('userdata','Cubatch');
delete(findobj('tag','cbaxes'));
X=getappdata(mainfig,'X');
mi=getappdata(mainfig,'Model');
h=get(gcbo,'parent');
switch get(h,'tag')
case {'trajXview','landXview'},
   AA=X{1};
  % [AA,cosX,sam,var]=definearray(mi,1);
case {'trajYview','landYview'},
   AA=X{2};
  % [AA,cosX,sam,var]=definearray(mi,2);
end;
%AA=AA{1}
A=AA.data;
N=ndims(A);
R=size(A);
u=get(gcbo,'label');
i=eval(u(6:end));
hhh=axes('parent',1);
set(hhh,'position',[0.3,0.11,0.685,0.815],'tag','cbaxes','fontsize',7);
set(hhh,'nextplot','replacechildren');
switch get(h,'tag')
case {'trajXview','trajYview'},
   A=permute(A,[i,1:i-1,i+1:N]);
   Ri=size(A);
   a=Ri(1);
   b=prod(Ri([2:N]));
   B=reshape(A,a,b);
   h=plot(B');
   set(h,{'tag'},AA.labels{i});
   set(h,'buttondownfcn','dispinfo(gcbo)')%  tooltip
   hold on;
   ax=axis;
   %for k=1:1
   for u=1:prod(Ri([3:N])),
      line([Ri(2)*u Ri(2)*u], [ax(3) ax(4)],'color','r');
   end;
   %end;
   plot(B');
   flip=fliplr(AA.modenames{i});
   if strcmp(flip(1),'s'),
      title([AA.name,': ',int2str(Ri(1)),' ',AA.modenames{i}],'fontsize',9);
   else
      title([AA.name,': ',AA.modenames{i},' (',int2str(Ri(1)),')'],'fontsize',9);
   end;
   list=AA.labels{i};
   %h2=uicontextmenu('parent',hhh,...
   %   'label','Legend',...
   %   'callback','');
   if length(list)<30,  
      legend(list{:},0);
   end;
   %xlabel(AA.modenames{i});
   hold off;
case {'landXview','landYview'},
   AA=permute(AA,[1:i-1,i+1:N,i]);
   A=AA.data;
   if N==3,
      [sel,ok]=listdlg('liststring',AA.labels{N},...
         'name',AA.modenames{N},...
         'promptstring','Choose between these modalities:',...
         'selectionmode','single');
      if ok==1,
         surf(AA.scalars{2},AA.scalars{1},A(:,:,sel));
         xlabel(AA.modenames{2});
         ylabel(AA.modenames{1});
         title([AA.name,': Landscape of the slab ',AA.labels{N}{sel},' along the mode ',int2str(i),' (',AA.modenames{N},')'],'fontsize',9);    
      end;
  elseif N==2,
      surf(AA.scalars{2},AA.scalars{1},A);
      xlabel(AA.modenames{2});
      ylabel(AA.modenames{1});
      title([AA.name,': Landscape of the data'],'fontsize',9);
  else
      uiwait(warndlg({'Landscape is not available','for 4-way data and more.'}));
      return;
  end;
end;
axis tight