function SetPath
% function SetPath;
% 
% Description:
% Introduces the accessorial directories in the path.
% This operation is repeated whenever CuBatch is started.
% The same directories (with the exception of the help directory, its subdirectories and the object
% directories) are then removed by means of RemPath when CuBatch is closed.
% 
% 
% Inputs: 
% None
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 20-Oct-2002 22:21:56
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

Dir = which('Cubatch.m');
Dir = Dir(1:find(Dir == '\', 1, 'last' ));
path([Dir,'Common'],path);
% path([Dir,'private'],path);
path([Dir,'Help'],path);
path([Dir,'Help\user'],path);
path([Dir,'Help\Programmer'],path);
path([Dir,'Help\pics'],path);
path([Dir,'Model_Parafac'],path);
path([Dir,'Model_OPA'],path);
path([Dir,'Model_OPA3'],path);
path([Dir,'Model_PCA'],path);
path([Dir,'Model_PCAVI'],path);
path([Dir,'Model_Tucker'],path);
path([Dir,'Model_TuckerVI'],path);
path([Dir,'Model_Parafac2'],path);
path([Dir,'Model_nPLS1'],path);
path([Dir,'Nway'],path);
