function [ModelIn,Content,X] =ReshapeWindow(listint,Nxy);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% reshapewindow                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  reshape n-way array (X or Y)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OUTPUTS
%   ModelIn  stucture modelin
%   Content  content onject
%   X        content data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   05/11/2002   version 1.1                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
guinames;
delete(findobj('userdata','window'));
mainfig=findobj('userdata','Cubatch');
[ModelIn,Content,X]=getcvdata(mainfig,'Model','Content','X');
if isequal(gcbf,mainfig),
    if length(X)==2,
        [selxy]=questdlg('Which data do You want to reshape?',...
            'choice of data',....
            'X','Y','X');
        if strcmp(selxy,'X'),
            Nxy=1;
        elseif strcmp(selxy,'Y'),
            Nxy=2;
        end;
    else
        Nxy=1;
    end;
    if Nxy==1, % name of window
        na='Reshape data X';
    else
        na='Reshape data Y';
    end
    R=X{Nxy}.dims;
    N=length(R);
    [selid]=questdlg({['Data are ',int2str(N),'-way . Do you wish to'],['increase the number of ways or decrease it?']},...
        'question',....
        'Increase','Decrease','Increase');
    if strcmp(selid,'Increase'),   %increase
        name=X{Nxy}.name;
        posi=[300 320 250 260+25*N];
        h0 = figure('Color',WIC, ...
            'MenuBar','none', ...
            'Name',na, ...
            'userdata','window',...
            'tag','reshapewindow',...
            'resize','off',...
            'NumberTitle','off', ...
            'Position',posi, ...
            'toolbar','none');
        h1 = uicontrol('parent',h0, ...
            'Position',[0 220+25*N 250 20], ...
            'string',[int2str(N),'-way data: ',name],...
            'fontweight','bold',...
            'horizontalalignment','center',...
            'fontsize',9,...
            'backgroundColor',WIC, ...
            'style','text');
        h1 = uicontrol('parent',h0, ...
            'Position',[0 200+25*N 250 20], ...
            'string',['Select the modes you want reshape:'],...
            'horizontalalignment','center',...
            'fontsize',9,...
            'backgroundColor',WIC, ...
            'style','text');
        for i=1:N,
            if strcmp(X{1}.modenames{i},['Mode ',int2str(i)])
                st=X{1}.modenames{i};
            else
                st=['Mode ',int2str(i),': ',X{1}.modenames{i}];
            end;
            hpos(i) = uicontrol('parent',h0, ...
                'Position',[20 200+25*(N-i) 140 20], ...
                'backgroundColor',WIC, ...
                'string',st,...
                'tag',['tpos',int2str(i)],...
                'tooltipstring',[''],...
                'callback',['set([findobj(''string'',''OK''),findobj(''tag'',''newd'')],''enable'',''off'');if isequal(get(gcbo,''value''),1),set(findobj(''tag'',''tposedit',int2str(i),'''),''enable'',''on'');else set(findobj(''tag'',''tposedit',int2str(i),'''),''enable'',''off'',''string'',',int2str(X{Nxy}.dims(i)),');end;'],...
                'style','checkbox');
            hposedit(i) = uicontrol('parent',h0, ...
                'Position',[150 200+25*(N-i) 70 20], ...
                'backgroundColor',WIC, ...
                'callback',['set([findobj(''string'',''OK''),findobj(''tag'',''newd'')],''enable'',''off'');'],...
                'string',[int2str(X{Nxy}.dims(i))],...
                'enable','off',...
                'tag',['tposedit',int2str(i)],...
                'tooltipstring',['Replace the value by a succession of new values',char(10),'separated by spaces.'],...
                'style','edit');
            irreductible=0;
            if irreductible,
                set(hpos(i),'enable','off');
            end;
        end;
        h1 = uicontrol('parent',h0, ...
            'Position',[0 152 250 20], ...
            'horizontalalignment','center',...
            'backgroundColor',WIC, ...
            'enable','on',...
            'tag','newd',...
            'string',[''],...
            'style','text');
        listint=evaluatereshape('inc',N,prod(X{Nxy}.dims));
        h1 = uicontrol('parent',h0, ...
            'Position',[52 122 140 30], ...
            'callback',['evalin(''caller'',''listint=evaluatereshape(''''inc'''',',int2str(N),',',int2str(prod(X{Nxy}.dims)),');'');'],...
            'horizontalalignment','center',...
            'string','Evaluate',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[52 77 140 30], ...%'callback','evalin(''caller'',''for i=1:N,set(tposedit',int2str(i),',''''string'''',int2str(X{Nxy}.dims(i)));end;'');',...% a faire
            'horizontalalignment','center',...
            'string','Default',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[52 42 140 30], ...
            'callback','delete(findobj(''tag'',''reshapewindow''));',...
            'horizontalalignment','center',...
            'string','Cancel',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[52 7 140 30], ...
            'callback','evalin(''caller'',''[ModelIn,Content,X]=reshapewindow(listint,Nxy);'')',...
            'horizontalalignment','center',...
            'enable','off',...
            'string','OK',...
            'style','pushbutton');
    elseif strcmp(selid,'Decrease'),             %DECREASE
        name=X{1}.name;
        posi=[300 320 250 260+25*N];
        h0 = figure('Color',WIC, ...
            'MenuBar','none', ...
            'Name',na, ...
            'userdata','window',...
            'tag','reshapewindow',...
            'resize','off',...
            'NumberTitle','off', ...
            'Position',posi, ...
            'toolbar','none');
        h1 = uicontrol('parent',h0, ...
            'Position',[0 220+25*N 250 20], ...
            'string',[int2str(N),'-way data: ',name],...
            'fontweight','bold',...
            'horizontalalignment','center',...
            'fontsize',9,...
            'backgroundColor',WIC, ...
            'style','text');
        h1 = uicontrol('parent',h0, ...
            'Position',[0 200+25*N 250 20], ...
            'string',['Select the modes you want to concatenate:'],...
            'horizontalalignment','center',...
            'fontsize',9,...
            'tooltipstring','Consecutive modes.',...
            'backgroundColor',WIC, ...
            'style','text');
        for i=1:N,
            if strcmp(X{1}.modenames{i},['Mode ',int2str(i)])
                st=X{1}.modenames{i};
            else
                st=['Mode ',int2str(i),': ',X{1}.modenames{i}];
            end;
            hpos(i) = uicontrol('parent',h0, ...
                'Position',[20 200+25*(N-i) 140 20], ...
                'backgroundColor',WIC, ...
                'string',st,...
                'tag',['tpos',int2str(i)],...
                'userdata','tpos',...
                'tooltipstring',[''],...
                'callback',['set([findobj(''string'',''OK''),findobj(''tag'',''newd'')],''enable'',''off'');if isequal(get(gcbo,''value''),1),else set(findobj(''tag'',''tposedit',int2str(i),'''),''enable'',''off'',''string'',',int2str(X{Nxy}.dims(i)),');end;'],...
                'style','checkbox');
            hposedit(i) = uicontrol('parent',h0, ...
                'Position',[150 200+25*(N-i) 70 20], ...
                'backgroundColor',WIC, ...
                'string',[int2str(X{Nxy}.dims(i))],...
                'userdata','tpos',...
                'tag',['tpostext',int2str(i)],...
                'tooltipstring',['size'],...
                'style','text');
        end;  
        h1 = uicontrol('parent',h0, ...
            'Position',[0 152 250 20], ...
            'horizontalalignment','center',...
            'backgroundColor',WIC, ...
            'enable','on',...
            'tag','newd',...
            'string',[''],...
            'style','text');
        evaluatereshape('dec',N,prod(X{Nxy}.dims));
        h1 = uicontrol('parent',h0, ...
            'Position',[52 122 140 30], ...
            'callback',['set([findobj(''string'',''OK''),findobj(''tag'',''newd'')],''enable'',''on'');evalin(''caller'',''listint=evaluatereshape(''''dec'''',',int2str(N),',',int2str(prod(X{Nxy}.dims)),');'');'],...
            'horizontalalignment','center',...
            'string','Evaluate',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[52 77 140 30], ...
            'callback','set(findobj(''userdata'',''tpos''),''value'',0);',...
            'horizontalalignment','center',...
            'string','Default',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[52 42 140 30], ...
            'callback','delete(findobj(''tag'',''reshapewindow''));',...
            'horizontalalignment','center',...
            'string','Cancel',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[52 7 140 30], ...
            'callback','evalin(''caller'',''[ModelIn,Content,X]=reshapewindow(listint,Nxy);'')',...
            'horizontalalignment','center',...
            'enable','on',...
            'string','OK',...
            'style','pushbutton');
    end;
    waitfor(findobj('tag','reshapewindow'));
    
else    %execute   
    %Nxy=1;
    X=getappdata(mainfig,'X');
    X{Nxy}              = reshape(X{Nxy},listint);
    Xfil                = {ModelIn.file(Nxy).file};
    Xfil{2}             = ModelIn.file(Nxy).matrices;
    [ModelIn,Content,X] = Initialise([],[],[],X,Xfil,1); %It is for single sets only   ???????
    ModelIn.xpointer    = mainfig;
    setcvdata(mainfig,'Content',Content,'Model',ModelIn,'X',X);
    delete(gcbf)
end;



