function RemPath
% function RemPath;
% 
% Description:
% Removes the directories added with SetPath with the exception of the help directory, its
% subdirectories and the object directories. It is called by CuBatch upon quitting.
% 
% 
% Inputs: 
% None
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21-Oct-2002 02:42:18
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

Dir = which('Cubatch.m');
Dir = Dir(1:max(find(Dir == '\')));
rmpath([Dir,'Model_PARAFAC']);
rmpath([Dir,'Model_nPLS1']);
rmpath([Dir,'Model_OPA']);
rmpath([Dir,'Model_OPA3']);
rmpath([Dir,'Model_PCA']);
rmpath([Dir,'Model_PCAVI']);
rmpath([Dir,'Model_Tucker']);
rmpath([Dir,'Model_TuckerVI']);
rmpath([Dir,'Model_PARAFAC2']);
rmpath([Dir,'Nway']);
rmpath([Dir,'Common']);

