function [ModelIn,Content,X] =permutewindow;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% permutewindow                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% window for permutation of n-way array (X or Y)     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OUTPUTS
%   ModelIn  stucture modelin
%   Content  content onject
%   X        content data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINES
%   getcvdata
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   10/02/2003   version 1.2                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
guinames;
mainfig=findobj('userdata','Cubatch');
[ModelIn,Content,X]=getcvdata(mainfig,'Model','Content','X');
R=X{1}.dims;
N=length(R);
if isequal(gcbf,mainfig),
    delete(findobj('userdata','window'));
    if length(X)==1,
        name=X{1}.name;
        posi=[300 420 190 100+25*N];
        h0 = figure('Color',WIC, ...
            'MenuBar','none', ...
            'Name','Permute data', ...
            'userdata','window',...
            'tag','permutewindow',...
            'resize','off',...
            'NumberTitle','off', ...
            'Position',posi, ...
            'toolbar','none');
        h1 = uicontrol('parent',h0, ...
            'Position',[2 80+25*N 170 20], ...
            'string',[int2str(N),'-way data: ',name],...
            'fontweight','bold',...
            'horizontalalignment','center',...
            'fontsize',9,...
            'backgroundColor',WIC, ...
            'style','text');
        for i=1:N,
            hpos(i) = uicontrol('parent',h0, ...
                'Position',[150 80+25*(N-i) 20 20], ...
                'string',int2str(i),...
                'tag',['tposx',int2str(i)],...
                'tooltipstring',['integer between 1 and ',int2str(N),'.',char(10),'Position of this mode on the permutated data.'],...
                'style','edit');
            h1 = uicontrol('parent',h0, ...
                'Position',[2 80+25*(N-i) 120 20], ...
                'string',['Mode ',int2str(i),': ',X{1}.modenames{i}],...
                'horizontalalignment','left',...
                'fontsize',8,...
                'backgroundColor',WIC, ...
                'style','text');
        end;
        h1 = uicontrol('parent',h0, ...
            'Position',[22 42 140 30], ...
            'callback','evalin(''caller'',''for i=1:N,set(hpos(i),''''string'''',int2str(i));end;'');',...
            'horizontalalignment','center',...
            'string','Default',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[22 7 140 30], ...
            'callback','evalin(''caller'',''[ModelIn,Content,X] =permutewindow;'')',...
            'horizontalalignment','center',...
            'string','OK',...
            'style','pushbutton');
    elseif length(X)==2,   %    permutation for X and Y
        X=getappdata(mainfig,'X');
        Rx=X{1}.dims;
        Nx=length(Rx);
        Ry=X{2}.dims;
        Ny=length(Ry);
        namex=X{1}.name;
        namey=X{2}.name;
        N=max(Nx,Ny);
        posi=[300 420 380 120+25*N];
        h0 = figure('Color',WIC, ...
            'MenuBar','none', ...
            'Name','Permute data', ...
            'userdata','window',...
            'tag','permutewindow',...
            'resize','off',...
            'NumberTitle','off', ...
            'Position',posi, ...
            'toolbar','none');
        h1 = uicontrol('parent',h0, ...
            'Position',[posi(1:2),posi(3),posi(4)], ...
            'backgroundColor',FRC, ...
            'style','frame');
        h1 = uicontrol('parent',h0, ...
            'Position',[2 100+25*N 170 20], ...
            'string','X',...
            'fontweight','bold',...
            'horizontalalignment','center',...
            'fontsize',10,...
            'backgroundColor',WIC, ...
            'style','text');
        h1 = uicontrol('parent',h0, ...
            'Position',[2 80+25*N 170 20], ...
            'string',[int2str(Nx),'-way data: ',namex],...
            'fontweight','bold',...
            'horizontalalignment','center',...
            'fontsize',9,...
            'backgroundColor',WIC, ...
            'style','text');
        h1 = uicontrol('parent',h0, ...
            'Position',[197 100+25*N 170 20], ...
            'string','Y',...
            'fontweight','bold',...
            'horizontalalignment','center',...
            'fontsize',10,...
            'backgroundColor',WIC, ...
            'style','text');
        h1 = uicontrol('parent',h0, ...
            'Position',[197 80+25*N 170 20], ...
            'string',[int2str(Ny),'-way data: ',namey],...
            'fontweight','bold',...
            'horizontalalignment','center',...
            'fontsize',9,...
            'backgroundColor',WIC, ...
            'style','text');
        for i=1:Nx,
            hposx(i) = uicontrol('parent',h0, ...
                'Position',[150 80+25*(N-i) 20 20], ...
                'string',int2str(i),...
                'tag',['tposx',int2str(i)],...
                'tooltipstring',['integer between 1 and ',int2str(Nx),'.',char(10),'Position of this mode on the permutated data.'],...
                'style','edit');
            h1 = uicontrol('parent',h0, ...
                'Position',[2 80+25*(N-i) 120 20], ...
                'string',['Mode ',int2str(i),': ',X{1}.modenames{i}],...
                'horizontalalignment','left',...
                'fontsize',8,...
                'backgroundColor',WIC, ...
                'style','text');
        end;
        for i=1:Ny,
            hposy(i) = uicontrol('parent',h0, ...
                'Position',[341 80+25*(N-i) 20 20], ...
                'string',int2str(i),...
                'tag',['tposy',int2str(i)],...
                'tooltipstring',['integer between 1 and ',int2str(Ny),'.',char(10),'Position of this mode on the permutated data.'],...
                'style','edit');
            h1 = uicontrol('parent',h0, ...
                'Position',[202 80+25*(N-i) 120 20], ...
                'string',['Mode ',int2str(i),': ',X{2}.modenames{i}],...
                'horizontalalignment','left',...
                'fontsize',8,...
                'backgroundColor',WIC, ...
                'style','text');
        end;        
        h1 = uicontrol('parent',h0, ...
            'Position',[124 42 140 30], ...
            'callback','evalin(''caller'',''for i=1:Nx,set(hposx(i),''''string'''',int2str(i));end;for i=1:Ny,set(hposy(i),''''string'''',int2str(i));end;'');',...
            'horizontalalignment','center',...
            'string','Default',...
            'style','pushbutton');
        h1 = uicontrol('parent',h0, ...
            'Position',[124 7 140 30], ...
            'callback','evalin(''caller'',''[ModelIn,Content,X] =permutewindow;'')',...
            'horizontalalignment','center',...
            'string','OK',...
            'style','pushbutton');
    end;
    % cu_FIX_2011
    % oring : waitfor(findobj('tag','permutewindow'));
    waitfor(findobj('tag','permutewindow'));
else %execution permutation
    if length(X)==1,
        ord=[];
        try
            for i=1:N,
                ord=[ord,eval(get(findobj('tag',['tposx',int2str(i)]),'string'))];
            end;
        catch
            uiwait(warndlg({'Non numeric indexes !'}));
            return;
        end;
        for i=1:N
            if ord(i)-ceil(ord(i))~=0,
                uiwait(warndlg({'Non integer indexes !'}));
                return;
            end;
        end;
        if ~isequal(sort(ord),[1:N]),
            uiwait(warndlg({'Non existing indexes or 2 identical indexes!'}));
            return;
        end;
        X                   = permute(X{1},ord);
        Xfil                = {ModelIn.file(1).file};
        Xfil{2}             = ModelIn.file(1).matrices;
        [ModelIn,Content,X] = Initialise([],[],[],X,Xfil,1); %It is for single sets only
        ModelIn.xpointer    = mainfig;
        setcvdata(mainfig,'Content',Content,'Model',ModelIn,'X',X);
        delete(gcbf)      
    elseif length(X)==2,
        Rx=X{1}.dims;
        Nx=length(Rx);
        Ry=X{2}.dims;
        Ny=length(Ry);
        ordx=[];
        try
            for i=1:Nx,
                get(findobj('tag',['tposx',int2str(i)]),'string');
                ordx=[ordx,eval(get(findobj('tag',['tposx',int2str(i)]),'string'))];
            end;
        catch
            uiwait(warndlg({'Non numeric indexes for X!'}));
            return;
        end;
        ordy=[];
        try
            for i=1:Ny,
                ordy=[ordy,eval(get(findobj('tag',['tposy',int2str(i)]),'string'))];
            end;
        catch
            uiwait(warndlg({'Non numeric indexes for Y!'}));
            return;
        end;
        for i=1:Nx
            if ordx(i)-ceil(ordx(i))~=0,
                uiwait(warndlg({'Non integer indexes for X!'}));
                return;
            end;
        end;
        for i=1:Ny
            if ordy(i)-ceil(ordy(i))~=0,
                uiwait(warndlg({'Non integer indexes for Y!'}));
                return;
            end;
        end;
        if ~isequal(sort(ordx),[1:Nx]),
            uiwait(warndlg({'Non existing indexes or 2 identical indexes for X!'}));
            return;
        end;
        if ~isequal(sort(ordy),[1:Ny]),
            uiwait(warndlg({'Non existing indexes or 2 identical indexes for Y!'}));
            return;
        end;
        if ~isequal(Rx(ordx(1)),Ry(ordy(1))),
            uiwait(warndlg({'The first mode of X and Y have to be of same size!'}));
            return;
        end;
        x                   = permute(X{1},ordx);
        xfil                = {ModelIn.file(1).file};
        xfil{2}             = ModelIn.file(1).matrices;
        y                   = permute(X{2},ordy);
        yfil                = {ModelIn.file(2).file};
        yfil{2}             = ModelIn.file(2).matrices;
        [ModelIn,Content,X] = Initialise([],[],[],x,xfil,1); %It is for single sets only
        [ModelIn,Content,X] = Initialise(Content,ModelIn,X,y,yfil,0); %It is for single sets only
        ModelIn.xpointer    = mainfig;
        setcvdata(mainfig,'Content',Content,'Model',ModelIn,'X',X);
        delete(gcbf);    
    end;
end;



