% Description: Imports data from .mat files. The flag variable is OK. If OK is 1 then the importing was
% completed with no mistakes. Othewise it returns earlier and OK remains 0. ModelIn, ModelOut, X and
% Content are updated according to the characteristics of the loaded data.
% 
% Inputs: 
% None
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: definemodelout, initialise, setcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 21:11:34
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 

OK = 0;
if get(gcbo,ud)
   ListProp = {'selectionmode','multiple','name','Load arrays','promptstring','Select the arrays to load'};
   ReqTit   = 'Load multiple set';
else
   ListProp = {'selectionmode','single','name','Load array','promptstring','Select the array to load'};
   ReqTit   = 'Load single set';
end
[Xt,Yt,Xfil,Yfil] = deal({});
try
   
   CDir = cd;
   Dir  = which('Cubatch.m');
   Dir  = Dir(1:max(find(Dir == '\')));
   cd([Dir,'Data'])             
   [Xfil{2:-1:1}] = uigetfile('*.mat',ReqTit);
   cd(CDir)
   
 catch
    [Xfil{2:-1:1}] = uigetfile('*.mat',ReqTit);
end;         
if ~isequal(Xfil{1},0)
   Cont = who('-file',[Xfil{:}]);
   Ok   = 1;
   Sel  = 1;
   if length(Cont) > 1
      [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
   end
   if Ok
      if get(gcbo,ud)
         Xt         = load([Xfil{:}],Cont{Sel});
         [Xnam,ind] = sort(fieldnames(Xt));
         Xt         = struct2cell(Xt);
         Xt         = Xt(ind);
         for i = 1:length(Xt)
            Xsiz(i,1) = size(Xt{i},1);
         end
         Xt   = cat(1,Xt{:});
         Xfil = {[Xfil{:}];[Cont{Sel(1)},' ...']};
      else
         Xt   = load([Xfil{:}],Cont{Sel});
         Xt   = getfield(Xt,Cont{Sel});
         Xfil = {[Xfil{:}];Cont{Sel}};
         Xnam = [];
         Xsiz = [];
      end
      try
         if ~isempty(Xt)
            [ModelIn,Content,X] = Initialise(Content,ModelIn,X,Xt,Xfil,[1 get(gcbo,ud)],Xnam,Xsiz);
            ModelIn.xpointer    = gcbf;
         else
            return
         end
      catch
         errordlg(lasterr,'Import error')
         return
      end
   else 
      return
   end
   Ans = questdlg('Do you need to load a Y matrix?','Load Y matrix','Yes','No','Cancel','Yes');
   if strcmp(Ans,'Yes')
      try
         CDir = cd;
         Dir  = which('Cubatch.m');
         Dir  = Dir(1:max(find(Dir == '\')));
         cd([Dir,'Data'])             
          [Yfil{2:-1:1}] = uigetfile('*.mat','Load Y data');
          cd(CDir)
      catch
         [Yfil{2:-1:1}] = uigetfile('*.mat','Load Y data');
      end;
      if ~isequal(Yfil{1},0);
         Cont = who('-file',[Yfil{:}]);
         Ok   = 1;
         Sel  = 1;
         if length(Cont) > 1
            [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
         end
         if Ok
            if get(gcbo,ud)
            
               Yt         = load([Yfil{:}],Cont{Sel});
               [Ynam,ind] = sort(fieldnames(Yt));
               if length(Ynam) ~= length(Xnam)
                  uiwait(errordlg('The number of samples/batches in X and Y must be the same!','Import error'));
                  return
               end
               Yt         = struct2cell(Yt);
               Yt         = Yt(ind);
               Ysiz       = cellfun('size',Yt,1);
               Yt         = cat(1,Yt{:});
               Yfil       = {[Yfil{:}];[Cont{Sel(1)},' ...']};
               
            else
            
               Yt   = load([Yfil{:}],Cont{Sel});
               Yt   = getfield(Yt,Cont{Sel});
               Yfil = {[Yfil{:}];Cont{Sel}};
               Ynam = [];
               Ysiz = [];
               
            end
            try
            
               if ~isempty(Yt)
                  [ModelIn,Content,X] = Initialise(Content,ModelIn,X,Yt,Yfil,[0 get(gcbo,ud)],Ynam,Ysiz);
               else
                  return
               end
               
            catch
               errordlg(lasterr,'Import error')
               return
            end
            
         else 
            return
         end
         
      else
         return
      end
   elseif strcmp(Ans,'Cancel')
      return
      
   end
   [ModelOut,PlotStr] = DefineModelOut;
   setcvdata(gcbf,'Content',Content,'Model',ModelIn,'X',X,'Results',ModelOut,'PlotStr',PlotStr)
   
else
   return
end
OK = 1;