function DisplayModel(ModelOut)
% function DisplayModel (ModelOut);
% 
% Description:
% Displays in the InfoBox the informations about the current model. The called function is determined
% on the model name as saved in the ModelOut structure. The ModelIn structure is taken from the
% application data of the main figure. For some of the models (currently PARAFAC and nPLS/PLS) the main
% input is overridden by the ModelOut stored in the current axes application data: "ModelOut" (this
% allows to select a certain model when more than one has been computed and to display only the
% relative information). In case no model is present, the function DisplayInfo is called. Note: the
% main window's handle is found by means of findobj('type','figure','userdata','Cubatch') The presence
% of two CuBatch windows at the same time interferes with this syntax and it is therefore not allowed
% in the current implementation of the program.
% 
% Inputs: 
% ModelOut: ModelOut structure
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch, ResizeCuBatch
% 
% Subroutines:
% Internal: None
% External: displayinfo
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 05-Nov-2002 16:38:46
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 

H       = findobj(0,'type','figure','userdata','Cubatch');;
ModelIn = getappdata(H,'Model');
if ~isempty(ModelOut(1).modelname)
   switch ModelOut(1).modelname
   case 'PARAFAC'
      Fl = strcmp(get(gcbo,'type'),'uimenu');
      if Fl 
         L = strcmp(get(gcbo,'label'),'Projection');
      else
         L = 1;
      end
      ax = findobj('type','axes','tag','cbaxes');
      if ~isempty(ax) & ~isequal(get(ax,'userdata'),'defaultplot')
         
         if ~isempty(getappdata(findobj('type','axes','tag','cbaxes'),'ModelOut')) & Fl & L
            PARAFACDisplayInfo(H,getappdata(findobj('type','axes','tag','cbaxes'),'ModelOut'))
         else
            PARAFACDisplayInfo(H,ModelOut)
         end
         
      else
         PARAFACDisplayInfo(H,ModelOut)
      end
   case 'OPA'
      OPADisplayInfo(H,ModelOut)
   case 'OPA3D'
      if isempty(ModelOut.modelname)
         OPA3DisplayInfo(H,ModelOut)
      else
          H = findobj(0,'type','figure','userdata','Cubatch');
          OPA3DisplayInfo(H,ModelOut)   
      end
   case 'PCA'
      acpdisplayInfo(gcbf,ModelIn,ModelOut)
   case 'PARAFAC2'
      PARAFAC2DisplayInfo(H,ModelOut)
   case {'nPLS','PLS'}
      ax = findobj('type','axes','tag','cbaxes');
      if ~isempty(ax) & ~isequal(get(ax,'userdata'),'defaultplot')
         if ~isempty(getappdata(findobj('type','axes','tag','cbaxes'),'ModelOut'))
            nPLS1DisplayInfo(H,getappdata(findobj('type','axes','tag','cbaxes'),'ModelOut'))
         else
            nPLS1DisplayInfo(H,ModelOut)   
         end
      else
         nPLS1DisplayInfo(H,ModelOut)
      end
   case 'Tucker'      
      tuckerdisplayInfo(H,ModelIn,ModelOut)
   case 'IV-Tucker'
      tuckervidisplayInfo(H,ModelIn,ModelOut)
   case 'IV-PCA'
      acpvidisplayInfo(H,ModelIn,ModelOut)      
      %... add other/new models here   
   otherwise
      delete(findobj('type','axes'))
      DisplayInfo(findobj(H,getappdata(H,'X')));
   end
else
   delete(findobj('type','axes'))
   DisplayInfo(H,getappdata(H,'X'));
end