% Description: According to the tag of the calling menu it calls the appropriate function handling 
%              the GUI for the specific model associated to that menu. The latter function need 
%              not be in the CuBatch directory, but it must indeed be in the current path. 
%              As an option it is of course possible to have this batch-file call a
%              function which simply computes the desired model without opening a GUI.
% 
% Inputs: None
% 
% Outputs: None
% 
% Called by: CuBatch
% 
% Subroutines: Internal: None External: ctag, acp, acpvi, defaultplot, npls1model, opaseb, opa3d1,
%              parafacmodel, parafac2b, tucker, tuckervi
% 
% Author: Giorgio Tomasi 
%         Royal Agricultural and Veterinary University 
%         MLI, LMT, Chemometrics group
%         Rolighedsvej 30 
%         DK-1958 Frederiksberg C 
%         Danmark
% 
% Last modified: 11-Oct-2002 20:41:02
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
%

H = gcbf;
switch ctag
   case 'OPA'
      %[ModelIn,ModelOut] = opaseb(ModelIn,ModelOut);
      opaseb(ModelIn,ModelOut);
      waitfor(H,'waitstatus','close');
      set(H,'waitstatus','');
      defaultplot(ModelIn,ModelOut)
      
   case 'OPA3D'
      ModelOut.data.dataset = X{1}.data;
      [ModelOut,ModelIn]    = opa3d1(ModelIn,ModelOut);
      waitfor(H,'waitstatus','close');
      set(H,'waitstatus','')
      defaultplot(ModelIn,ModelOut);
      
   case 'PARAFAC'
      [ModelIn,ModelOut] = PARAFACModel(ModelIn);
      if ~isempty(ModelOut)
         defaultplot(ModelIn,ModelOut)
      end
      
   case 'PARAFAC2'
      ModelOut.data.dataset = X{1}.data;
      [ModelIn,ModelOut]    = PARAFAC2b(ModelIn,ModelOut);
      waitfor(H,'waitstatus','close');
      set(H,'waitstatus','');
      defaultplot(ModelIn,ModelOut);
      
   case 'PCA',
      [ModelIn] = Acp(ModelIn);
      waitfor(findobj('tag','pca'));
      
   case 'PCA-IV'
      [ModelIn]=acpvi(ModelIn);
      waitfor(findobj('tag','acpvi'));
      
   case 'Tucker'
      [ModelIn]=tuckerb(ModelIn);
      waitfor(findobj('tag','tucker'));
      
   case 'Tucker-IV'
      [ModelIn]=tuckervi(ModelIn);
      waitfor(findobj('tag','tuckervi'));
      
   case {'nPLS','PLS'};
      [ModelIn,ModelOut] = nPLS1Model(ModelIn,ctag);
      if ~isempty(ModelOut)
         defaultplot(ModelIn,ModelOut)
      end
      
end
