% Description:
% According to the name of the model (stored in ModelOut) of the calling menu it calls the 
% appropriate function (which should be named *Apply.m) handling the application to new model
% associated to that menu. The latter function need not be in the CuBatch directory, but it 
% must indeed be in the current path. 
% 
% 
% Inputs: 
% None
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: *Apply.m functions for all the supported models, defaultplot
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 05-Nov-2002 16:36:20
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

switch ModelOut(1).modelname
   case 'PARAFAC'
      ModelOut = PARAFACApply(gcbf);
      if ~isempty(ModelOut)
         defaultplot(ModelIn,ModelOut)
      end
      
   case {'nPLS','PLS'}
      ModelOut = nPLS1Apply(gcbf);
      if ~isempty(ModelOut)
         defaultplot(ModelIn,ModelOut)
      end
      
   case 'OPA'
      [ModelOut]=OPAapply(ModelOut);
      defaultplot(ModelIn,ModelOut);
      
   case 'OPA3D'
      [ModelOut]=OPA3apply(ModelOut);
      defaultplot(ModelIn,ModelOut);
      
   case 'PARAFAC2'
      ModelOut.options=ModelIn.options;
      [ModelIn,ModelOut]=PARAFAC2apply(ModelIn,ModelOut);
      defaultplot(ModelIn,ModelOut);
      
   case 'Tucker',
      [ModelIn, ModelOut]=tuckerapply(ModelIn, ModelOut);
      
   case 'PCA',
      [ModelIn, ModelOut]=acpapply(ModelIn, ModelOut);
      
   case 'IV-PCA',
      [ModelIn, ModelOut]=acpviapply(ModelIn, ModelOut);
      
   case 'IV-Tucker'
      [ModelIn, ModelOut]=tuckerviapply(ModelIn, ModelOut);
      
end