% Description:
% Batch file generating the submenus of the "Factor analysis" menu. Each menu's handle must be saved 
% in an appropriate field of the GlHan structure.
% Each menu must also be given an appropriate 'tag', which is then to be included in the 
% Available_Models variable defined by Av_Models
% 
% Inputs: 
% None
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 20:59:12
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

GlHan.opa  = uimenu(GlHan.expl,la,'&OPA',         cb,cbf,tg,'OPA',     dis{:});
GlHan.opa3 = uimenu(GlHan.expl,la,'OPA &3D',      cb,cbf,tg,'OPA3D',   dis{:});
GlHan.par  = uimenu(GlHan.expl,la,'PARA&FAC',     cb,cbf,tg,'PARAFAC');
GlHan.par2 = uimenu(GlHan.expl,la,'PARAFAC&2',    cb,cbf,tg,'PARAFAC2',dis{:});
GlHan.pca  = uimenu(GlHan.expl,la,'&PCA',         cb,cbf,tg,'PCA',     dis{:});
GlHan.tuck = uimenu(GlHan.expl,la,'&Tucker',      cb,cbf,tg,'Tucker',  dis{:},acc,'T');
