function ResizeCuBatch(varargin)
% function ResizeCuBatch (varargin);
% 
% Description:
% Prevents the CuBatch main window from becoming smaller than 804 x 504 pixels.
% It also replot any plot on the main window and readjust the InfoBox in case it is necessary.
% 
% Inputs: 
% varargin: is not necessary and required by MatLab (an error message appears otherwise). Its content
%           is not employed by this function.
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: checkaxes, displayinfo, displaymodel, getcvdata, guinames
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 26-Oct-2002 22:40:40
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

GuiNames
s      = get(0,'screensize');
%Set the minimum dimensions of CuBatch at 804 x 504 
WinPos = min([s(3:4)-[804 580] inf inf;max([0 0 804 504;get(gcbf,pos)])]);
set(gcbf,pos,WinPos)
[ModelOut,ModelIn] = getcvdata(gcbf,'Results','ModelIn');
if isempty(getappdata(gcbf,'X')) & (~isa(ModelOut,'struct') | isempty(ModelOut.modelname)) 
   delete(findobj('type','axes','tag','cbaxes'))
end
if isa(ModelOut,'struct')
   if ~isempty(ModelOut(1).modelname)
      DisplayModel(ModelOut)
      CheckAxes(gcbf)
   else
      DisplayInfo(gcbf,getappdata(gcbf,'X'));
   end
else
   DisplayInfo(gcbf,getappdata(gcbf,'X'));
end
