clc
clear all
delete(allchild(0))

F=3;
n=1:30;

A = [exp(-((n-15)/5).^2);exp(-((n-1)/10).^2);exp(-((n-21)/7).^2)]';
subplot(2,3,1)
plot(A),title(' 1^{st} mode')
axis tight

C1 = rand(4,3);
subplot(2,3,2)
plot(C1)
title(' 3^{rd} mode cal')
axis tight

C2 = rand(2,3);
subplot(2,3,3)
plot(C2)
title(' 3^{rd} mode test')
axis tight

H =orth(orth(rand(F))');

P = [];

X = [ ];
for i = 1:size(C1,1),
   P1(:,:,i) = orth(rand(7,F));
   subplot(2,size([C1;C2],1),size([C1;C2],1) + i)
   plot(P1(:,:,i)*H),
   title(sprintf(' 2^{nd} mode cal k = %i',i))
   Xcal(:,:,i)=A*diag(C1(i,:))*(P1(:,:,i)*H)';
   axis tight
end,
for i=1:size(C2,1),
   P2(:,:,i) = orth(rand(7,F));
   subplot(2,size([C1;C2],1),size([C1;C2],1) + i + size(C1,1))
   plot(P2(:,:,i)*H),
   title(sprintf(' 2^{nd} mode test k = %i',i))
   Xtest(:,:,i)=A*diag(C2(i,:))*(P2(:,:,i)*H)';
   axis tight
end
Xcal  = Xcal + randn(size(Xcal))*.01;
Xtest = Xtest + randn(size(Xtest))*.01;

Const = [1 0];
[acal,hcal,ccal,pcal]     = parafac2(Xcal,F,Const);
[atest,htest,ctest,ptest] = parafac2app(Xtest,F,Const,[],acal,hcal);

figure('name','calibration','numb','off')
subplot(2,2,1)
plot(normit(A),'r'),
hold on,
plot(normit(acal),'g'),
hold off
title(' 1^{st} mode')
legend('True','Est.')
axis tight

subplot(2,2,2)
plot(normit(C1),'r')
hold on,
plot(normit(ccal),'g')
hold off
title(' 3^{rd} mode')
legend('True','Est.')
axis tight

for i=1:size(C1,1),
   subplot(2,size(C1,1),size(C1,1) + i)
   ph = P1(:,:,i)*H;
   plot(normit(ph),'r'),
   hold on
   ph = pcal{i}*hcal;
   plot(normit(ph),'g'),
   title(sprintf(' 2^{nd} mode test k = %i',i))
   hold off
   axis tight
end

figure('name','test','numb','off')
subplot(2,2,1)
plot(normit(A),'r'),
hold on,
plot(normit(atest),'g'),
hold off
title(' 1^{st} mode')
legend('True','Est.')
axis tight

subplot(2,2,2)
plot(normit(C2),'r')
hold on,
plot(normit(ctest),'g')
hold off
title(' 3^{rd} mode')
legend('True','Est.')
axis tight

for i=1:size(C2,1),
   subplot(2,size(C2,1),size(C2,1) + i)
   ph = P2(:,:,i)*H;
   plot(normit(ph),'r'),
   hold on
   ph = ptest{i}*htest;
   plot(normit(ph),'g'),
   title(sprintf(' 2^{nd} mode test k = %i',i))
   hold off
   axis tight
end
