function [Axes,MO] = Plot_TU_Loadings(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_TU_Loadings (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the scores of X (i.e. T) versus the scores of Y (i.e. u) for the mode specified in
% PlotStruct.nummode according to what selected in the control figure opened with nPLS1PlotControls.
% The choice of the LV is taken from PlotStruct.factors(1). This plot is not currently applied to the
% new data because of the wrong estimation of the Y vectors. For the axes specified by Axes the
% 'ModelOut' application-defined data is set, and it contains a copy of ModelOut.(employed by
% nPLS1DisplayInfo)
%  
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the model selected via the menus in the main window.
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes scores/loadings.
% MO: empty
% 
% 
% Called by:
% Model_nPLS1\nPLS1ActivatePlots
% NB. The actual call is made from nPLS1Plot via feval and not from Model_nPLS1\nPLS1ActivatePlots.
% 
% 
% Subroutines:
% Internal: None
% External: npls1plotcontrols, plotmodel, plottargetline, plotvalidation, resamplingextract
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 16-Oct-2002 14:43:26
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

MO   = [];
Axes = [];
if isempty(findobj(0,'type','figure','userdata','nPLS1 Plot Control'))
   %Called by the main window.
   PlotStruct.plotdims = 0;
   PlotStruct.nummode  = 1;
   if ~PlotStruct.factors(1)
      PlotStruct.factors(1) = 1;
   end
   [Nil,Pos]           = max(find([ModelOut.model.nbfactors]));
   ModelOut.model      = ModelOut.model(Pos);
   if ~isempty(ModelOut.validation)
      ModelOut.validation = ModelOut.validation(Pos);
   end
   H = nPLS1PlotControls(PlotStruct,ModelOut,MainFig);
   waitfor(H,'waitstatus','Ok')
   if ~ishandle(H)
      Axes = [];
      return
   else 
      PlotStruct = getappdata(H,'PlotStr');
   end
end
PlotStruct.plotdims = 2;
figure(MainFig)
Axes = axes('tag','cbaxes','nextplot','replacechildren');
if PlotStruct.additional.validation & ~isempty(ModelOut.validation)
   [x,y,z] = deal([]);
   if PlotStruct.additional.validation == 2 %Replicates
      
      if strcmp(ModelOut(1).validation.method,'rboo')
         x = squeeze(ModelOut.validation.xfactors{1}(:,PlotStruct.factors(1),:));
         y = squeeze(ModelOut.validation.yfactors{1}(:,PlotStruct.factors(1),:));
      else
         x = ResamplingExtract(ModelOut.validation.xfactors{1},PlotStruct.factors(1),ModelOut.validation.segments);
         y = ResamplingExtract(ModelOut.validation.yfactors{1},PlotStruct.factors(1),ModelOut.validation.segments);
      end
      
   elseif PlotStruct.additional.validation(1) == 1 & isempty(ModelOut.prediction) & any(strcmp({'loo','test'},ModelOut.validation.method))
      x = ModelOut.validation.xfactors{1}(:,PlotStruct.factors(1),end);
      y = ModelOut.validation.yfactors{1}(:,PlotStruct.factors(1),end);
   end
   PlotValidation(x,y,[],PlotStruct,ModelOut.data.dataset{1}.labobj{1},Axes)
   xlabel('T (A.U.)');
   ylabel('U (A.U.)');
   title(sprintf(['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - X / Y Scores: %i. LV'],PlotStruct.factors(1)),'fontname','arial','fontsize',10);
end
[Handle_Plot,Handle_Labels] = deal([]);
if any(strcmpi({'on','label','marker','number'},PlotStruct.visible))
   
   title(sprintf(['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - X / Y Scores: %i. LV'],PlotStruct.factors(1)),'fontname','arial','fontsize',10);
   x = ModelOut.model.xfactors{PlotStruct.nummode}(:,PlotStruct.factors(1));
   y = ModelOut.model.yfactors{PlotStruct.nummode}(:,PlotStruct.factors(1));
   xlabel('T (A.U.)');
   ylabel('U (A.U.)');
   if ~isempty(ModelOut.validation) & isequal(ModelOut.validation.method,'test')
      PlotModel(x,y,[],PlotStruct,ModelOut.data.dataset{1}(setdiff(1:size(ModelOut.data.dataset{1},1),ModelOut.validation.segments)).labobj{1},Axes)
   else
      PlotModel(x,y,[],PlotStruct,ModelOut.data.dataset{1}.labobj{1},Axes)
   end
   PlotTargetLine([x ones(size(x,1),1)]\y)
end
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127])
grid(PlotStruct.grid)
setappdata(Axes,'ModelOut',ModelOut)
return
