function [Axes,MO] = Plot_Predictions(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_Predictions (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the predicted values for new samples/batches according to what selected in the control figure
% opened with nPLS1PlotControls. The model predictions or the validation predictions (if present and
% applicable) are plot on top. as there are no measured values the predictions for the new samples/
% batches will lie on the diagonal. The choice of the LV derives automatically from
% ModelOut.model.nbfactors. For the axes specified by Axes the 'ModelOut' application-defined data is
% set, and it contains a copy of ModelOut.(employed by nPLS1DisplayInfo)
%  
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the model selected via the menus in the main window.
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes with the predictions.
% MO: empty
% 
% 
% Called by:
% Model_nPLS1\nPLS1ActivatePlots
% NB. The actual call is made from nPLS1Plot via feval and not from Model_nPLS1\nPLS1ActivatePlots.
% 
% 
% Subroutines:
% Internal: None
% External: npls1plotcontrols, plotmodel, plottargetline, plotvalidation
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 05-Dec-2002 17:40:38
%
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

Axes = [];
MO   = [];
MO   = [];
Axes = [];
if isempty(findobj(0,'type','figure','userdata','nPLS1 Plot Control'))
   %Called by the main window.
   PlotStruct.plotdims = 0;
   PlotStruct.nummode  = 1;
   if ~PlotStruct.factors(1)
      PlotStruct.factors(1) = 1;
   end
   [Nil,Pos]           = max(find([ModelOut.model.nbfactors]));
   ModelOut.model      = ModelOut.model(Pos);
   if ~isempty(ModelOut.validation)
      ModelOut.validation = ModelOut.validation(Pos);
   end
   H = nPLS1PlotControls(PlotStruct,ModelOut,MainFig,1);
   waitfor(H,'waitstatus','Ok')
   if ~ishandle(H)
      Axes = [];
      return
   else 
      PlotStruct = getappdata(H,'PlotStr');
   end
end
PlotStruct.plotdims = 2;
figure(MainFig)
Axes = axes('tag','cbaxes','nextplot','replacechildren');
% PlotStruct.visible = 'marker';
% PlotStruct.color   = 'r';
% PlotStruct.format  = [2 2];
if ~isempty(ModelOut.prediction)
   x = squeeze(ModelOut.prediction.ypred(:,1,end));
   y = squeeze(ModelOut.prediction.ypred(:,1,end));
   PlotValidation(x,y,[],PlotStruct,ModelOut.prediction.data.labobj{1},Axes)
   xlabel('Measured');
   ylabel('Predicted');
   title(sprintf(['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - Predictions: %i. LV'],ModelOut.prediction.nbfactors),'fontname','arial','fontsize',10);
end
[Handle_Plot,Handle_Labels] = deal([]);
if strcmpi(PlotStruct.visible,'off')
   PlotStruct.visible = 'on';
end
% PlotStruct.marker = 'o';
if any(strcmpi({'on','label','marker','number'},PlotStruct.visible))
   
   y = ModelOut.model.ypred;
   if ~isempty(ModelOut.validation) & strcmp(ModelOut.validation.method,'test')
      x = ModelOut.data.dataset{2}(setdiff(1:size(ModelOut.data.dataset{2},1),ModelOut.validation.segments)).data;
      PlotModel(x,y,[],PlotStruct,ModelOut.data.dataset{1}(setdiff(1:size(ModelOut.data.dataset{2},1),ModelOut.validation.segments)).labobj{1},Axes)
   else
      x = ModelOut.data.dataset{2}.data;
      PlotModel(x,y,[],PlotStruct,ModelOut.data.dataset{1}.labobj{1},Axes)
   end
   
end
PlotTargetLine([1,0]')
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127])
legend('Predictions','Model')
grid(PlotStruct.grid)
setappdata(Axes,'ModelOut',ModelOut)
return