function [Axes,MO] = Plot_Pred_Meas(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_Pred_Meas (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the predicted values versus the measured ones according to what selected in the control figure
% opened with nPLS1PlotControls. The choice of the LV is taken from PlotStruct.factors(1). This plot
% is not currently applied to the new data (see Plot_Predictions instead). For the axes specified by
% Axes the 'ModelOut' application-defined data is set, and it contains a copy of ModelOut.(employed by
% nPLS1DisplayInfo)
%  
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the model selected via the menus in the main window.
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes with the predicted vs measured plot.
% MO: empty
% 
% 
% Called by:
% Model_nPLS1\nPLS1ActivatePlots
% NB. The actual call is made from nPLS1Plot via feval and not from Model_nPLS1\nPLS1ActivatePlots.
% 
% 
% Subroutines:
% Internal: None
% External: npls1plotcontrols, plotmodel, plottargetline, plotvalidation, resamplingextract
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 16-Oct-2002 19:19:04
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 

MO   = [];
Axes = [];
if isempty(findobj(0,'type','figure','userdata','nPLS1 Plot Control'))
   %Called by the main window.
   PlotStruct.plotdims = 0;
   PlotStruct.nummode  = 1;
   if ~PlotStruct.factors(1)
      PlotStruct.factors(1) = 1;
   end
   [Nil,Pos]           = max(find([ModelOut.model.nbfactors]));
   ModelOut.model      = ModelOut.model(Pos);
   if ~isempty(ModelOut.validation)
      ModelOut.validation = ModelOut.validation(Pos);
   end
   H = nPLS1PlotControls(PlotStruct,ModelOut,MainFig);
   waitfor(H,'waitstatus','Ok')
   if ~ishandle(H)
      Axes = [];
      return
   else 
      PlotStruct = getappdata(H,'PlotStr');
   end
end
PlotStruct.plotdims = 2;
figure(MainFig)
Axes = axes('tag','cbaxes','nextplot','replacechildren');
if PlotStruct.additional.validation & (~isempty(ModelOut.validation) | ~isempty(ModelOut.prediction))
   
   if PlotStruct.additional.validation == 2 %Replicates
      
      if strcmp(ModelOut(1).validation.method,'rboo')
         y = squeeze(ModelOut.validation.ypred(:,1,:));
      else
         y = ResamplingExtract(ModelOut.validation.ypred,1,ModelOut.validation.segments);
      end
      x           = repmat(ModelOut.data.dataset{2}.data,1,size(y,2));
      x(isnan(y)) = NaN;
      
   elseif any(strcmp({'loo','test'},ModelOut.validation.method))
      x = ModelOut.data.dataset{2}.data;
      y = squeeze(ModelOut.validation.ypred(:,1,end));
   end
   PlotValidation(x,y,[],PlotStruct,ModelOut.data.dataset{1}.labobj{1},Axes)
   xlabel('Measured');
   ylabel('Predicted');
   title(sprintf(['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - X / Y Scores: %i. LV'],PlotStruct.factors(1)),'fontname','arial','fontsize',10);
   
end
[Handle_Plot,Handle_Labels] = deal([]);
if any(strcmpi({'on','label','marker','number'},PlotStruct.visible))
   
   title(sprintf(['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - Predictions: %i. LV'],PlotStruct.factors(1)),'fontname','arial','fontsize',10);
   if ~isempty(ModelOut.validation) & strcmp(ModelOut.validation.method,'test')
      x = ModelOut.data.dataset{2}(setdiff(1:size(ModelOut.data.dataset{2},1),ModelOut.validation.segments)).data;
   else
      x = ModelOut.data.dataset{2}.data;
   end
   y = ModelOut.model.ypred;
   xlabel('Measured');
   ylabel('Predicted');
   if ~isempty(ModelOut.validation) & isequal(ModelOut.validation.method,'test')
      PlotModel(x,y,[],PlotStruct,ModelOut.data.dataset{1}(setdiff(1:size(ModelOut.data.dataset{1},1),ModelOut.validation.segments)).labobj{1},Axes)
   else
      PlotModel(x,y,[],PlotStruct,ModelOut.data.dataset{1}.labobj{1},Axes)
   end
   
end
PlotTargetLine([1,0]')
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127])
grid(PlotStruct.grid)
setappdata(Axes,'ModelOut',ModelOut)
return