function [Axes,MO] = Plot_PRESS(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_PRESS (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the PRESS (Prediction REsiduals Sum of Squares) vs F of the selected model as a bar plot. If
% present, validation and prediction (only for X) PRESS are also plot along with the model. For the
% axes specified by Axes the 'ModelOut' application-defined data is set, and it contains a copy of
% ModelOut.(employed by nPLS1DisplayInfo) The distinction between X and Y is present in
% PlotStruct.additional.type2, which value is set by nPLS1Plot.
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the model selected via the menus in the main window.
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes where the PRESS is plot
% MO: empty
% 
% 
% Called by:
% Model_nPLS1\nPLS1ActivatePlots
% NB. The actual call is made from nPLS1Plot via feval and not from Model_nPLS1\nPLS1ActivatePlots.
% 
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:44:48
%
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

MO   = [];
Leg  = {'Calibration'};
Axes = axes('ydir','reverse','tag','cbaxes','nextplot','replacechildren');
switch PlotStruct.additional.type2
case 'X'
   T  = ['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - X '];
   y = [ModelOut.model.xcumpress]';
   if ~isempty(ModelOut(1).validation) & ~isempty(ModelOut(1).validation(1).xcumpress)
      y = [y,[ModelOut.validation.xcumpress]'];
      Leg(end + 1) = {'Validation'};
   end
   if ~isempty(ModelOut(1).prediction)
      y            = [y,ModelOut.prediction.xcumpress];
      Leg(end + 1) = {'Prediction'};
   end
case 'Y'
   T = ['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - Y '];
   y = [ModelOut.model.ycumpress]';
   if ~isempty(ModelOut(1).validation)
      y = [y,[ModelOut.validation.ycumpress]'];
      Leg(end + 1) = {'Validation'};
   end
end
x = [ModelOut.model(1).nbfactors - 1 ModelOut.model.nbfactors ModelOut.model(end).nbfactors + 1];
y = [NaN * ones(1,size(y,2));y; NaN * ones(1,size(y,2))];
if size(y,2) ~= length(Leg)
   Leg(size(y,2)+1:end) = [];
end
Handles = barh(x,y);
title(['\bfCumulated PRESS_' PlotStruct.additional.type2 ' vs \itF'],'fontname','arial','fontsize',10)
xlabel('Cum. PRESS','fontname','arial','fontsize',9)
ylabel('Model Complexity (\itF)','fontname','arial','fontsize',9);
legend(Handles,Leg{:},4)
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127])
setappdata(Axes,'ModelOut',ModelOut)
grid on
return
