function [Axes,MO] = Plot_Landscape(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_Landscape (PlotStruct,ModelOut,MainFig);
% 
% Description:
% It is active only when X is a three-way array. It plots the surface of either the residuals or the
% predictions for a certain sample/batch in the X array. In case of 'leave one out' validation it asks
% wheter the scores to plot are those from the model or the "predicted" ones obtained when the selected
% model was left out. For the axes specified by Axes the 'ModelOut' application-defined data is set,
% and it contains a copy of ModelOut.(employed by nPLS1DisplayInfo)
% 
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the model selected via the menus in the main window.
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes where the landscape is plot
% MO: empty
% 
% 
% Called by:
% Model_nPLS1\nPLS1ActivatePlots
% NB. The actual call is made from nPLS1Plot via feval and not from Model_nPLS1\nPLS1ActivatePlots.
% 
% 
% Subroutines:
% Internal: None
% External: selectmodel
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:45:32
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

MO            = [];
Rank          = 1;
Pos           = 1;
Axes          = [];
Model_Validat = 'calibration';
IndX          = repmat({':'},ndims(ModelOut.info.content),1);

if ~isempty(ModelOut.prediction)
   DS = ModelOut.prediction.data;
else
   DS = ModelOut.data.dataset{1};
end
if length(ModelOut.model) > 1
   Ranks      = [ModelOut.model.nbfactors]';
   [Rank,Pos] = SelectModel(Ranks);
   if ~Rank,return,end
end
if size(DS,1) > 1
   ListStr = DS.labels{1};
   if ~isempty(ModelOut.validation) & strcmp('test',ModelOut.validation(1).method) & isempty(ModelOut.prediction)
      for i = 1:length(ModelOut.validation(1).segments)
         ListStr{ModelOut.validation(1).segments(i)} = [ListStr{ModelOut.validation(1).segments(i)},' Test set'];
      end
   end
   ListProp    = {'selectionmode','single','name','Select sample','promptstring','Select sample'};
   if ~isempty(DS.userdata)
      ListProp{2} = 'multiple';
   end
   [Int,Ok] = listdlg('Liststring',ListStr,ListProp{:});
   if ~Ok,return,end
else
   Int = 1;
end
IndX{1} = Int;
if ~isempty(ModelOut.prediction)
   Model_Validat   = 'external set';
elseif ~isempty(ModelOut.validation)
   switch ModelOut.validation(1).method
   case 'loo'
      Model_Validat = questdlg('Choose predictions','Which scores shall be used?','Calibration','Validation','Cancel','Calibration');
      if strcmp(Model_Validat,'Cancel')
         return
      end
   case 'test'
      if any(ModelOut.validation(1).segments == Int)
         Model_Validat = 'validation';
      end
   end
end
switch lower(Model_Validat)
case 'calibration'
   z = squeeze(ModelOut.model(Pos).xpred(IndX{:}));
case 'validation' 
   z = squeeze(ModelOut.validation(Pos).xpred(IndX{:}));
case 'external set'
   z = squeeze(ModelOut.prediction(Pos).xpred(IndX{:}));
end
   
Axes = axes('tag','cbaxes','nextplot','replacechildren');
if strcmp(get(gcbo,'userdata'),'Residuals')
   title(['\bfResiduals for: ',DS(Int).labels{1}{1},' (',lower(Model_Validat),')'],'fontname','arial','fontsize',10);
else
   title(['\bfModel for: ',DS(Int).labels{1}{1},' (',lower(Model_Validat),')'],'fontname','arial','fontsize',10);
end
if ndims(ModelOut.info.content) == 3 & isequal(ModelOut(1).modelname,'PLS')
   z = reshape(z,size(ModelOut.info.content,2),size(ModelOut.info.content,3));
   if strcmp(get(gcbo,'userdata'),'Residuals')
      z = reshape(squeeze(DS(Int).data),size(ModelOut.info.content,2),size(ModelOut.info.content,3)) - z;
   end
   x    = ModelOut.info.content.scalars{3};
   y    = ModelOut.info.content.scalars{2};
   xlabel(ModelOut.info.content.axislabels{3},'fontname','arial','fontsize',9);
   ylabel(ModelOut.info.content.axislabels{2},'fontname','arial','fontsize',9);
   Handle = surfl(x,y,z);
   colormap gray
elseif ndims(ModelOut.info.content) == 2 & ndims(DS) == 2
   if strcmp(get(gcbo,'userdata'),'Residuals')
      z = squeeze(DS(Int).data) - z;
   end
   x    = DS.scalars{2};
   Handle = plot(x,z);
   view(2)
elseif ndims(DS) == 3
   if strcmp(get(gcbo,'userdata'),'Residuals')
      z = squeeze(DS(Int).data) - z;
   end
   x    = DS.scalars{3};
   y    = DS.scalars{2};
   xlabel(DS.axislabels{3},'fontname','arial','fontsize',9);
   ylabel(DS.axislabels{2},'fontname','arial','fontsize',9);
   Handle = surfl(x,y,z);
   colormap gray
end
set(Handle,'marker','none')
zlabel('A.U.','fontname','arial','fontsize',9)
axis tight
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127])
ModelOut.model = ModelOut.model(Pos);
   if ~isempty(ModelOut.validation)
   ModelOut.validation = ModelOut.validation(Pos);
end
setappdata(Axes,'ModelOut',ModelOut)
return
