function [Axes,MO] = Plot_Explained_Variance(PlotStruct,ModelOut,MainFig)
% function [Axes,MO] = Plot_Explained_Variance (PlotStruct,ModelOut,MainFig);
% 
% Description:
% Plots the  %EV (% Explained Variation) vs F of the selected model as a bar plot. If present, validation and prediction (only for X) %EV are also plot along with the model. For the axes specified by Axes the 'ModelOut' application-defined data is set, and it contains a copy of ModelOut.(employed by nPLS1DisplayInfo)
% The distinction between X and Y is present in PlotStruct.additional.type2, which value is set by nPLS1Plot.
% 
% Inputs: 
% PlotStruct: PlotStruct structure
% ModelOut: ModelOut structure for the model selected via the menus in the main window.
% MainFig: main figure handle
% 
% 
% Outputs:
% Axes: handle of the axes where the %EV is plot
% MO: empty
% 
% 
% Called by:
% Model_nPLS1\nPLS1ActivatePlots
% NB. The actual call is made from nPLS1Plot via feval and not from Model_nPLS1\nPLS1ActivatePlots.
% 
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:44:34
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

MO   = [];
Axes = axes('tag','cbaxes','nextplot','replacechildren');
Leg  = {'Calibration'};
switch PlotStruct.additional.type2
case 'X'
   T  = ['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - X '];
   y = [ModelOut.model.xev]';
   if ~isempty(ModelOut(1).validation) & ~isempty(ModelOut(1).validation(1).xev)
      y = [y,[ModelOut.validation.xev]'];
      Leg(end + 1) = {'Validation'};
   end
   if ~isempty(ModelOut(1).prediction)
      y            = [y,ModelOut.prediction.xev];
      Leg(end + 1) = {'Prediction'};
   end
case 'Y'
   T = ['\\bf',ModelOut.data.dataset{2}.labels{2}{1},' - Y '];
   y = [ModelOut.model.yev]';
   if ~isempty(ModelOut(1).validation)
      y = [y,[ModelOut.validation.yev]'];
      Leg(end + 1) = {'Validation'};
   end
end
x = [ModelOut.model(1).nbfactors - 1 ModelOut.model.nbfactors ModelOut.model(end).nbfactors + 1];
y = [NaN * ones(1,size(y,2));y; NaN * ones(1,size(y,2))];
if size(y,2) ~= length(Leg)
   Leg(size(y,2)+1:end) = [];
end
Handles = bar(x,y);
title(['\bf' PlotStruct.additional.type2 ' Explained Variation vs \itF'],'fontname','arial','fontsize',10)
ylabel('Explained Variation (%)','fontname','arial','fontsize',9)
xlabel('Model Complexity (\itF)','fontname','arial','fontsize',9);
legend(Handles,Leg{:},4)
if min(y)<0;Ay(1) = 1.03*min(y(:));else;Ay(1) = 0.97*min(y(:));end
if max(y)<0;Ay(2) = 0.97*max(y(:));else;Ay(2) = min(100,1.03*max(y(:)));end
if Ay(1)==Ay(2);Ay(1)=Ay(1)-0.5;Ay(2)=Ay(2)+0.5;end
Ax = get(Axes,'xlim');
set(Axes,'position',[0.2464,0.0377,0.7312,0.9127],'ylim',Ay,'xlim',Ax)
setappdata(Axes,'ModelOut',ModelOut)
grid on
return