function ModelIn = InitModelIn(ModelIn)
% function ModelIn = InitModelIn (ModelIn);
% 
% Description:
% Checks that the ModelIn structure is compatible with nPLS1Model.
% 
% Inputs: 
% ModelIn: ModelIn structure prior to possible corrections.
% 
% 
% Outputs:
% ModelIn: corrected (if necessary) ModelIn structure
% 
% 
% Called by:
% nPLS1Model
% 
% Subroutines:
% Internal: None
% External: parafac
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 29-Oct-2002 09:27:04
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if length(ModelIn.nbfactors.min) > 1
   ModelIn.nbfactors.min = min(ModelIn.nbfactors.min(:));
end
if ~isempty(ModelIn.nbfactors.min) & isempty(ModelIn.nbfactors.max)
   ModelIn.nbfactors.max = ModelIn.nbfactors.min + 1;
end
if isempty(ModelIn.nbfactors.min)
   ModelIn.nbfactors.min = 1;
end
if length(ModelIn.nbfactors.max) > 1
   ModelIn.nbfactors.max = max(ModelIn.nbfactors.max(:));
end
Avail_Val = {'loo','nboo','test'};
if length(ModelIn.sam(1).cen) ~= 2
   ModelIn.sam(1).cen(2) = ModelIn.sam(1).cen(1);
end
if length(ModelIn.sam(1).cen) ~= 2
   ModelIn.sam(1).cen(2) = ModelIn.sam(1).cen(1);
end
if ~isempty(ModelIn.valmethod.name)
   switch ModelIn.valmethod.name
   case {'loo','test'}
      [ModelIn.valmethod.segments,ModelIn.valmethod.replicates] = deal([]);
   case {'nboo','rboo'}
      ModelIn.segments   = [];
      if ~isa(ModelIn.valmethod.replicates,'double')
         ModelIn.valmethod.replicates = [];
      end
   end
else
   ModelIn.valmethod = struct('bootstrap',[],'name',[],'replicates',[],'segments',[]);
end