function Check(ModelIn,CVHan)
% function Check (ModelIn,CVHan);
% 
% Description:
% Activates or deactivates the menus of the nPLS1Model window depending on the content of the ModelIn
% structure. This function is called after any even occurs in such window. For example when the user
% activates the Bootstrap option the relative menus are activated by this function together with the
% edit-uicontrol to insert the number of replicates for the method.
% 
% Inputs: 
% ModelIn: ModelIn structure
% CVHan  : structure with the handles to the objects within the nPLS1Model window (only those that
%          require action in case of an event)
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% Model_nPLS1\nPLS1Model
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 27-Oct-2002 09:36:16
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 

set(CVHan.stbutton,'enable','off')
X = getappdata(ModelIn.xpointer,'X');
Flag = ~isempty(X{1}.userdata);
if ~isempty(ModelIn.valmethod.name)
   set([CVHan.meth,CVHan.segments,CVHan.segmed,CVHan.replicat,CVHan.repled,CVHan.method],'enable','on')
   switch ModelIn.valmethod.name
   case 'loo'
      set([CVHan.segmed,CVHan.segments],'visible','on')
      set([CVHan.repled,CVHan.replicat],'visible','off')
      set(CVHan.boomen,'enable','off')
      set(CVHan.meth(1),'value',1)
      set(CVHan.meth(2:3),'value',0)
      
   case 'test'
      set([CVHan.segmed,CVHan.segments,CVHan.repled,CVHan.replicat],'visible','off')
      set(CVHan.boomen,'enable','off')
      set(CVHan.meth(3),'value',1)
      set(CVHan.meth(1:2),'value',0)
      
   case {'nboo','rboo'}
      set([CVHan.segmed,CVHan.segments],'visible','off')
      set([CVHan.repled,CVHan.replicat],'visible','on')
      set(CVHan.boomen,'enable','on')
      set(CVHan.meth(2),'value',1)
      set(CVHan.meth([1 3]),'value',0)
      if strcmp(ModelIn.valmethod.name,'nboo')
         set(CVHan.booc(1),'checked','on')
         set(CVHan.booc(2),'checked','off')
      else
         set(CVHan.booc(2),'checked','on')
         set(CVHan.booc(1),'checked','off')
      end
      
   end
   gr  = [0 0];
   for i = 1:length(ModelIn.sam)
      gr(i,:) = ModelIn.sam(i).sel.dims;
   end
   if any(gr(:,2));
      set(CVHan.meth(3),'enable','on')
   else
      set(CVHan.meth(3),'enable','off')
   end
   set(CVHan.val,'value',1)
   
else
   set([CVHan.meth,CVHan.boomen,CVHan.segments,CVHan.segmed,CVHan.replicat,CVHan.repled,CVHan.method],'enable','off')
   set([CVHan.segmed,CVHan.segments,CVHan.repled,CVHan.replicat],'visible','off')
   set(CVHan.val,'value',0)   
end
if ~get(CVHan.meth(2),'value')
   set(CVHan.boomen,'enable','off')
end
if ~isempty(ModelIn.nbfactors.min)
   if ~isempty(ModelIn.valmethod.name)
      switch ModelIn.valmethod.name
      case 'loo'
         set(CVHan.stbutton,'enable','on')
      case 'test'
         set(CVHan.stbutton,'enable','on')
      case {'nboo','rboo'}
         if ~isempty(ModelIn.valmethod.replicates)
            set(CVHan.stbutton,'enable','on')
         end
      end
   else
      set(CVHan.stbutton,'enable','on')
   end
end
