function ModelOut = Calculate(ModelIn,ModelName)
% function ModelOut = Calculate (ModelIn,ModelName);
% 
% Description:
% Fills in the ModelOut structure and calls the adequate functions for fitting and validating an nPLS
% or PLS model.
% 
% Inputs: 
% ModelIn  : ModelIn structure
% ModelName: 'nPLS' or 'PLS' depending on the desired model
% 
% 
% Outputs:
% ModelOut: ModelOut structure
% 
% 
% Called by:
% Model_nPLS1\nPLS1Model
% 
% Subroutines:
% Internal: None
% External: definearray, definemodelout, fitmodel, nplsfit, nplspred, nshape,  unfoldcbdataset,
%           validatemodel
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 04-Nov-2002 10:41:48
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

ModelOut            = DefineModelOut;
ModelOut.modelname  = ModelName;
ModelOut.prediction = [];

%Define array
[X,a,b,Vars] = DefineArray(ModelIn,1,1);
Y = DefineArray(ModelIn,2,1);
if isa(X{1},'cell')
   X{1} = cat(1,X{1}{:});
   Y{1} = cat(1,Y{1}{:});
end

%[Vars{1:2}]   = deal(Vars1{1},Vars2{2});
if strcmp(ModelName,'PLS')
   FitFun       = 'plsfit';      %Implemented this way so that other algorithm and m-files can be employed in the future
   PredFun      = 'plspred';
   %X{1} = nshape(X{1},1);
else
   FitFun       = 'nplsfit';      %Implemented this way so that other algorithm and m-files can be employed in the future
   PredFun      = 'nplspred';
end
Y{1} = nshape(Y{1},1);
%Handle preprocessing
a            = struct('cen',[ModelIn.sam(1).cen(1) ModelIn.var(1).cen],'scal',[ModelIn.sam(1).scal(1) ModelIn.var(1).scal]);
b            = struct('cen',[ModelIn.sam(1).cen(2) ModelIn.var(2).cen],'scal',[ModelIn.sam(1).scal(2) ModelIn.var(2).scal]);
PreProcess   = struct('modx',a,'mody',b);
h            = waitbar(0,'Please wait...');
Tot          = size(Y{1},2)*length(ModelIn.nbfactors.min:max([ModelIn.nbfactors.min,ModelIn.nbfactors.max]));
Count        = 0;
for i = 1:size(Y{1},2)
   for f = ModelIn.nbfactors.min:max([ModelIn.nbfactors.min,ModelIn.nbfactors.max])
      ModelOut(i,1).model(f - ModelIn.nbfactors.min + 1) = FitModel(FitFun,PredFun,X{1},Y{1}(:,i),f,PreProcess,NaN);
      if ~isempty(ModelIn.valmethod.name) 
         switch ModelIn.valmethod.name
         case 'loo'
            ModelOut(i,1).validation(f - ModelIn.nbfactors.min + 1) = ValidateModel(FitFun,PredFun,X{1},Y{1}(:,i),f,ModelIn.valmethod.name,PreProcess,[],NaN);
         case {'nboo','rboo'}
            ModelOut(i,1).validation(f - ModelIn.nbfactors.min + 1) = ValidateModel(FitFun,PredFun,X{1},Y{1}(:,i),f,ModelIn.valmethod.name,PreProcess,[],ModelIn.valmethod.replicates,NaN);
         case {'test'}
            Xt                                                      = DefineArray(ModelIn,1,0);
            Yt                                                      = DefineArray(ModelIn,2,0);
            %if strcmp(ModelName,'PLS')
            %   Xt{1} = nshape(Xt{1},1);
               Yt{1} = nshape(Yt{1},1);
            %end
            [nil,Sam]                                               = intersect(ModelIn.sam(1).sel.sel{1:2},ModelIn.sam(1).sel.sel{2});
            ModelOut(i,1).validation(f - ModelIn.nbfactors.min + 1) = ValidateModel(FitFun,PredFun,Xt{1},Yt{1}(:,i),f,ModelIn.valmethod.name,PreProcess,[],Sam,ModelOut(i,1).model(f - ModelIn.nbfactors.min + 1),NaN);
         end
         ModelOut(i,1).validation(f - ModelIn.nbfactors.min + 1).nbfactors = ModelOut(i,1).validation(f - ModelIn.nbfactors.min + 1).nbfactors(1); 
      else
         ModelOut(i,1).validation = [];
      end
      Count = Count + 1;
      waitbar(Count/Tot,h)
   end
   if strcmp(ModelIn.valmethod.name,'test')
      DS2  = DefineArray(ModelIn,2,0,1);
      Bts  = ModelIn.sam(1).sel.sel{1:2};
   else
      DS2  = DefineArray(ModelIn,2,1,1);
      Bts  = ModelIn.sam(1).sel.sel{1};
   end
   DS2      = DS2{1}(:,i);
   DS2.name = char(DS2.labels{2});
   ModelOut(i,1).data      = struct('batches',{{Bts}},'dataset',{{[],DS2}},'variables',{Vars{1}});
   ModelOut(i,1).modelname = ModelName;
end
close(h)
if strcmp(ModelIn.valmethod.name,'test')
   ModelOut(1).data.dataset(1) = DefineArray(ModelIn,1,0,1);
else
   ModelOut(1).data.dataset(1) = DefineArray(ModelIn,1,1,1);
end
[ModelOut(1:length(ModelOut)).info] = deal(struct('content',dscontent(ModelOut(1).data.dataset{1}),...
                          'fillin','Current deviation',...
                          'preprocess',PreProcess,...
                          'initialsize',size(ModelOut(1).data.dataset{1},ndims(ModelOut(1).data.dataset{1}))));
if strcmp(ModelName,'PLS') & ndims(ModelOut(1).info.content) ~= 2
   ModelOut(1).data.dataset{1} = unfoldcbdataset(ModelOut(1).data.dataset{1});
end

return