function Model_Parameters = nPLSFit(X,Y,F,varargin)
% function Model_Parameters = nPLSFit (X,Y,F,varargin);
% 
% Description:
% Fit_Fun fitting the nPLS1 model to the array X trying to predict Y using the npls algorithm of the
% NWay toolbox.
% 
% Inputs: 
% X       : double array of predictors
% Y       : double vector of predictands
% F       : number of latent variables to extract.
% varargin: not in use
% 
% 
% Outputs:
% Model_Parameters: Insert description
% 
% 
% Called by:
% Model_nPLS1\Calculate via Fit_Fun fitting the PARAFAC model to the array X using an ALS algorithm (
% the NWay toolbox implementation).
% 
% 
% Subroutines:
% Internal: None
% External: npls
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21-Aug-2002 21:37:12
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

[Model_Parameters.xfactors,Model_Parameters.yfactors,Model_Parameters.core,Model_Parameters.bcoeff,P] = npls(X,Y,F,varargin{:});
IndY                                                                                                  = repmat({':'},ndims(Y)-1,1);
if isa(P,'cell')
   Model_Parameters.ypred = P{F};
else  
   Model_Parameters.ypred = P(IndY{:},F);
end
Model_Parameters.core      = Model_Parameters.core{F};
Model_Parameters.nbfactors = F;
