function nPLS1Report(MainFig,ReportStruct,Fil_id)
% function nPLS1Report (MainFig,ReportStruct,Fil_id);
% 
% Description:
% Handles the report for the Model/Validation/Projection parts when the current model (i.e. the model
% saved in the 'Results' application-defined data of the main figure) is either nPLS1 or PLS. The parts
% to report are defined in the ReportStruct structure, which is passed by the calling function.
% 
% Inputs: 
% MainFig     : handle to the main figure
% ReportStruct: ReportStruct structure, with flags relative to which information should be saved in the
%               .txt file
% Fil_id      : handle to the .txt file
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% SaveReport
% 
% Subroutines:
% Internal: None
% External: getcvdata, nshape
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 04-Nov-2002 11:21:02
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 

ModelOut = getcvdata(MainFig,'Results');
if any(ReportStruct.m_info)

   %Model info and name
   
   fwrite(Fil_id,[10 'Model               : '],'char');
   fwrite(Fil_id,[ModelOut(1).modelname 10],   'char');
   fwrite(Fil_id,['Number of factors   : '],                    'char');
   fwrite(Fil_id,[sprintf(' %i',[ModelOut(1).model.nbfactors]),10 10],'char');
   %Preprocessing. NB the different scalings are not distinguished
   fwrite(Fil_id,[   'Preprocessing'                 10],'char');
   fwrite(Fil_id,[   'Centring'                      10],'char');
   fwrite(Fil_id,[   'X                   : '   ],       'char');
   fwrite(Fil_id,[int2str(ModelOut(1).info.preprocess.modx.cen(:)') 10],'char');
   fwrite(Fil_id,[   'Y                   : '   ],       'char');
   fwrite(Fil_id,[int2str(ModelOut(1).info.preprocess.mody.cen(:)') 10],'char');
   fwrite(Fil_id,[   'Scaling'                       10],'char');
   fwrite(Fil_id,[   'X                   : '   ],       'char');
   fwrite(Fil_id,[int2str(ModelOut(1).info.preprocess.modx.scal(:)') 10],'char');
   fwrite(Fil_id,[   'Y                   : '   ],       'char');
   fwrite(Fil_id,[int2str(ModelOut(1).info.preprocess.mody.scal(:)') 10],'char');
   
end
if any(ReportStruct.v_info)
   
   %Validation info
   fwrite(Fil_id,[10 10],'char');
   fwrite(Fil_id,['Validation',10],'char');
   fwrite(Fil_id,['Method              : '],'char');
   fwrite(Fil_id,[ModelOut(1).validation(1).method 10],'char');
   %Segments composition
   if strcmp(ModelOut(1).validation(1).method,'test')
      fwrite(Fil_id,['Test set (samples/batches position within ModelOut.data.dataset)',10],'char');
   else
      fwrite(Fil_id,['Segments (samples/batches position within ModelOut.data.dataset)',10],'char'); 
   end
   Mat = num2str(ModelOut(1).validation(1).segments);
   Mat = [Mat,10 * ones(size(Mat,1),1)]';
   fwrite(Fil_id,Mat,'char');
   
end

for k = 1:length(ModelOut)
   
   for i = 1:length(ModelOut(k).model)

      if any(ReportStruct.m_results);

         fwrite(Fil_id,[10 10],'char');
         fwrite(Fil_id,['Model Results',10],'char');
         fwrite(Fil_id,['Y Variable           : '],'char');
         fwrite(Fil_id,[ModelOut(k).data.dataset{2}.labels{2}{1} 10],'char');
         fwrite(Fil_id,['Number of LV         : '],'char');
         fwrite(Fil_id,[int2str(ModelOut(k).model(i).nbfactors),10],    'char');
         fwrite(Fil_id,['X Explained variation: '],'char');
         fwrite(Fil_id,[sprintf('%3.2f%%',ModelOut(k).model(i).xev),10],'char');
         fwrite(Fil_id,['X RMSE               : '],'char');
         fwrite(Fil_id,[sprintf('%3.2f',ModelOut(k).model(i).xrmse),10],'char');
         fwrite(Fil_id,['Latent Variables',10],'char');
         for j = 1:length(ModelOut(k).model(i).xfactors)

            fwrite(Fil_id,sprintf('Mode [%i] - ',j),'char');
            fwrite(Fil_id,ModelOut(1).data.dataset{1}.modenames{j},'char');
            fwrite(Fil_id,[': ' 10],'char');
            Mat = num2str(ModelOut(k).model(i).xfactors{j});
            Mat = [Mat,10 * ones(size(Mat,1),1)]';
            fwrite(Fil_id,Mat,'char');
            fwrite(Fil_id,[10 10],'char');

         end
         %Core
         fwrite(Fil_id,['Unfolded core (I x JK...)',10],'char');
         Mat = num2str(nshape(ModelOut(k).model(i).core,1));
         Mat = [Mat,10 * ones(size(Mat,1),1)]';
         fwrite(Fil_id,Mat,'char');
         fwrite(Fil_id,[10 10],'char');
         %Coefficients
         fwrite(Fil_id,['Regression coefficients',10],'char');
         Mat = num2str(ModelOut(k).model(i).bcoeff);
         Mat = [Mat,10 * ones(size(Mat,1),1)]';
         fwrite(Fil_id,Mat,'char');
         fwrite(Fil_id,[10 10],'char');
         %Y 
         fwrite(Fil_id,['Y Explained variation: '],'char');
         fwrite(Fil_id,[sprintf('%3.2f%%',ModelOut(k).model(i).yev),10],'char');
         fwrite(Fil_id,['Y RMSE              : '],'char');
         fwrite(Fil_id,[sprintf('%3.2f',ModelOut(k).model(i).yrmse),10],'char');
         for j = 1:length(ModelOut(k).model(i).yfactors)

            fwrite(Fil_id,sprintf('Mode [%i] - ',j),'char');
            fwrite(Fil_id,ModelOut(k).data.dataset{2}.modenames{j},'char');
            fwrite(Fil_id,[': ' 10],'char');
            Mat = num2str(ModelOut(k).model(i).yfactors{j});
            Mat = [Mat,10 * ones(size(Mat,1),1)]';
            fwrite(Fil_id,Mat,'char');
            fwrite(Fil_id,[10 10],'char');

         end
         %Predictions
         if ~isempty(ModelOut(k).validation) & isequal(ModelOut(k).validation(i).method,'test')
            Fic = setdiff(1:size(ModelOut(k).data.dataset{2},1),ModelOut(k).validation(i).segments);
            r2 = corrcoef(ModelOut(k).model(i).ypred,ModelOut(k).data.dataset{2}(Fic).data);
         else
            r2 = corrcoef(ModelOut(k).model(i).ypred,ModelOut(k).data.dataset{2}.data);
         end
         fwrite(Fil_id,['Predictions for ',ModelOut(k).data.dataset{2}.labels{2}{1}],'char');
         fwrite(Fil_id,[' (Correlation: ',num2str(r2(2)),')',10],'char');
         Mat = num2str(ModelOut(k).model(i).ypred);
         Mat = [Mat,10 * ones(size(Mat,1),1)]';
         fwrite(Fil_id,Mat,'char');
         fwrite(Fil_id,[10 10],'char');

      end
      if any(ReportStruct.v_results);

         if ~any(ReportStruct.m_results),fwrite(Fil_id,[10 10],'char');end
         fwrite(Fil_id,['Validation Results',10],'char');
         switch ModelOut(k).validation(1).method
            case {'test','loo'}
               fwrite(Fil_id,['X Explained variation: '],'char');
               fwrite(Fil_id,sprintf(['%3.2f%%', 10],ModelOut(k).validation(i).xev),'char');
               fwrite(Fil_id,['X RMSE               : '],'char');
               fwrite(Fil_id,[sprintf('%3.2f',ModelOut(k).validation(i).xrmse),10],'char');
               fwrite(Fil_id,['Factors',10],'char');
               fwrite(Fil_id,sprintf('Mode [%i] - ',1),'char');
               fwrite(Fil_id,[ModelOut(1).data.dataset{1}.modenames{1} 10],'char');
               T   = ModelOut(k).validation(i).xfactors;
               if strcmp(ModelOut(k).validation(1).method,'loo') 
                  Mat = num2str(squeeze(T{1}(:,:,end)));
               else
                  Mat = num2str(squeeze(T{1}(ModelOut(k).validation(1).segments,:,end)));
               end
               Mat = [Mat,10 * ones(size(Mat,1),1)]';
               fwrite(Fil_id,Mat,'char');
               %Y 
               fwrite(Fil_id,10,'char');
               fwrite(Fil_id,['Y Explained variation: '],'char');
               fwrite(Fil_id,[sprintf('%3.2f%%',ModelOut(k).validation(i).yev),10],'char');
               fwrite(Fil_id,['Y RMSE               : '],'char');
               fwrite(Fil_id,[sprintf('%3.2f',ModelOut(k).validation(i).yrmse),10],'char');
               %Predictions
               T   = ModelOut(k).validation(i).ypred;
               if strcmp(ModelOut(k).validation(1).method,'loo') 
                  T   = squeeze(T(:,:,end));
                  Fic = 1:size(ModelOut(k).data.dataset{2},1);
               else
                  T   = squeeze(T(ModelOut(k).validation(1).segments,:,end));
                  Fic = ModelOut(k).validation(i).segments;
               end
               if length(Fic) > 2
                  r2 = corrcoef(T,ModelOut(k).data.dataset{2}(Fic).data);
               else
                  r2 = NaN * ones(2);
               end
               fwrite(Fil_id,['Predictions for ',ModelOut(k).data.dataset{2}.labels{2}{1}],'char');
               fwrite(Fil_id,[' (Correlation: ',num2str(r2(2)),')',10],'char');
               Mat = num2str(T);
               Mat = [Mat,10 * ones(size(Mat,1),1)]';
               fwrite(Fil_id,Mat,'char');
               fwrite(Fil_id,[10 10],'char');

            case {'nboo','rboo'}
               fwrite(Fil_id,['No additional info available yet for bootstrap',10],'char');
               fwrite(Fil_id,[10 10],'char');

         end

      end

   end
   if any(ReportStruct.p_results) & ~isempty(ModelOut(k).prediction);
   
      fwrite(Fil_id,['Projection Results',10],                             'char');
      fwrite(Fil_id,['Number of factors   : '],                            'char');
      fwrite(Fil_id,[sprintf(' %i',[ModelOut(k).prediction.nbfactors]),10],'char');
      fwrite(Fil_id,'Fill in             :  ','char');
      if ModelOut(k).info.initialsize ~= size(ModelOut(k).prediction.data,ndims(ModelOut(k).prediction.data))
         fwrite(Fil_id,[ModelOut(k).info.fillin,10],                       'char');
         fwrite(Fil_id,['Initial Length      :  '],                        'char');
         fwrite(Fil_id,[sprintf('%i',ModelOut(k).info.initialsize),10],    'char');
      else
         fwrite(Fil_id,['None',10],'char');
      end
      fwrite(Fil_id,['Explained variation : '],'char');
      fwrite(Fil_id,sprintf(['%3.2f%%', 10],ModelOut(k).prediction.xev),'char');
      fwrite(Fil_id,['X RMSE              : '],'char');
      fwrite(Fil_id,[sprintf('%3.2f',ModelOut(k).prediction.xrmse),10],'char');
      fwrite(Fil_id,['Factors',10],'char');
      fwrite(Fil_id,sprintf('Mode [%i] - ',1),'char');
      fwrite(Fil_id,ModelOut(1).data.dataset{1}.modenames{1},'char');
      fwrite(Fil_id,[': ' 10],'char');
      Mat = num2str(ModelOut(k).prediction.xfactors{1});
      Mat = [Mat,10 * ones(size(Mat,1),1)]';
      fwrite(Fil_id,Mat,'char');
      fwrite(Fil_id,[10 10],'char');
      
   end

end
return