function nPLS1Plot(FigHandle,MainFig);
% function nPLS1Plot (FigHandle,MainFig);
% 
% Description:
% Handles the plotting functions for the desired (n)PLS1 model. It checks the PlotStruct structure and
% the position of the plotting axes within the figure. The plotting functions are called via feval and
% the name of the function to call is stored in the
% menu's tag. If the plotting function returns a non-empty ModelOut structure, the latter is saved in t
% Results'). This feature allows saving the statistics when they are computed. If FigHandle is 'default
% plot' and MainFig is a ModelOut structure the default plot (i.e. the Y explained variation of the
% first selected Y-variable, in general, or the X explained variation, after projection) is shown.
% NB The double handle is necessary as the call may occur from two different windows (the main and the
% one created by Model_nPLS1\nPLS1PlotControls).
% 
% Inputs: 
% FigHandle: handle to the figure with the ModelOut structure or 'defaultplot'
% MainFig: if not inserted is set to FigHandle. Otherwise it is the handle to the main figure, or, in the default plot case it is a ModelOut structure).
% 
% Outputs:
% None
% 
% 
% Called by:
% DefaultPlot, Model_nPLS1\nPLS1ActivatePlots, Model_nPLS1\nPLS1PlotControls
% NB. The call is made from the base work-space and not from Model_nPLS1\nPLS1ActivatePlots. The latter
%     function defines nPLS1Plot(MainFig) as the callback function for the plotting menus.
% 
% Subroutines:
% Internal: None
% External: checkaxes, checkplotstruct, getcvdata, npls1displayinfo, resizecubatch
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 15-Oct-2002 12:17:44
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

if ishandle(FigHandle)
   if nargin < 2 %The function is called from the main window
      MainFig = FigHandle;
   end 
   [ModelOut,PlotStruct] = getcvdata(FigHandle,'Results','PlotStr');   
elseif strcmp(FigHandle,'defaultplot')
   
   if nargin < 2 | ~isa(MainFig,'struct') 
      uiwait(warndlg('Something''s gone wrong!'))
   else %Default plot
      
      %Explained variance on the first Y variable or on X on the projection
      colormap jet
      ModelOut = MainFig;
      MainFig  = findobj('type','figure','userdata','Cubatch');
      delete(findobj(MainFig,'type','axes','tag','cbaxes'))
      a = 1;
      if strcmp(get(gcbo,'type'),'uimenu') & strcmp(get(get(gcbo,'parent'),'label'),'Projection') 
         %Projection
         a = get(gcbo,'userdata');
         %ModelOut(a).plot.additional.type2 = 'X';
      end
      if ~isempty(ModelOut(a).prediction)
         ModelOut(a).plot.additional.type2 = 'X';
      else
         ModelOut(a).plot.additional.type2 = 'Y';
      end
      ModelOut(a).data = ModelOut(1).data;
      Ax = Plot_Explained_Variance(ModelOut(a).plot,ModelOut(a),findobj('type','figure','userdata','Cubatch'));
      nPLS1DisplayInfo(MainFig,getappdata(Ax,'ModelOut'))
      CheckAxes(MainFig)
      setappdata(MainFig,'PlotStr',ModelOut(a).plot)
      
   end
   return
   
else 
   uiwait(warndlg('Something''s gone wrong!'))
   return
end
if isa(PlotStruct,'struct') %Draw new plot
   
   [PlotStruct] = CheckPlotStruct(PlotStruct,MainFig);
   figure(MainFig)
   delete(findobj(MainFig,'type','axes','tag','cbaxes'))
   if strcmp(get(gcbo,'type'),'uimenu')
      CurrObj = gcbo;
      while ~strcmp(get(CurrObj,'tag'),'Variable Menu')
         CurrObj = get(CurrObj,'parent');
      end
      ModelOut(get(CurrObj,'userdata')).data.dataset{1} = ModelOut(1).data.dataset{1};
      ModelOut(get(CurrObj,'userdata')).info.content    = ModelOut(1).info.content;
      ModelOut                                          = ModelOut(get(CurrObj,'userdata'));         %select the variable
   end
   if ~isempty(findobj(0,'type','figure','userdata','nPLS1 Plot Control')) & strcmp(get(gcbo,'type'),'uimenu')
      delete(findobj(0,'type','figure','userdata','nPLS1 Plot Control'))
   end
   colormap jet
   [Handle_Axes,MO] = feval(PlotStruct.type,PlotStruct,ModelOut,MainFig);
   if ~isempty(Handle_Axes)
      
      if ~isempty(MO)
         if get(CurrObj,'userdata') ~= 1
            MO.data.dataset{1} = [];
         end
         ModelOut                          = getappdata(MainFig,'Results');
         ModelOut(get(CurrObj,'userdata')) = MO;
         setappdata(MainFig,'Results',ModelOut);
      end
      nPLS1DisplayInfo(MainFig,getappdata(Handle_Axes,'ModelOut'))
      CheckAxes(MainFig)
      setappdata(MainFig,'PlotStr',PlotStruct)
      
   end
   if ~isempty(Handle_Axes)
      if length(Handle_Axes) == 2 
         if get(CurrObj,'userdata') ~= 1
            Handle_Axes{2}.data = [];
         end
         ModelOut = getappdata(MainFig,'Results');
         ModelOut(get(CurrObj,'userdata')) = Handle_Axes{2};
         setappdata(MainFig,'Results',ModelOut);
         Handle_Axes = Handle_Axes{1};
      end
      nPLS1DisplayInfo(MainFig,getappdata(Handle_Axes,'ModelOut'))
      CheckAxes(MainFig)
      setappdata(MainFig,'PlotStr',PlotStruct)
   end
   %Bug fix for 6.1: if an object is edited this function name is lost if the axes is manipulated by the user...
   set(MainFig,'ResizeFcn','ResizeCuBatch(NaN);')
   
end