function [ModelIn,ModelOut] = nPLS1Model(ModelIn,ModelName)
% function [ModelIn,ModelOut] = nPLS1Model (ModelIn,ModelName);
% 
% Description:
% Creates a figure and handles the corresponding events for computing a PLS1 or nPLS1 for the selected
% variables in Y using the selected variables in X. If the 'Cancel' button is pressed ModelIn is
% returned empty.
% 
% Inputs: 
% ModelIn: ModelIn structure
% ModelName: 'PLS1'/'nPLS1'
% 
% 
% Outputs:
% ModelIn: ModelIn structure
% ModelOut: ModelOut structure
% 
% Called by:
% Dispatch_Compute
% 
% Subroutines:
% Internal: None
% External: calculate, cenwindow, check, ctag, cval, defcontrols, getcvdata, guinames, initmodelin,
%           npls1model, preprocess, setcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 02-Nov-2002 18:58:54
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

GuiNames

if isa(ModelIn,'struct')

   h       = CenWindow(WIC,[ModelName,' Model'],'nPLS1Model(NaN);',385,238);
   set(h,'toolbar','none')
   ModelIn = InitModelIn(ModelIn);
   CVHan   = DefControls(h,ModelIn);
   Check(ModelIn,CVHan)
   set([CVHan.segments,CVHan.segmed],off{:})
   setcvdata(h,'Handles',CVHan,'Results',[],'Model',ModelIn,'ModelName',ModelName)
   waitfor(h,'waitstatus','close')
   [ModelIn,ModelOut] = getcvdata(h,'Model','Results');
   delete(h)
   
else
   
   [CVHan,ModelIn] = getcvdata(gcbf,'Handles','Model');
   Set             = [];
   switch ctag
   case {'nboo','test','loo'}
      ModelIn.valmethod.name = ctag;
      set(CVHan.meth(CVHan.meth ~= gcbo),va,0)
      set(gcbo,va,1)
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'BooChoice'
      ModelIn.valmethod.name = get(gcbo,ud);
      setcvdata(gcbf,'Model',ModelIn)
      %set(allchild(get(gcbo,'parent')),cof{:})
      %set(gcbo,con{:})
      
   case 'window'
      setcvdata(gcbf,'Model',[],'Results',[])
      set(gcbf,'waitstatus','close')
      return
      
   case 'End'   
      set(gcbf,'waitstatus','close')
      
   case 'Factors'
      try

         Str = get(CVHan.facted,st);
         if any(Str==',')
         
            a(1) = sscanf(Str(1:min(find(Str == ','))),'%i')';
            a(2) = sscanf(Str(min(find(Str == ',')) + 1:end),'%i')';
            if length(a) == 2
               ModelIn.nbfactors.min = a(1);
               ModelIn.nbfactors.max = a(2);
            end
            set(CVHan.facted,st,sprintf('%i , %i',ModelIn.nbfactors.min,ModelIn.nbfactors.max))
            
         else
            a = sscanf(Str,'%i')';
            b = [];
            if ~isempty(a)
               ModelIn.nbfactors.min = a;
               ModelIn.nbfactors.max = b;
            end
            set(CVHan.facted,st,sprintf('%i',ModelIn.nbfactors.min))
         end
         
      catch
         set(CVHan.facted,st,'')
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'replica'
      try
         ModelIn.valmethod.replicates = sscanf(get(CVHan.repled,st),'%i');
      catch
         set(CVHan.repled,st,'')
         return
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'segments'
      try
         ModelIn.valmethod.segments = sscanf(get(CVHan.segmed,st),'%i');
      catch
         set(CVHan.segm,st,'')
         return
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'validate'
      if ~cval
         ModelIn.valmethod = struct('bootstrap',[],'name',[],'replicates',[],'segments',[]);
      else
         ModelIn.valmethod = struct('bootstrap',[],'name','loo','replicates',[],'segments',[]);
      end
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'PreTreat'
      ModelIn = PreProcess(ModelIn,1);
      setcvdata(gcbf,'Model',ModelIn)
      
   case 'StartBut'
      ModelOut = Calculate(ModelIn,getappdata(gcbf,'ModelName'));
      setcvdata(gcbf,'Results',ModelOut)
      set(gcbf,'waitstatus','close')
      %delete(findobj(ModelIn.xpointer,'tag','cbaxes'))
      
   case 'Help'
      a   = lower(which('CuBatch'));
      b   = lower(getappdata(gcbf,'ModelName'));
      a   = strrep(a,'cubatch.m',['Help\user\win\win' b '.html']);
      stat=web(['file:///' a],'-browser');

   end   
   ModelIn = getcvdata(gcbf,'Model');
   Check(ModelIn,CVHan)
   set([CVHan.segments,CVHan.segmed],off{:})
end