function DisplayInfo(MainFig,ModelOut)
% function nPLS1DisplayInfo (MainFig,ModelOut);
% 
% Description:
% It displays the informations relative to the current (n)PLS1 model(s). If there is a plot it displays
% the informations saved in the application-defined data 'ModelOut' of the current plot. The data
% passed to displayinfo are those utilised to compute the (n)PLS1 model and stored in
% ModelOut.data.dataset
% 
% Inputs: 
% MainFig: handle to the main figure
% ModelOut: ModelOut structure.
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% Model_nPLS1\nPLS1Plot, DisplayModel
% 
% Subroutines:
% Internal: None
% External: displayinfo
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 04-Nov-2002 11:10:42
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

GuiNames
X    = ModelOut(1).data.dataset;
if strcmp(get(gcbo,'type'),'uimenu') & strcmp(get(get(gcbo,'parent'),'label'),'Projection') & length(ModelOut) > 1
   %Projection
   p    = get(gcbo,'userdata');
   xp   = getappdata(MainFig,'Results');
   X{2} = xp(p).data.dataset{2};
   clear xp
else
   p = 1;
end
delete(findobj(tg,'textfig'))
if ~isa(X,'cell')
   X = {X};
end
DisplayInfo(MainFig,X);
fnor = {'fontunits','normalized'};
vert = {'verticalalignment','cap'};
a    = findobj(tg,'textfig');
apos = get(a,'extent');
if isa(apos,'cell')
   apos = min(cat(1,apos{:}));
end
b     = text(.5,apos(2) - 0.03,['\bf\fontsize{12}Model: ' ModelOut(p).modelname],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
bpos  = get(b,'extent');
S2a   = {'\fontsize{10}N. of LV';'Expl. Variation X';'Expl. Variation Y';'\bfX\rm Centring';'\bfX\rm Scaling';'\bfy\rm Centring';'\bfy\rm Scaling'};
if length(ModelOut(p).model) ~= 1
   NbFacStr = sprintf('%i - %i',ModelOut(p).model(1).nbfactors,ModelOut(p).model(end).nbfactors);
   EVStrX   = sprintf('%3.2f%% - %3.2f%%',ModelOut(p).model(1).xev,ModelOut(p).model(end).xev);
   EVStrY   = sprintf('%3.2f%% - %3.2f%%',ModelOut(p).model(1).yev,ModelOut(p).model(end).yev);
else
   NbFacStr = sprintf('%i',ModelOut(p).model.nbfactors);
   EVStrX   = num2str(ModelOut(p).model.xev,'%3.2f%%');
   EVStrY   = num2str(ModelOut(p).model.yev,'%3.2f%%');
end
S2b = {[': ',NbFacStr];...
      [': ',EVStrX];...
      [': ',EVStrY];...
      [': [ ',sprintf('%i ',ModelOut(p).info.preprocess.modx.cen(:)'),']'];...
      [': [ ',sprintf('%i ',ModelOut(p).info.preprocess.modx.scal(:)'),']'];...
      [': [ ',sprintf('%i ',ModelOut(p).info.preprocess.mody.cen(:)'),']'];...
      [': [ ',sprintf('%i ',ModelOut(p).info.preprocess.mody.scal(:)'),']']};
text(.05,bpos(2)-0.02,S2a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
c    = text(.5,bpos(2)-0.02,S2b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
cpos = get(c,'extent');
S30  = [];
if ~isempty(ModelOut(p).validation)
   Names = {'Leave One Out',['Na' char(239) 've Bootstrap'],'Residuals Bootstrap','Test set'};
   Val   = find(strcmp({'loo','nboo','rboo','test'},ModelOut(p).validation(1).method));
   switch ModelOut(p).validation(1).method
   case {'nboo','rboo'}
      S30 = 'Validation';
      S3a = {'Method';'Replicates'};
      S3b = {[': ',Names{Val}];sprintf(': %i',size(ModelOut(p).validation(1).segments,2))};
      
   case 'loo'
      S30 = 'Validation';
      S3a = {'Method';'Expl. Variation X';'Expl. Variation Y'};
      if length(ModelOut(p).validation) > 1
         S3b   = {[': ',Names{Val}];...
               sprintf(': %3.2f%% - %3.2f%%',ModelOut(p).validation(1).xev,ModelOut(p).validation(end).xev);...
               sprintf(': %3.2f%% - %3.2f%%',ModelOut(p).validation(1).yev,ModelOut(p).validation(end).yev)};
      else
         S3b   = {[': ',Names{Val}];...
               sprintf(': %3.2f%%',ModelOut(p).validation(1).xev);...
               sprintf(': %3.2f%%',ModelOut(p).validation(1).yev)};
     
      end
      
   case 'test'
      S30     = 'Validation';
      S3a     = {'Method';'Size';'Expl. Variation X';'Expl. Variation Y'};
      Size    = size(ModelOut(p).info.content);
      Size(1) = length(ModelOut(p).validation(1).segments);
      Size    = [': [',sprintf(' %i',Size),']'];
      if length(ModelOut(p).validation) == 1
         S3b    = {': Test set';...
               Size;...
               sprintf(': %3.2f%%',ModelOut(p).validation(1).xev);...
               sprintf(': %3.2f%%',ModelOut(p).validation(1).yev)};
      else
         S3b    = {': Test set';...
               Size;...
               sprintf(': %3.2f%% - %3.2f%%',ModelOut(p).validation(1).xev,ModelOut(p).validation(end).xev);...
               sprintf(': %3.2f%% - %3.2f%%',ModelOut(p).validation(1).yev,ModelOut(p).validation(end).yev)};
      end
            
   otherwise
      S3 = [];
   end
   d     = text(.5,cpos(2) - 0.03,['\bf\fontsize{12}',S30],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
   dpos  = get(d,'extent');
   e     = text(.05,dpos(2)-0.02,S3a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
   text(.5,dpos(2)-0.02,S3b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
   cpos = get(e,'extent');

end
if ~isempty(ModelOut(p).prediction)
   
   S30    = 'Projection';
   
   if ~isempty(ModelOut(p).info.initialsize) & ModelOut(p).info.initialsize ~= size(ModelOut(p).info.content,ndims(ModelOut(p).info.content));
      
      S3a      = {'Size';'Missing data';'Expl. variation X';'Fill-in method'};
      Siz      = size(ModelOut(p).info(1).content);
      Siz(1)   = size(ModelOut(p).prediction.data,1);
      Siz(end) = ModelOut(p).info.initialsize;
      Ind      = repmat({':'},ndims(ModelOut(p).prediction(1).data),1);
      Ind{end} = 1:ModelOut(p).info.initialsize;
      Mis      = isnan(ModelOut(p).prediction(1).data(Ind{:}));
      Mis      = sum(Mis(:))/length(Mis(:)) * 100;
      S3b = {[': [',int2str(Siz),']'];...
            sprintf(': %3.2f%%',Mis);...
            sprintf(': %3.2f%%',ModelOut(p).prediction(1).xev);...
            [': ',ModelOut(p).info.fillin]};
      
   else
      
      Mis = isnan(ModelOut(p).prediction(1).data);
      Mis = sum(Mis(:))/length(Mis(:)) * 100;
      Siz = size(ModelOut(p).prediction.data);
      S3a = {'Size';'Missing data';'Expl. variation X'};
      S3b = {[': [',int2str(Siz),']'];...
            sprintf(': %3.2f%%',Mis);...
            sprintf(': %3.2f%%',ModelOut(p).prediction(1).xev)};
      
   end
   %Display information right beneath the Validation's
   c     = text(.5,cpos(2) - 0.03,['\bf\fontsize{12}',S30],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
   cpos  = get(c,'extent');
   nil   = text(.05,cpos(2)-0.02,S3a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
   c     = text(.5,cpos(2)-0.02,S3b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');

end

set(findobj(gcf,tg,'textfig'),'clipping','on')

