function ModelOut  = nPLS1Apply(MainFig);
% function ModelOut = nPLS1Apply (MainFig);
% 
% Description:
% Applies a certain nPLS1 or PLS1 model (that have just been calculated or loaded) to a new set of
% data. The new data is loaded via the load_extdata function. The predicted variable is selected via
% the submenu to the 'Apply model'->'projection' menu of the main window If more than one model is
% available a listbox requester appears requesting selection of the
% model's complexity (which is permanent for the current session - i.e. the ModelOut.model and ModelOut
% prediction' field of ModelOut.
% 
% Inputs: 
% MainFig: main CuBatch window handle.
% 
% 
% Outputs:
% ModelOut: ModelOut structure (it can be modified depending on the selection, see Description)
% 
% 
% Called by:
% Dispatch_Apply
% 
% Subroutines:
% Internal: None
% External: applymodel, load_extdata, nplspred, unfoldcbdataset
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 16-Oct-2002 13:25:22
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

ModelOut           = getappdata(MainFig,'Results');
PosVar             = get(gcbo,'userdata');
MO                 = ModelOut(PosVar);
MO.info            = ModelOut(1).info;
MO.data.dataset{1} = ModelOut(1).data.dataset{1};
Pos                = 1;
Ans                = 'Yes';
if length(MO.model) ~= 1
   ListProp = {'selectionmode','single','name','Choose model','promptstring',{'You have more than one model','Select the one to apply'}};
   ReqTit   = 'Choose model';
   Ranks    = [MO.model.nbfactors]';
   [Pos,Ok] = listdlg('Liststring',cellstr(num2str(Ranks)),ListProp{:});
   if ~Ok,return,end
   if strcmp(getappdata(MainFig,'Mode'),'advanced')
      QuestOptions = struct('Interpreter','tex','Default','Yes');
      Prompt       = {'The choice eliminates the other dimensionalities.';...
            'Do you wish to continue?';...
           'NB: the removal affects \bfonly\rm in the current session'};
      Ans          = questdlg(Prompt,'Continue','Yes','No',QuestOptions);
      if strcmp(Ans,'No'),return,end
   end
end
MO.model = MO.model(Pos);
if ~isempty(MO.validation)
   MO.validation = MO.validation(Pos);
end
try
   [Stat,MO] = Load_ExtData(MO,MainFig);
catch
   uiwait(errordlg(lasterr))
   return
end
if Stat
   
   if strcmp(MO.modelname,'PLS')
      PredFun                      = 'plspred';
   else
      PredFun     = 'nplspred';
   end
   MO.prediction = ApplyModel(PredFun,MO.prediction.data.data,[],MO.model,MO.prediction,MO.info.initialsize,MO.info.fillin);
   if PosVar ~= 1
      MO.data.dataset{1} = [];
   end
   ModelOut(PosVar) = MO;
   
else
   ModelOut = [];
end

return