function nPLS1ActivatePlots(PlotMenuHan,ApplyMen,ModelOut)
% function nPLS1ActivatePlots (PlotMenuHan,ApplyMen,ModeNames,VariableNames,Factors,Flag);
% 
% Description:
% It activates the 'Results' submenus relative to an nPLS or PLS model after it is computed, loaded or
% applied to a new set of data via nPLS1Apply. Some plots are available only for specific type of
% validation or whether the model is fit to a new set of data instead of being just computed. In
% particular the 'online' plots (Q statistics, D statistics, SPE) are activated only when the last mode
% is given name 'time' (case insensitive). Specifically, the first level of submenus is relative to the
% predicted variables. The menus callback is npls1plot.
% 
% Inputs: 
% PlotMenuHan  : 'Results' menu handle
% ApplyMen     : 'Use model' menu handle
% ModeNames    : cell vector holding the modes' names for the X data used to compute the model
% VariableNames: cell vector with the predicted variables
% Factors      : vector of the number of LVs (for all the computed models, if more than one)
% Flag         : 0/1 depending on whether the results refer to a model that has been just computed (0)
%                or to a model that has been applied to a new set of data (1).
% 
% 
% Outputs:
% None
%  
% 
% Called by:
% ActivatePlots
% 
% Subroutines:
% Internal: None
% External: guinames, plot_d_statistic, plot_explained_variance, plot_landscape, plot_partial_rss,
%           plot_partial_rss_online, plot_pred_meas, plot_predictions, plot_quality, plot_press,
%           plot_rmse, plot_tu_loadings, plot_xy_loadings, setcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 16-Oct-2002 18:42:22
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

ModeNamesA = ModelOut(1).data.dataset{1}.modenames;
ModeNamesB = ModelOut(1).info.content.modenames;
for i = 1:length(ModelOut)
   VariableNames{i} = ModelOut(i).data.dataset{2}.name;
end
Flag = zeros(length(ModelOut),1);
for i = 1:length(ModelOut)
   Flag(i) = ~isempty(ModelOut(i).prediction);
end
if ~exist('Flag','var')
   Flag = zeros(length(VariableNames),1);
end
GuiNames
delete(get(PlotMenuHan,'children'));
MainFig = get(PlotMenuHan,'parent');
cbf     = sprintf('nPLS1Plot(%i);',MainFig);
if ~isa(VariableNames,'cell')
   VariableNames = {VarNames};
end
r = PlotMenuHan;%uimenu(PlotMenuHan,la,'&Results',tg,'res');
set(ApplyMen,cb,'')
for i = 1:length(VariableNames)
   sm              = [];
   Factors         = max([ModelOut(i).model.nbfactors]);
   Handles_VarMenu = uimenu(r,la,VariableNames{i},ud,i,tg,'Variable Menu');
   uimenu(ApplyMen,la,VariableNames{i},ud,i,tg,'AppModel',cb,'Cubatch(NaN)')
   XMen = uimenu(Handles_VarMenu,la,'&X plots');
   YMen = uimenu(Handles_VarMenu,la,'&Y plots');
   %X plots
   h     = uimenu(XMen,la,'&Scores',ud,1);
   for j = 1:3 %min(3,Factors)
      if j > Factors
         sm(j,1) = uimenu(h,la,sprintf('Plots %iD',j),ud,j,cb,cbf,tg,'Plot_XY_Loadings',dis{:});
      else
         sm(j,1) = uimenu(h,la,sprintf('Plots %iD',j),ud,j,cb,cbf,tg,'Plot_XY_Loadings');
      end
   end
   b = [];
   for j = 2:length(ModeNamesA)
      h = uimenu(XMen,la,['Weights: ',ModeNamesA{j},' &',sprintf('%i',j)],ud,j);
      b(end + 1:end + length(sm),1) = copyobj(sm,h);
   end
   sm          = [sm;b];
   if strcmpi(deblank(ModeNamesB{length(ModeNamesB)}),'time') & length(ModeNamesB) ~= 2
      H = uimenu(XMen,la,'D-statistic',sep{:});
      sm(end + 1) = uimenu(H,la,'On-line',cb,cbf,tg,'Plot_D_Statistic',ud,'on');
      sm(end + 1) = uimenu(H,la,'Off-line',cb,cbf,tg,'Plot_D_Statistic',ud,'off');
   else
      sm(end + 1) = uimenu(XMen,la,'D-statistic',sep{:},cb,cbf,tg,'Plot_D_Statistic',ud,'off');
   end
   H = uimenu(XMen,la,'D-Contribution',off{:});
   for j = 2:length(ModeNamesB)
      sm(end + 1) = uimenu(H,la,['Mode &',sprintf('%i: ',j),ModeNamesB{j}],cb,cbf,tg,'Plot_D_Contribution',ud,j);
   end   
   a(3)        = uimenu(XMen,la,'&Expl. var.',sep{:});
   sm(end + 1) = uimenu(XMen,la,'&PRESS',         cb,cbf,tg,'Plot_PRESS');
   sm(end + 1) = uimenu(XMen,la,'&RMSE',          cb,cbf,tg,'Plot_RMSE');
   a(1) = uimenu(XMen,la,'Re&siduals',sep{:});
   a(2) = uimenu(XMen,la,'&Congruence');
   for j = 1:length(ModeNamesB)
      sm(end + 1) = uimenu(a(1),la,['Mode &',sprintf('%i: ',j),ModeNamesB{j}],cb,cbf,tg,'Plot_Partial_RSS',ud,{j,'Residuals'});
      if j == length(ModeNamesB) & strcmpi(deblank(ModeNamesB{j}),'Time') & j ~= 2
         Handle = sm(end);
         sm(end + 1) = uimenu(Handle,la,'On line',cb,cbf,tg,'Plot_Partial_RSS_OnLine',ud,'Q');
         sm(end + 1) = uimenu(Handle,la,'Off line',cb,cbf,tg,'Plot_Partial_RSS',ud,{j,'Residuals'});
         sm(end + 1) = uimenu(Handle,la,'SPE',cb,cbf,tg,'Plot_Partial_RSS_OnLine',ud,'SPE');
         set(Handle,cb,'')
      end
      sm(end + 1) = uimenu(a(2),la,['Mode &',sprintf('%i: ',j),ModeNamesB{j}],cb,cbf,tg,'Plot_Partial_RSS',ud,{j,'Congruence'});
      sm(end + 1) = uimenu(a(3),la,['Mode &',sprintf('%i: ',j),ModeNamesB{j}],cb,cbf,tg,'Plot_Partial_RSS',ud,{j,'% Var'});
   end
   sm(end + 1) = uimenu(a(3),la,'Global',cb,cbf,tg,'Plot_Explained_Variance',sep{:});
   if length(ModeNamesB) < 4;
      sm(end + 1) = uimenu(a(1),la,'Res&iduals landscape',cb,cbf,tg,'Plot_Landscape',ud,'Residuals',sep{:});
      sm(end + 1) = uimenu(XMen,la,'&Model landscape',    cb,cbf,tg,'Plot_Landscape',ud,'Model',sep{:});
   end
   setcvdata([sm;a(:)],'Apply',Flag(i),'Array','X')
   %Y plots
   sm   = [];
   h    = uimenu(YMen,la,'&Scores',ud,1);
   if Flag(i)
      set(h,dis{:});
   end
   for j = 1:3 %min(3,Factors)
      
      if j > Factors
         sm(j,1) = uimenu(h,la,sprintf('Plots %iD',j),ud,j,cb,cbf,tg,'Plot_XY_Loadings',dis{:});
      else
         sm(j,1) = uimenu(h,la,sprintf('Plots %iD',j),ud,j,cb,cbf,tg,'Plot_XY_Loadings');
      end
      
   end
   sm(end + 1) = uimenu(YMen,la,'&Exp. variation',cb,cbf,tg,'Plot_Explained_Variance',sep{:});
   sm(end + 1) = uimenu(YMen,la,'&PRESS',         cb,cbf,tg,'Plot_PRESS');
   sm(end + 1) = uimenu(YMen,la,'&RMSE',          cb,cbf,tg,'Plot_RMSE');
   if ~Flag(i)
      sm(end + 1) = uimenu(YMen,la,'t vs u',        cb,cbf,tg,'Plot_TU_Loadings',sep{:});
      h           = uimenu(YMen,la,'Predicted vs Measured',cb,cbf,tg,'Plot_Pred_Meas',sep{:});
      setcvdata(h,'Apply',Flag,'Array','X')
   else
      sm(end + 1) = uimenu(YMen,la,'&Predictions',cb,cbf,tg,'Plot_Predictions',sep{:});
   end
   setcvdata(sm,'Apply',Flag(i),'Array','Y')
   
end
