function Predictions = PLSPred(X,Model_Parameters,varargin)
% function Predictions = PLSPred (X,Model_Parameters,varargin);
% 
% Description:
% Apply a PLS1 model to a new set of data (X) yielding the new scores and predictions. It automatically
% matricises the array. The model parameters are passed to this function in a structure with suitable
% fields (e.g. ModelOut.model)
%  
% Inputs: 
% X: double array of data
% Model_Parameters: ModelOut.model structure relative to the (n)PLS1 model.
% varargin: additional inputs for the npred function (used here only to remove the screen output).
% 
% 
% Outputs:
% Predictions: structure with four fields
% 
% xfactors, matrix of doubles with the new scores 
% xpred, predictions for X. 
% ypred, predictions for Y. 
% yfactors, scores in prediction for Y (NB the formula to compute these values is currently incorrect, thus these values cannot be used and are disregarded in the rest of the GUI; the error will be corrected in future releases) 
% Called by:
% Model_nPLS1\nPLS1Apply, Model_nPLS1\Calculate, Model_nPLS1\Plot_D_Statistic, Model_nPLS1\Plot_Partial_RSS_OnLine
% 
% Subroutines:
% Internal: None
% External: npred, nshape
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 16-Oct-2002 12:04:52
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%


Core{Model_Parameters.nbfactors}         = Model_Parameters.core;
[Predictions.ypred,Predictions.xfactors] = npred(nshape(X,1),Model_Parameters.nbfactors,Model_Parameters.xfactors,Model_Parameters.yfactors,Core,Model_Parameters.bcoeff,varargin{:});
if isa(Predictions.xfactors,'cell')
   Predictions.xfactors = Predictions.xfactors{1};
end
Predictions.xpred       = reshape(Predictions.xfactors * nshape(Model_Parameters.core,1) * Model_Parameters.xfactors{end}',size(X));
Predictions.yfactors{1} = Predictions.xfactors * Model_Parameters.bcoeff;