function [xpred,fxpred,ypred,fypred] = tuckervipredic(x,B,Byvi,Bx,loadival);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tuckervipredic                                     %
% [ypred] = tuckervipredic(x,B,Byvi,Bx);             %
% test: [ypred] = tuckervipredic(rand(5,3),rand(4,15)%
%        {rand(5,2),rand(3,2)},{rand(5,2),rand(3,2)})%
%                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     x :  p-vector
%     B:regression coefficient matrix (pq-matrix)
%     Byvi :loadings of PxY
%     Bx: loadings of X
% OUTPUTS
%     xpred
%     fxpred
%     ypred predicted vector (q-vector)
%     fypred
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Predicts a vector y with a regressed vector x    %
%  with Tucker-IV  (1 common mode)                  %
%  fypred=                                          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    regression2D                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   12/09/2002   version 1.3                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mainfig=findobj('userdata','Cubatch');
fxpred=[];
xpred=[];

Rx=size(x);
My=length(Byvi);  % diff de Ny
for i=1:My,
   [Ry(i),Wy(i)]=size(Byvi{i});
end;
xu=reshape(x,1,prod(Rx));
Bxlr=fliplr(Bx);
Byvilr=fliplr(Byvi);

if nargin<5,
    g=getappdata(mainfig,'Results');
    loadi=g.prediction.xcumpress{1};
else
    loadi=loadival{1};
end;
nkx=nkron(Bxlr{:});
nkyvi=nkron(Byvilr{:});
fypred=xu*nkx*B*nkyvi;
ypred=fypred*nkyvi';
[bibifricotin,fypred]=regression2D(fypred',loadi);
fypred=fypred';
if My>1,
    ypred=reshape(ypred,Ry);
end;







   