function tuckerviplot(typ,spl,mi,mo,c,d);
%  typ: 'gra','mod','exv','res','xmo','reg'
%  spl for PlotStr structure
%  mi for ModelIn structure
%  mo for ModelOut structure
%  c for content object
%  d is the CBdataset object
guinames;
mainfig=findobj(0,'type','figure','userdata','Cubatch');
Ny=length(mo.model.yfactors{1});
Nx=length(mo.model.xfactors);
if nargin==6,
    X=d{1}.data;
    Y=d{2}.data;
end;
if strcmp(typ,'graY'),  %building window
    [mi,mo,spl]= checkp(mi,mo,spl);
    tuckerviplotwindow(spl,mi,mo);
    h=findobj('tag','tuckerviplot');
    set(h,'waitstatus','open');
    waitfor(h,'waitstatus','close');
else %    (graphiques)
    hfig=findobj('userdata','Cubatch');
    if ~isempty(spl),
        setcvdata(hfig,'PlotStr',spl);
    end;
    delete(findobj('tag','cbaxes'));
    set(0,'currentfigure',hfig);
    h=axes('parent',hfig,'position',sizeaxes{1},'tag','cbaxes','nextplot','replacechildren');
    switch typ  % different kinds of graphics
        
        case 'mod'  % 123-D plots
            dim=c{2}.dims;
            %dimt=size(mo.prediction.xfactors);
            delete(findobj('tag','cbaxes'));
            nt=length(spl.batch);
            h=get(1,'children');
            nplot=sum(spl.additional.plotvi);
            m=zeros(1,nplot);
            if nplot==1,
                m(1)=axes('parent',1,'position',sizeaxes{1},'tag','cbaxes','nextplot','replacechildren');
            elseif nplot==2,
                m(1)=axes('parent',1,'position',sizeaxes{2}(1,:),'tag','cbaxes','nextplot','replacechildren');
                m(2)=axes('parent',1,'position',sizeaxes{2}(2,:),'tag','cbaxes','nextplot','replacechildren');
            elseif nplot==3,,
                m(1)=axes('parent',1,'position',sizeaxes{4}(1,:),'tag','cbaxes','nextplot','replacechildren');
                m(2)=axes('parent',1,'position',sizeaxes{4}(2,:),'tag','cbaxes','nextplot','replacechildren');
                m(3)=axes('parent',1,'position',sizeaxes{4}(3,:),'tag','cbaxes','nextplot','replacechildren');
            elseif nplot==0,
                uiwait(errordlg({'You have to choose at most one Tucker in the checkboxes.'}));
                return;
            end;
            cop=get(gca,'colororder');
            [tacop,rr]=size(cop);
            if length(spl.nummode)>1,    % mixed modes
                if spl.additional.plotvi(1)==1,
                    [a1,b1]=size(mo.model.yfactors{1}{spl.nummode(1)});
                    [a2,b2]=size(mo.model.yfactors{1}{spl.nummode(2)});
                    A1=kron(mo.model.yfactors{1}{spl.nummode(1)},mo.model.yfactors{1}{spl.nummode(2)});
                    mini=min(spl.nummode);
                    maxi=max(spl.nummode);
                    Gd=permute(mo.model.corey{1},[spl.nummode(1),spl.nummode(2),1:mini-1,mini+1:maxi-1,maxi+1:Ny]);
                    Gd=reshape(Gd,[mi.nbfactors.min(mini)*mi.nbfactors.min(maxi),prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:Ny]))]);
                    A1=A1*Gd;
                    [AA{1} p1 p2]=svd(A1,0);
                    clear p2;
                end;
                if spl.additional.plotvi(2)==1,
                    [a1,b1]=size(mo.model.yfactors{2}{spl.nummode(1)});
                    [a2,b2]=size(mo.model.yfactors{2}{spl.nummode(2)});
                    A1=kron(mo.model.yfactors{2}{spl.nummode(1)},mo.model.yfactors{2}{spl.nummode(2)});
                    mini=min(spl.nummode);
                    maxi=max(spl.nummode);
                    Gd=permute(mo.model.corey{2},[spl.nummode(1),spl.nummode(2),1:mini-1,mini+1:maxi-1,maxi+1:Ny]);
                    Gd=reshape(Gd,[mi.nbfactors.min(mini)*mi.nbfactors.min(maxi),prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:Ny]))]);
                    A1=A1*Gd;
                    [AA{2} p1 p2]=svd(A1,0);
                    clear p2;
                end;
                if spl.additional.plotvi(3)==1,
                    [a1,b1]=size(mo.model.yfactors{3}{spl.nummode(1)});
                    [a2,b2]=size(mo.model.yfactors{3}{spl.nummode(2)});
                    A1=kron(mo.model.yfactors{3}{spl.nummode(1)},mo.model.yfactors{3}{spl.nummode(2)});
                    mini=min(spl.nummode);
                    maxi=max(spl.nummode);
                    Gd=permute(mo.model.corey{3},[spl.nummode(1),spl.nummode(2),1:mini-1,mini+1:maxi-1,maxi+1:Ny]);
                    Gd=reshape(Gd,[mi.nbfactors.min(mini)*mi.nbfactors.min(maxi),prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:Ny]))]);
                    A1=A1*Gd;
                    [AA{3} p1 p2]=svd(A1,0);
                    clear p2;
                end;
                %reduction des A
                j=prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:Ny]));
                [a,b]=size(A1);
                if j<b,
                    AA{1}=AA{1}(:,1:j);
                    AA{2}=AA{2}(:,1:j);
                    AA{3}=AA{3}(:,1:j);
                end;
            else
                AA{1}=mo.model.yfactors{1}{spl.nummode};
                AA{2}=mo.model.yfactors{2}{spl.nummode};
                AA{3}=mo.model.yfactors{3}{spl.nummode};
                if mi.valmethod.bootstrap>0,
                    AAb{1}=mo.validation.yfactors{1}{spl.nummode};
                    AAb{2}=mo.validation.yfactors{2}{spl.nummode};
                    AAb{3}=mo.validation.yfactors{3}{spl.nummode};
                end;
            end;
            [a,b]=size(AA{1});
            np=0;
            A=cell(1,nplot);
            nom={'Tucker(Y)','IV-Tucker(Y)','Residual IV-Tucker(Y)'};
            for i=1:3,
                if spl.additional.plotvi(i)==1,
                    np=np+1;
                    A{np}=AA{i};
                    nommode{np}=nom{i};
                    if mi.valmethod.bootstrap>0,
                        Ab{np}=AAb{i};
                    end;
                end;
            end;
            for iii=1:nplot,   %3 plots
                set(1,'currentaxes',m(iii));
                switch spl.plotdims
                    case 1,
                        if  spl.factors(1)< b+1,
                            if length(spl.nummode)<2,
                                plot(A{iii}(:,spl.factors(1)),'tag','plo','color',spl.color,'parent',m(iii));
                            else
                                for j=1:a1,
                                    plot(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:),'parent',m(iii));
                                    hold on;
                                end;
                            end;
                        else
                            plot(A{iii},'tag','plo','parent',m(iii));
                        end;
                        switch spl.format(1),
                            case 1 %integer
                                set(findobj('tag','plo'),'marker','none');
                                if  spl.factors(1)< b+1,
                                    if length(spl.nummode)<2
                                        for i=1:a,
                                            text(i,A{iii}(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                        end;
                                    else % mixed modes
                                        for i=1:a2
                                            for j=1:a1,
                                                text(i,A{iii}((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                            end; 
                                        end;
                                    end;
                                else,   
                                    for j=1:b
                                        for i=1:a,
                                            text(i,A{iii}(i,j),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;
                                end;
                            case 2,%label
                                set(findobj('tag','plo'),'marker','none');
                                if  spl.factors(1)< b+1,
                                    if length(spl.nummode)<2
                                        for i=1:a,
                                            text(i,A{iii}(i,spl.factors(1)),c{2}.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                        end;
                                    else % mixed modes
                                        for i=1:a2
                                            for j=1:a1,
                                                text(i,A{iii}((j-1)*a2+i,spl.factors(1)),c{2}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                            end; 
                                        end;
                                    end;
                                else 
                                    for j=1:b
                                        for i=1:a,
                                            text(i,A{iii}(i,j),c{2}.labels{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;
                                end;
                            case 3 %marker
                        end;
                        hold on;   %  projection
                        if ~isempty(mo.prediction.data) & spl.nummode==1 & length(spl.nummode)==1 & strcmp(nommode{iii},'IV-Tucker(Y)'),
                            try
                                d=size(mo.prediction.yfactors{1},1);
                                u=size(mo.model.yfactors{2}{1},1);
                                plot(u+1:u+d,mo.prediction.yfactors{1}(:,spl.factors(1)),'tag','proj','parent',m(iii));
                            catch
                                uiwait(errordlg({'error for the plot of projections',lasterr}))
                            end;
                        elseif length(spl.nummode)==2,  
                        end;
                        if mi.valmethod.bootstrap > 0     % bootstrap  plots
                            mo=tuckerviplotboot(A,Ab,mi,mo,spl,c,iii,nommode);
                        end;
                    case 2,  %plot 2D
                        if length(spl.nummode)<2,
                            plot(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),'color',spl.color,'tag','plo','parent',m(iii));
                        else
                            for j=1:a1,
                                plot(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),A{iii}((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:),'parent',m(iii));
                                hold on;
                            end;
                        end;
                        switch spl.format(1)
                            case 1 %integer
                                set(findobj('tag','plo'),'marker','none');
                                if length(spl.nummode)<2,
                                    for i=1:dim(spl.nummode),
                                        text(A{iii}(i,spl.factors(1)),A{iii}(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                    end;
                                else %mixed modes
                                    for i=1:a2
                                        for j=1:a1,
                                            text(A{iii}((j-1)*a2+i,spl.factors(1)),A{iii}((j-1)*a2+i,spl.factors(2)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;               
                                end;
                            case 2,%label
                                set(findobj('tag','plo'),'marker','none');
                                if length(spl.nummode)<2
                                    for i=1:dim(spl.nummode),
                                        text(A{iii}(i,spl.factors(1)),A{iii}(i,spl.factors(2)),c{2}.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                    end;
                                else %mixed modes
                                    for i=1:a2
                                        for j=1:a1,
                                            text(A{iii}((j-1)*a2+i,spl.factors(1)),A{iii}((j-1)*a2+i,spl.factors(2)),c{2}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;               
                                end;
                            case 3 %marker
                        end;
                        
                        if mi.valmethod.bootstrap > 0     % bootstrap  plots
                            mo=tuckerviplotboot(A,Ab,mi,mo,spl,c,iii,nommode);
                        end;
                        hold on;   %  projection
                        if ~isempty(mo.prediction.data) & spl.nummode==1 & length(spl.nummode)==1 & strcmp(nommode{iii},'IV-Tucker(Y)'),
                            try
                                plot(mo.prediction.yfactors{1}(:,spl.factors(1)),mo.prediction.yfactors{1}(:,spl.factors(2)),'tag','proj','parent',m(iii));
                            catch
                                uiwait(errordlg({'error for the plot of projections',lasterr}))
                            end;              
                        elseif length(spl.nummode)==2,    
                        end;   
                    case 3,  %plot3D
                        set(gca,'view',[-37.5 30])
                        if length(spl.nummode)<2,
                            plot3(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),A{iii}(:,spl.factors(3)),'color',spl.color,'tag','plo','parent',m(iii));
                            hold on;    
                        else,
                            for j=1:a1,
                                plot3(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),A{iii}((j-1)*a2+1:j*a2,spl.factors(2)),A{iii}((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:),'parent',m(iii));
                                hold on;
                            end;
                        end;
                        switch spl.format(1)
                            case 1 %integer
                                set(findobj('tag','plo'),'marker','none');
                                if length(spl.nummode)<2,
                                    for j=1:dim(spl.nummode),
                                        text(A{iii}(j,spl.factors(1)),A{iii}(j,spl.factors(2)),A{iii}(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                    end;
                                else
                                    for i=1:a2
                                        for j=1:a1,
                                            text(A{iii}((j-1)*a2+i,spl.factors(1)),A{iii}((j-1)*a2+i,spl.factors(2)),A{iii}((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;                  
                                end;                 
                            case 2,%label
                                set(findobj('tag','plo'),'marker','none');
                                if length(spl.nummode)<2,
                                    for j=1:dim(spl.nummode),
                                        text(A{iii}(j,spl.factors(1)),A{iii}(j,spl.factors(2)),A{iii}(j,spl.factors(3)),c{2}.labels{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2','parent',m(iii));
                                    end;
                                else
                                    for i=1:a2
                                        for j=1:a1,
                                            text(A{iii}((j-1)*a2+i,spl.factors(1)),A{iii}((j-1)*a2+i,spl.factors(2)),A{iii}((j-1)*a2+i,spl.factors(3)),c{2}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','parent',m(iii));
                                        end; 
                                    end;                  
                                end;
                            case 3 %marker
                                
                        end;
                        
                        hold on;   %  projection
                        if ~isempty(mo.prediction.data) & spl.nummode==1 & length(spl.nummode)==1 & strcmp(nommode{iii},'IV-Tucker(Y)'),
                            try
                                mo.prediction.yfactors{1}
                                plot3(mo.prediction.yfactors{1}(:,spl.factors(1)),mo.prediction.yfactors{1}(:,spl.factors(2)),mo.prediction.yfactors{1}(:,spl.factors(3)),'tag','proj','parent',m(iii));
                            catch
                                uiwait(errordlg({'error for the plot of projections',lasterr}))
                            end;
                        elseif length(spl.nummode)==2,    
                        end;   
                        
                        
                        if isequal(spl.additional.shadow, 1),
                            axe=axis;
                            if length(spl.nummode)<2,
                                plot3(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                                plot3(A{iii}(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A{iii}(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                                plot3(axe(2)*ones(dim(spl.nummode),1),A{iii}(:,spl.factors(2)),A{iii}(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                                plot3(A{iii}(:,spl.factors(1)),A{iii}(:,spl.factors(2)),A{iii}(:,spl.factors(3)),'color',spl.color,'tag','plo','parent',m(iii));
                            else
                                for j=1:a1,
                                    plot3(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),A{iii}((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                                    plot3(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A{iii}((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                                    plot3(axe(2)*ones(dim(spl.nummode(2)),1),A{iii}((j-1)*a2+1:j*a2,spl.factors(2)),A{iii}((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2','parent',m(iii));
                                    plot3(A{iii}((j-1)*a2+1:j*a2,spl.factors(1)),A{iii}((j-1)*a2+1:j*a2,spl.factors(2)),A{iii}((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:),'parent',m(iii));
                                end;
                            end;
                        end;
                end;
                if spl.format(1)==3,
                    set(findobj('tag','plo'),'marker',spl.marker);
                end;
                set(findobj('tag','plo'),'linestyle',spl.linestyle);
                
                switch spl.format(2)
                    case 2 %discrete
                        set(findobj('tag','plo'),'linestyle','none');
                    case 1% continuous
                end;
                if length(spl.nummode)>1 |spl.factors(1)> b,
                    xl=['PC',int2str(spl.factors(1))];
                    if spl.factors(1)> b,
                        xl=['All PC'];
                    end;
                else
                    xl=['PC',int2str(spl.factors(1)),':',num2str(mo.model.yev{iii}(spl.nummode,spl.factors(1))),'%'];
                end;
                xlabel(xl,'tag','xlab','tag','enluminure');
                if spl.plotdims>1
                    if length(spl.nummode)>1|spl.factors(1)> b,
                        yl=['PC',int2str(spl.factors(2))];
                    else
                        yl=['PC',int2str(spl.factors(2)),':',num2str(mo.model.yev{iii}(spl.nummode,spl.factors(2))),'%'];
                    end;
                    ylabel(yl,'tag','ylab','tag','enluminure');
                    if spl.plotdims>2,
                        if length(spl.nummode)>1|spl.factors(1)> b,
                            zl=['PC',int2str(spl.factors(3))];
                        else
                            zl=['PC',int2str(spl.factors(3)),':',num2str(mo.model.yev{iii}(spl.nummode,spl.factors(3))),'%'];
                        end;
                        zlabel(zl,'tag','zlab','tag','enluminure');
                    end;
                end;
                
                if length(spl.nummode)<2,
                    X=getappdata(mainfig,'X');
                    lab=X{1}.modenames;
                    if strcmp(lab{spl.nummode}(1:3),'Mod'),
                        titre=[nommode{iii},':', lab{spl.nummode}];
                    else 
                        titre=[nommode{iii},', mode ',int2str(spl.nummode),': ',lab{spl.nummode}];
                    end;
                else,
                    titre=[nommode{iii},': Modes ',int2str(spl.nummode(1)),'x',int2str(spl.nummode(2))];
                end;
                title(titre,'parent',m(iii),'tag','enluminure');
                if isequal(nplot,3),  %rapetissement des lettrages lorsqu'il y 3 graphiques
                    set([findobj('tag','enluminure'),gca],'fontsize',7);
                end;
                set(m(iii),'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                if spl.additional.potential.exist==1 & spl.plotdims==2,
                    axi=axis;
                    hold on;
                    try
                        potentiel('gra',spl,A{iii},axi);
                    catch
                        uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
                        return;
                    end;
                end;
                if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
                    hold on;
                    try
                        hotel('gra',spl,A{iii});
                    catch
                        uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
                    end;
                end;
                set(findobj('tag','plo'),'visible',spl.visible);
                set(findobj('tag','plo2'),'visible',spl.visible);
                set(findobj('tag','proj'),'linestyle','none');
                set(findobj('tag','proj'),'color','b');
                set(findobj('tag','proj'),'marker','*');
            end;  %  3 plots
        case 'xmo',
            [sel,ok]=listdlg('liststring',mi.samlabs.labels,...
                'name',['Modelisation'],...
                'selectionmode','single',...
                'promptstring',['Choose between ',mi.samlabs.name]);
            if ok==1,
                Xm=nmodel(mo.model.xfactors,mo.model.core);
                Xm=squeeze(Xm(sel,:,:));
                surf(Xm);
                xlabel(c{2}.modenames{2});
                ylabel(c{2}.modenames{1});
                title(['Modelisation for ',mi.samlabs.labels{sel}]);
            end;
        case 'res',
            [sel,ok]=listdlg('liststring',mi.samlabs.labels,...
                'name',['Residuals'],...
                'selectionmode','single',...
                'promptstring',['Choose between ',mi.samlabs.name]);
            if ok==1,
                Xm=nmodel(mo.model.xfactors,mo.model.core);
                E=X-Xm;
                E=squeeze(E(sel,:,:));
                surf(E);
                xlabel(c{2}.modenames{2});
                ylabel(c{2}.modenames{1});
                title(['Residuals for ',mi.samlabs.labels{sel}]);
            end;
        case 'exvy' % Explained variation Y
            delete(findobj('tag','cbaxes'));
            tai=size(mo.model.corey{1},1);
            if Ny==3,
                if tai<5,         
                    switch tai,
                        case 1,
                            ty=1;
                        case 2,
                            ty=2;
                        case {3,4}
                            ty=4;
                        case {5,6}
                            ty=6;         
                    end;
                    for i=1:tai,
                        hhh=axes('parent',gcbf,'tag','cbaxes','nextplot','replacechildren','view',[-37.5 30],'position',sizeaxes{ty}(i,:));
                        bar3(squeeze(mo.model.corey{1}(i,:,:)));
                        title(['Core of Tucker(Y), Slab ',int2str(i)]);
                        xlabel('Mode 3');
                        ylabel('Mode 2');
                    end;
                else 
                    uiwait(warndlg({'No plot available (size of the core is too large).','Its first dimension has to be inferior or equal to 6'}));
                end;
            elseif Ny==2,
                hhh=axes('parent',gcbf,'tag','cbaxes','nextplot','replacechildren','view',[-37.5 30],'position',sizeaxes{1}(1,:));
                bar3(squeeze(mo.model.corey{1}));
                title(['Core of Tucker(Y)']);
                xlabel('Mode 1');
                ylabel('Mode 2');
            else
                uiwait(warndlg({'No plot available (Only for 3-way array or less).'}));
            end;
        case 'exvyvi' % Explained variation    PxY
            delete(findobj('tag','cbaxes'));
            tai=size(mo.model.corey{2},1);
            if Ny==3,
                if  tai<5,         
                    switch tai,
                        case 1,
                            ty=1;
                        case 2,
                            ty=2;
                        case {3,4}
                            ty=4;
                        case {5,6}
                            ty=6;         
                    end;
                    for i=1:tai,
                        hhh=axes('parent',gcbf,'tag','cbaxes','nextplot','replacechildren','view',[-37.5 30],'position',sizeaxes{ty}(i,:));
                        bar3(squeeze(mo.model.corey{2}(i,:,:)));
                        title(['Tucker(PxY), Slab ',int2str(i)]);
                        xlabel('Mode 3');
                        ylabel('Mode 2');
                    end;
                else 
                    uiwait(warndlg({'No plot available (size of the core is too large).','Its first dimension has to be inferior or equal to 6'}));
                end;
            elseif Ny==2,
                hhh=axes('parent',gcbf,'tag','cbaxes','nextplot','replacechildren','view',[-37.5 30],'position',sizeaxes{1}(1,:));
                bar3(squeeze(mo.model.corey{2}));
                title(['Core of Tucker(PxY)']);
                xlabel('Mode 1');
                ylabel('Mode 2');
            else
                uiwait(warndlg({'No plot available (Only for 3-way array or less).'}));
            end;
        case 'exvyvio' % Explained variation  QxY
            delete(findobj('tag','cbaxes'));
            tai=size(mo.model.corey{3},1);
            if Ny==3,
                if tai<5,         
                    switch tai,
                        case 1,
                            ty=1;
                        case 2,
                            ty=2;
                        case {3,4}
                            ty=4;
                        case {5,6}
                            ty=6;         
                    end;
                    for i=1:tai,
                        hhh=axes('parent',gcbf,'tag','cbaxes','nextplot','replacechildren','view',[-37.5 30],'position',sizeaxes{ty}(i,:));
                        bar3(squeeze(mo.model.corey{3}(i,:,:)));
                        title(['Core of Tucker(QxY), Slab ',int2str(i)]);
                        xlabel('Mode 3');
                        ylabel('Mode 2');
                    end;
                else 
                    uiwait(warndlg({'No plot available (size of the core is too large).','Its first dimension has to be inferior or equal to 6'}));
                end;
            elseif Ny==2,
                hhh=axes('parent',gcbf,'tag','cbaxes','nextplot','replacechildren','view',[-37.5 30],'position',sizeaxes{1}(1,:));
                bar3(squeeze(mo.model.corey{3}));
                title(['Core of Tucker(QxY)']);
                xlabel('Mode 1');
                ylabel('Mode 2');
            else
                uiwait(warndlg({'No plot available (Only for 3-way array or less).'}));
            end;
        case 'reg' % Regressions
            if mi.options.commonmodes>1,
                uiwait(warndlg({'Regression is for the moment only implemented','for 1 common mode: patience...'}));
                return;
            end;
            sel=cell(Ny-mi.options.commonmodes,1);
            ok(1:Ny)=0;
            for i=mi.options.commonmodes+1:Ny,
                [sel{i-1},ok(i-1)]=listdlg('liststring',d{2}.labels{i},...
                    'name',['Variables of Y for mode ',int2str(i)],...
                    'selectionmode','single',...
                    'promptstring',['Choose between the variables of Y']);
            end;
            if isequal(ok(1:Ny-1),ones(1,Ny-1)),
                %hhh=axes('parent',gcbf,'tag','cbaxes','nextplot','replacechildren','position',sizeaxes{1});
                plot(squeeze(Y(:,sel{:})),squeeze(mo.model.ypred(:,sel{:})),'r+');
                axe=axis;
                hold on;
                plot(axe(1:2),axe(3:4),'b');
                if mi.valmethod.bootstrap>0
                    for i=1:mi.valmethod.replicates,
                        %plot(squeeze(Y(:,sel{:})),squeeze(mo.validation.ypred(:,sel{:},i)),'g.');
                    end;
                end;
                %  projection
                if ~isempty(mo.prediction.ypred),
                    try
                        plot(squeeze(mo.prediction.ypred(:,sel{:})),squeeze(mo.prediction.ypred(:,sel{:})),'b+');
                    catch
                        uiwait(errordlg({'error for the plot of projections',lasterr}));
                    end;
                    %elseif length(spl.nummode)==2,    
                end;   
                ylabel('Predicted Y');
                xlabel('Original Y');
                title(['Variables ',int2str([sel{:}])]);
            end;
        case 'lineoripred' 
           ok2 = 0; 
           if Ny >3,
                uiwait(errordlg(['This function is not available for a Y data set of size superior to 3.']));
                return;      
            end;
            [sel1,ok1]=listdlg('liststring',d{2}.modenames,...
                'name',['Mean profile'],...
                'selectionmode','single',...
                'promptstring',['Choose your mode:']);
            if ok1,
                selquest=questdlg('Do You wish to see the global mean or to select modalities?','Choice','Global mean','Select modalities','Global mean');
                if strcmp(selquest,'Global mean'),
                    if Ny==2,
                        %plot();
                    elseif Ny==3,
                        
                    end;
                else,
                    [sel2,ok2]=listdlg('liststring',d{2}.modenames,...
                        'name',['Mode where we compare:'],...
                        'selectionmode','single',...
                        'promptstring',['Choose your mode:']);
                end;
            end;
            if ok2,
                if isequal(sel1,sel2),
                    uiwait(errordlg(['You cannot choose the same mode.']));
                    return;
                end;
                [sel2,ok2]=listdlg('liststring',d{2}.labels{2},...
                    'name',['Choose maximum xxx plots'],...
                    'selectionmode','single',...
                    'promptstring',['Choose your mode:']);
            end;   
        end;
    end;  %switch type
    hold off;
end;  %graphiques
