function [B,PxY,vexpvi,Avi,Fyvi,vpx,Ax,Fx,loadi]=tuckervif(X,Y,rx,ry);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tuckervif                                          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     X  M-way data
%     Y  N-way data
%     rx parameters of tucker(X)
%     ry parameters of tucker(Y), tucker(PxY) and Tucker(QxY)
% OUTPUTS
%     B      regression coefficient
%     PxY    projection of Y onto tucker(X)
%     vpyvi  explained variation of Tucker(PxY)
%     Avi    no more used
%     Fyvi   loadings of Tucker(PxY)
%     vpx    explained variation of Tucker(X)
%     Ax     no more used
%     Fx     loadings of Tucker(X)
%     loadi  see tuckerweight
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  SUBROUTINES
%      tucker (n-way 2.01)
%      regression2D
%      tuckerweight
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 10/02/2003    version 1.2                         %
% Christophe Durville U.Marne-La-Valle&TOTALFINAELF%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

mainfig=findobj('userdata','Cubatch');
mi=getappdata(mainfig,'Model');
Rx=size(X);
Ry=size(Y);
eps=mi.options.algorithm.value;
ini=mi.options.algorithm.constants;  % 0 dtld, 1 svd, 2 rand, 10 bestfit
maxit=mi.options.algorithm.maxiter;
try 
    [Fx,Gx,vpx]=tucker(X,rx,[eps ini 0 0 10 maxit]);
catch
    uiwait(errordlg({'Error in the tucker(X) step.',lasterr}));
    return;
end;
ssx=misssum(X(:).^2);
ssy=misssum(Y(:).^2);
try
    [PxY,B]=regression2(Y,Fx,mi.options.commonmodes);
    if mi.options.commonmodes,
        Wx=size(Gx);
        Yu=reshape(Y,Ry(1),prod(Ry(2:end)));
        [PxYu,B]=regression2D(Yu,Fx{1}*reshape(Gx,Wx(1),prod(Wx(2:end))));
    end;
catch
    uiwait(errordlg({'Error in the regression step.',lasterr}));
    return;
end;
VPxY=100*sum(PxY(:).^2)/sum(Y(:).^2);
QxY=Y-PxY;
VQxY=100*sum(QxY(:).^2)/sum(Y(:).^2);
sspxy=sum(PxY(:).^2);
ssqxy=sum(QxY(:).^2);
try
    [Fyvi,Gyvi,vpyvi]=tucker(PxY,ry,[eps ini 0 0 10 maxit]);
    [Fyvio,Gyvio,vpyvio]=tucker(QxY,ry,[eps ini 0 0 10 maxit]);
    [Fy,Gy,vpy]=tucker(Y,ry,[eps ini 0 0 10 maxit]);
catch
    uiwait(errordlg({'Errors in the Tucker(Y), Tucker(PxY) or Tucker(QxY) steps.',lasterr}));
    return;
end;

if mi.options.commonmodes    % calcul de Ypred
    Ypred=nmodel(Fyvi,Gyvi);
end;

[aaaaaaa,loadi]=tuckerweight(Fyvi,Gyvi);







