function tuckervidisplayInfo(mainfig,mi,mo)

GuiNames

%X = mo.data.dataset;
X=getappdata(mainfig,'X');

delete(findobj(tg,'textfig'))
if ~isa(X,'cell')
   X = {X};
end
DisplayInfo(mainfig,X);
fnor = {'fontunits','normalized'};
vert = {'verticalalignment','cap'};

a    = findobj(tg,'textfig');
apos = get(a,'extent');
if isa(apos,'cell')
    apos = min(cat(1,apos{:}));
end
b     = text(.5,apos(2) - 0.05,'\bf\fontsize{12}Model: IV-Tucker',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
bpos  = get(b,'extent');
S2a   = {'\fontsize{10}Algorithm';'N. of factors';'Com. modes';'Expl. Var.';'Centering';'Scaling';'Conv. Crit.';'Max. Iter.';'Initialisation';'Rotation'};%
T2a   = {'Conv. Crit.';'Max. Iter.'};
%U2a   = {'Bootstrap'};
Alg =[mi.options.algorithm.name];


nmyvi=sum(mo.model.yev{2}(1,:));
nmyvio=sum(mo.model.yev{3}(1,:));
nmy=sum(mo.model.yev{1}(1,:));
nmx=sum(mo.model.xev(1,:));
if length(mo.model) ~= 1
    NbFacStr = sprintf('%i - %i',mo.model(1).nbfactors,mo.model(end).nbfactors);
    EVStr    = [];
else
   NbFacStry = mi.nbfactors.min;
   NbFacStrx = mi.nbfactors.max;
    EVStr    = [sprintf('%0.5g',nmy),'%'];  % global explained variation
 end
 
prcenx= [mi.sam(1).cen(1),mi.var(1).cen(:)'];
prscalx=[mi.sam(1).scal(1),mi.var(1).scal(:)'];
prceny= [mi.sam(1).cen(2),mi.var(2).cen(:)'];
prscaly=[mi.sam(1).scal(2),mi.var(2).scal(:)'];
 if ~isempty(prcenx)
   PreTrStrAx = [prcenx(:)];
else
   PreTrStrAx=0;
end
if ~isempty(prscalx)
   PreTrStrBx = [prscalx(:)];
else
   PreTrStrBx=0;
end
 if ~isempty(prcenx)
   PreTrStrAy = [prceny(:)];
else
   PreTrStrAy=0;
end
if ~isempty(prscalx)
   PreTrStrBy = [prscaly(:)];
else
   PreTrStrBy=0;
end
switch mi.options.algorithm.constants,
case 1, ini='SVD';
case 0, ini='DTLD-GRAM';
case 2, ini='Random';
case 10,ini='Best fit';
otherwise, ini='';    
end;
switch mi.options.rotate,
case 0,namerot='none.';
case 1,namerot='Diagonale.';
case 2,namerot='SW Diagonale.';
case 3,namerot='Variance Max.';
otherwise namerot='';
end;

Convcrit=mi.options.algorithm.value;
iter=mo.model.iterations;
Maxiter=mi.options.algorithm.maxiter;

S2b = { [': ',Alg];...
      [': [',sprintf('%i',NbFacStrx),']x[',sprintf('%i',NbFacStry),']'];...
      [': ',int2str(mi.options.commonmodes)];...
      [': ',EVStr];...
      [': [',sprintf('%i',PreTrStrAx),']x[',sprintf('%i',PreTrStrAy),']'];...
      [': [',sprintf('%i',PreTrStrBx),']x[',sprintf('%i',PreTrStrBy),']'];...
      [': ',num2str(Convcrit)];...
      [': [',int2str(iter),']/',int2str(Maxiter)];...
      [': ',ini];...
      [': ',namerot]};
%hui=uicontextmenu(mainfig,'PxY (%):');

text(.05,bpos(2)-0.02,S2a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
c    = text(.5,bpos(2)-0.02,S2b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
cpos = get(c,'extent');S30 = [];

S3 = [];

if ~isempty(S30)
    d     = text(.5,cpos(2) - 0.05,['\bf\fontsize{12}',S30],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
    dpos  = get(d,'extent');
    text(.05,dpos(2)-0.02,S3a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
    e = text(.5,dpos(2)-0.02,S3b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
end
if ~isempty(mo.prediction.data)
    DisplayInfoProj(mainfig,mo,cpos);
end;
set(findobj(gcf,tg,'textfig'),'clipping','on')
