function [mi,mo]=tuckerviboot(mi,mo,Factors);

mainfig=findobj('type','figure','userdata','Cubatch');
X=getappdata(mainfig,'X');
Rx=X{1}.dims;
Ry=X{2}.dims;
Y=X{2}.data;
X=X{1}.data;
Nx=ndims(X);
Ny=ndims(Y);


nbboot=mi.valmethod.replicates;
if mi.valmethod.bootstrap==1,   % naive bootstrap
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Bootstrap avec Reechantillonnage sur les lignes des Donnes  %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [Abootstrap, bootsam]=bootstrpregression(nbboot,10,'naiftuckervi',X,Y,mi.nbfactors.max,mi.nbfactors.min,mi.options.commonmodes);
end;

for i=1:nbboot, 
    for j=1:2:6,        
        %changement ventuel du signe des PC bootstraps
        Ab=Abootstrap{j}{1}(:,:,i);
        Bb=Abootstrap{j}{2}(:,:,i);
        signprodscalA=diag(sign(diag(Ab'*Factors{(j+1)/2}{1})));
        signprodscalB=diag(sign(diag(Bb'*Factors{(j+1)/2}{2})));       
        Ab=Ab*signprodscalA;
        Bb=Bb*signprodscalB;      
        Abootstrap{j}{1}(:,:,i)=Ab;
        Abootstrap{j}{2}(:,:,i)=Bb;
        if Ny==3,
            Cb=Abootstrap{j}{3}(:,:,i);
            signprodscalC=diag(sign(diag(Cb'*Factors{(j+1)/2}{3})));
            Cb=Cb*signprodscalC;
            Abootstrap{j}{3}(:,:,i)=Cb;
        end;
    end;
end;

%  Calculus of the standard deviation (for the modes 2 to N).
for n=1:Ny,
    stad{n}=std(Abootstrap{1}{n},0,3);  %unbiased estimation
end;
if isequal(mi.valmethod.bootstrap,1), %naive bootstrap
    m(1:10*max(Ry)*nbboot)=0;
    AAA=cell(1,Ry(1));
    for n=1:nbboot,
        u=bootsam(:,n);
        for i=1:Ry(1),
            m(u(i))=m(u(i))+1;
            AAA{u(i)}(:,m(u(i)))=Abootstrap{1}{1}(i,:,n);
        end;
    end;
    for i=1:Ry(1),
        if ~isequal(size(AAA{i}),[0 0]),
            stad{1}(i,:)=std(AAA{i},0,2);
        end;
    end;
end;

%  Calcul du risque
for i=1:3,
    if Ny==3,
        BC=kron(Factors{i}{2},Factors{i}{3});
        WW=BC*BC';
        somtrace=0;
        for b=1:nbboot,
            Bb=Abootstrap{2*i-1}{2}(:,:,b);
            Cb=Abootstrap{2*i-1}{3}(:,:,b);
            BCb=kron(Bb,Cb);
            Wb=BCb*BCb';
            traceb=trace(Wb*WW);
            somtrace=somtrace+traceb;
        end;
        risqueBC(i)=mi.nbfactors.min(2)*mi.nbfactors.min(3)-(1/nbboot)*somtrace;
    elseif Ny==2,
        B=Factors{i}{2};
        WW=B*B';
        somtrace=0;
        for b=1:nbboot,
            Bb=Abootstrap{2*i-1}{2}(:,:,b);
            Wb=Bb*Bb';
            traceb=trace(Wb*WW);
            somtrace=somtrace+traceb;
        end;
        risqueBC(i)=mi.nbfactors.min(2)-(1/nbboot)*somtrace;        
    end;


%outputs
for i=1:Ny,
    mo.validation.yfactors{1}{i}=Abootstrap{1}{i};
    mo.validation.yfactors{2}{i}=Abootstrap{3}{i};
    mo.validation.yfactors{3}{i}=Abootstrap{5}{i};
end;
mo.validation.corey{1}=Abootstrap{2};
mo.validation.corey{2}=Abootstrap{4};
mo.validation.corey{3}=Abootstrap{6};
mo.validation.segments=bootsam;
mo.validation.stats.std=stad;
mo.validation.stats.risk=risqueBC;
mo.validation.bcoeff=Abootstrap{7};

mo.validation.xcumpress=Abootstrap{8};
mo.validation.ycumpress=Abootstrap{9};
mo.validation.ypred=Abootstrap{10};


end;