function [ModelIn,ModelOut]=tuckervi(ModelIn);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tuckerVI                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% some of variables:
%     Y,X  tensors (3-way data) (not unfolded!)
%     wx: dimensions of the subspaces 
%             obtained by tucker
%          wx=[]  X is not reduced
%     wyvi: dimensions of tucker model
%             for PxY
%     k: number of common modes (the first)
% 
%     B     Regression coefficient
%     PxY   the projected of A on T*U*V.
%     Gyvi  core-tensor of tucker(PxY).
%     Hyvi: energy of tucker (ss(Gyvi(:).^2)
%     Fyvi3,Fyvi2,Fyvi1:loadings of tucker(PxY).
%     QxY   QxY=Y-PxY
%     Gyvio,Hyvio,Fyvi1o,Fyvi2o,Fyvi3o: idem for QxY
%     Gx:  core-tensor of tucker(X).
%     Hx:  energy of tucker (ss(Gx(:).^2))
%     Fx1,Fx2,Fx3:loadings of tucker(X).
%     Fyvi3,Fyvi2,Fyvi1:loadings of tucker(PxY).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   Tucker with Instrumental Variables              %
%   Solves the problem min||Y-Tucker(Y)||           %
%   with  linear constraints on the loadings        %
%   with Y and X 3-way data.                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%     guinames
%     regression2                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   25/05/2002   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

WIC=[0.5029 0.5814 0.6402];
LBC=[0.9 0.93 0.95];
FRC=[0.3529 0.4314 0.4902];
guinames;
mainfig=findobj('type','figure','userdata','Cubatch');
X=getappdata(mainfig,'X');
Nx=length(X{1}.dims);
Ny=length(X{2}.dims);
if X{2}.dims(2)==1,
    Ny=1;
end;
clear X;
h=findobj('tag','tuckervi');
if isempty(h),
    [ModelIn]=check(ModelIn);
    h0 = figure('MenuBar','none', ...
        'Name','IV-Tucker', ...
        'NumberTitle','off', ...
        'Position',[400 300 360 280], ...
        'userdata','window',...
        'busyaction','cancel',...
        'resize','off',...
        'color',WIC,...
        'Tag','tuckervi',...
        'toolbar','none');
    h1 = uimenu('Parent',h0, ...
        'Label','&Preferences', ...
        'Tag','pref');
    ModelIn.options.algorithm.name='ALS';
    ModelIn.options.algorithm.maxiter=300;
    ModelIn.options.algorithm.constants=1;
    ModelIn.options.algorithm.value=1e-10;
    h2 = uimenu('Parent',h1, ...  % 
        'Label','&Constraints', ...
        'enable','off',...
        'callback','evalin(''caller'',''ModelIn = tuckerconstraints(ModelIn);'');',...
        'Tag','const');
    h2 = uimenu('Parent',h1, ...
        'callback','evalin(''caller'',''ModelIn = tuckeroptions(ModelIn);'');',...
        'Label','&Tucker options');
    h2 = uimenu('Parent',h1, ...
        'separator','on',...
        'Label','&Bootstrap options');
    h3 = uimenu('Parent',h2, ...
        'Label','Bootstrap model');
    h4 = uimenu('Parent',h3, ...
        'Callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=1;'');set(gcbo,''checked'',''on'');set(findobj(''tag'',''rb''),''checked'',''off'');', ...
        'tag','nb',...
        'Label','Naive bootstrap');
    h4 = uimenu('Parent',h3, ...
        'Callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=2;'');set(gcbo,''checked'',''on'');set(findobj(''tag'',''nb''),''checked'',''off'');', ...
        'tag','rb',...
        'Label','Residual bootstrap');
    if isempty(ModelIn.valmethod.bootstrap),
        ModelIn.valmethod.bootstrap=0;
    end;
    if ModelIn.valmethod.bootstrap<2,
        set(findobj('tag','nb'),'checked','on');
        set(findobj('tag','rb'),'checked','off');
    elseif isequal(ModelIn.valmethod.bootstrap,2),
        set(findobj('tag','rb'),'checked','on');
        set(findobj('tag','nb'),'checked','off');
    end;
    if isempty(ModelIn.valmethod.replicates),
        ModelIn.valmethod.replicates=5; %default values
    end;
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''fnbboot(ModelIn.valmethod.replicates);'');',...
        'Label','Bootstrap replications');
    h1 = uimenu('Parent',h0, ...
        'Callback','', ...
        'Label','&Help', ...
        'Tag','help');
    ModelIn.valmethod.name='none';
    h1=uicontrol('parent', h0,...      % Frame validation
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',FRC,...
        'tooltipstring','Validation window',...
        'position',[10 10 160 130],...
        'style','frame');
    h1=uicontrol('parent', h0,...      % validate
        'string','Validation',...
        'fontsize',12,...
        'callback','if get(gcbo,''value'')==1,set([findobj(''tag'',''croval'')],''enable'',''on'',''value'',1);evalin(''caller'',''ModelIn.valmethod.name=''''cv'''';'');set([findobj(''tag'',''OKtuckerboot'')],''enable'',''off'');else set(findobj(''tag'',''croval''),''enable'',''off'',''value'',0);set([findobj(''tag'',''OKtuckerboot'')],''enable'',''on'');evalin(''caller'',''ModelIn.valmethod.name=''''none'''';'');end;',...
        'backgroundcolor',FRC,...
        'position',[20 110 130 20],...
        'tooltipstring','Check only if You want to do a validation of IV-PCA.',...  
        'style','checkbox');
    h1=uicontrol('parent', h0,...      % cross validation
        'string','Cross-validation',...
        'fontsize',12,...
        'callback','set(gcbo,''value'',1);',...%'callback','evalin(''caller'',''ModelIn.valmethod.name=''''cv'''';'');set([findobj(''tag'',''booval2''),findobj(''tag'',''booval1'')],''value'',0);',...
        'tag','croval',...
        'value',0,...
        'backgroundcolor',FRC,...
        'enable','off',...
        'position',[35 90 130 20],...
        'tooltipstring','1 by 1 cross validation.',...  
        'style','radiobutton');
    
    switch ModelIn.valmethod.name
        case 'nboo',
            set(findobj('tag','booval1'),'value',1);
        case 'rboo',
            set(findobj('tag','booval2'),'value',1);
        case 'cv'
            set(findobj('tag','croval'),'value',1);
        otherwise
            %ModelIn.valmethod.name='cv';
            %set(findobj('tag','croval'),'value',1);
    end;
    
    h1=uicontrol('parent', h0,...   %num factors text X
        'string', 'Num. factors X',...
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',WIC,...
        'position',[0 235 105 20],...
        'style','text');
    h1=uicontrol('parent', h0,...   %num factors text Y
        'string', 'Num. factors Y',...
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',WIC,...
        'tooltipstring',['The sizes of the subspaces of Y have to be',char(10),'inferior to the corresponding subspaces of X.'],...
        'position',[0 205 105 20],...
        'style','text');
    
    h1=uicontrol('parent', h0,...   %num common modes text
        'string', 'Num. common modes',...
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',WIC,...
        'position',[0 165 160 20],...
        'style','text');
    if isempty(ModelIn.nbfactors.min)|~isequal(length(ModelIn.nbfactors.min),Ny)|size(ModelIn.nbfactors.min,1)>1,
        ModelIn.nbfactors.min=2*ones(1,Ny);
        if Ny==1,
            ModelIn.nbfactors.min=1;
        end;
    end;
    if isempty(ModelIn.nbfactors.max)|~isequal(length(ModelIn.nbfactors.max),Nx)|size(ModelIn.nbfactors.max,1)>1,
        ModelIn.nbfactors.max=3*ones(1,Nx);
    end;
    h1=uicontrol('parent', h0,...     %nbPC X
        'string',int2str(ModelIn.nbfactors.max),...
        'callback','evalin(''caller'',''ModelIn.nbfactors.max=eval([''''['''',get(gcbo,''''string''''),'''']'''']);'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','npc',...
        'position',[110 235 70 20],...
        'tooltipstring','Nx integers separated by spaces or ",".',...
        'style','edit');
    h1=uicontrol('parent', h0,...     %nbPC Y
        'string',int2str(ModelIn.nbfactors.min),...
        'callback','evalin(''caller'',''ModelIn.nbfactors.min=eval([''''['''',get(gcbo,''''string''''),'''']'''']);'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','npc',...
        'position',[110 205 70 20],...
        'tooltipstring','Ny integers separated by spaces or ",".',...
        'style','edit');
    if Ny==1,
        set(h1,'style','text');
    end;
    h1=uicontrol('parent', h0,...     %nb com modes
        'string',int2str(ModelIn.options.commonmodes),...
        'callback','evalin(''caller'',''ModelIn.options.commonmodes=eval([''''['''',get(gcbo,''''string''''),'''']'''']);'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','npc',...
        'position',[155 165 20 20],...
        'tooltipstring',['The common modes have to be ',char(10),'of same size for X and Y.'],...
        'style','edit');
    h1=uicontrol('parent', h0,...      %close button
        'string','Close',...
        'callback','close(gcf);',...
        'fontsize',12,...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 10 130 30],...
        'tooltipstring','close "IV-Tucker"',...  
        'style','pushbutton');
    h1=uicontrol('parent', h0,...   %  IV-Tucker
        'tag','OKtucker',...
        'string','OK',...
        'fontsize',12,...
        'callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=0;[ModelIn,ModelOut]=tuckervi(ModelIn);'')',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 60 130 30],...
        'tooltipstring','Normal IV-Tucker',...  
        'style','pushbutton');
    h1=uicontrol('parent', h0,...   %  IV-Tucker bootstrap
        'tag','OKtuckerboot',...
        'string','Bootstrap',...
        'fontsize',12,...
        'callback','evalin(''caller'',''if ModelIn.valmethod.bootstrap==0, ModelIn.valmethod.bootstrap=1;end;[ModelIn,ModelOut]=tuckervi(ModelIn);'')',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 95 130 30],...
        'tooltipstring','Convex hulls,etc...',...  
        'style','pushbutton');   
    h1=uicontrol('parent', h0,...      %frame process
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',FRC,...
        'position',[190 140 160 130],...
        'tooltipstring','Processing window',...
        'style','frame');
    h1=uicontrol('parent', h0,...   %  preprocessing window
        'tag','prep',...
        'string','Preprocessing',...
        'fontsize',12,...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 230 130 30],...
        'tooltipstring','',...  
        'style','pushbutton');
    if Ny>1,
        set(h1,'callback','evalin(''caller'',''ModelIn=tuckervipreprocess(ModelIn,2);'');');
    else
        set(h1,'callback','evalin(''caller'',''ModelIn=preprocess(ModelIn,1);'');');
    end;
    h1=uicontrol('parent', h0,...   %  postprocessing window
        'tag','postp',...
        'string','Postprocessing',...
        'fontsize',12,...
        'callback','evalin(''caller'',''postproc(ModelIn);'');',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 190 130 30],...
        'tooltipstring','Rotation of the core',...  
        'style','pushbutton');
else,  %execution of tuckerVI
    [ModelOut,PlotStr] = DefineModelOut;
    X=getappdata(mainfig,'X');
    Rx=X{1}.dims;
    Ry=X{2}.dims;
    Y=X{2}.data;
    X=X{1}.data;
    
   mcentx=[];
   mcenty=[];
   mscalx=[];
   mscaly=[];
  
    % preprocessing X
    if sum([ModelIn.sam(1).cen(1),ModelIn.var(1).cen,ModelIn.sam(1).scal(1),ModelIn.var(1).scal])>0, % X
        try
            [X,mcentx,mscalx]=nprocess(X,[ModelIn.sam(1).cen(1),ModelIn.var(1).cen],[ModelIn.sam(1).scal(1),ModelIn.var(1).scal]);
        catch
            uiwait(errordlg({'Error in the preprocessing part of X.',lasterr}));
        end;
    end;
    % preprocessing Y
    if sum([ModelIn.sam(1).cen(2),ModelIn.var(2).cen,ModelIn.sam(1).scal(2),ModelIn.var(2).scal])>0, % Y
        try
            [Y,mcenty,mscaly]=nprocess(Y,[ModelIn.sam(1).cen(2),ModelIn.var(2).cen],[ModelIn.sam(1).scal(2),ModelIn.var(2).scal]);
        catch
            uiwait(errordlg({'Error in the preprocessing part of Y.',lasterr}));
        end;
    end;   
    
    if strcmp(ModelIn.valmethod.name,'cv'),
        if Ny>3,
            uiwait(errordlg({'Sorry.You can''t do this (for the moment...)','since the order of your data is more than 3.'}));
            return;
        end;
        choixcompvctuckerVI(Y,X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'));
    elseif strcmp(ModelIn.valmethod.name,'none'),
        constrf=zeros(1,Ny);
        %for i=1:Ny,
        %   Ny
        %   if ModelIn.constraints(4).modes(i)==1,% orthogonality is for tucker non orthogonality (none)
        %      constrf(i)=2;
        %   elseif ModelIn.constraints(3).modes(i)==1,
        %      constrf(i)=1;
        %   elseif ModelIn.constraints(6).modes(i)==1,
        %      constrf(i)=4;
        %   else
        %      constrf(i)=0;
        %   end;
        %end;
        eps=ModelIn.options.algorithm.value;
        ini=ModelIn.options.algorithm.constants;  % 0 dtld, 1 svd, 2 rand, 10 bestfit
        maxit=ModelIn.options.algorithm.maxiter;
        try 
            [Fx,Gx,vpx,Xm,itx]=tucker(X,ModelIn.nbfactors.max,[eps ini 0 0 10 maxit],0);
        catch
            uiwait(errordlg({'Error in the tucker(X) step.',lasterr}));
            return;
        end;
        ssx=misssum(X(:).^2);
        ssy=misssum(Y(:).^2);
        try
            [PxY,B]=regression2(Y,Fx,ModelIn.options.commonmodes);
            if ModelIn.options.commonmodes,
                Wx=size(Gx);
                Yu=reshape(Y,Ry(1),prod(Ry(2:end)));
                [PxYu,B]=regression2D(Yu,Fx{1}*reshape(Gx,Wx(1),prod(Wx(2:end))));
            end;
        catch
            uiwait(errordlg({'Error in the regression step.',lasterr}));
            return;
        end;
        VPxY=100*sum(PxY(:).^2)/sum(Y(:).^2);
        QxY=Y-PxY;
        VQxY=100*sum(QxY(:).^2)/sum(Y(:).^2);
        sspxy=sum(PxY(:).^2);
        ssqxy=sum(QxY(:).^2);
        if size(Y,2)>1,
            try
                [Fyvi,Gyvi,vpyvi,Ymvi,ityvi]=tucker(PxY,ModelIn.nbfactors.min,[eps ini 0 0 10 maxit],constrf,0);
                [Fyvio,Gyvio,vpyvio,Ymvio,ityvio]=tucker(QxY,ModelIn.nbfactors.min,[eps ini 0 0 10 maxit],constrf,0);
                [Fy,Gy,vpy,Ym,ity]=tucker(Y,ModelIn.nbfactors.min,[eps ini 0 0 10 maxit],constrf,0);
            catch
                uiwait(errordlg({'Errors in the Tucker(Y), Tucker(PxY) or Tucker(QxY) steps.',lasterr}));
                return;
            end;
        else
            Gyvi=norm(PxY);
            Gyvio=norm(QxY);
            Gy=norm(Y);
            vpy=100;vpyvi=100;vpyvio=100;
            Fyvi{1}=PxY/Gyvi;
            Fyvio{1}=QxY/Gyvio;
            Fy{1}=Y/Gy;
        end;
        
        if ModelIn.options.commonmodes    % calcul de Ypred
            if size(Y,2)>1,
                Ypred=nmodel(Fyvi,Gyvi);
            else
                Ypred=Y;
            end;
        end;
        
        %  attribution des coef pour que ce soit une projection
        ModelOut.prediction.ycumpress=Fyvi;
        try 
            if size(Y,2)>1
                [Fyvio]=tuckerweight(Fyvio,Gyvio);
                [Fyvi,loadi]=tuckerweight(Fyvi,Gyvi);
                [Fy]=tuckerweight(Fy,Gy);
            else
                loadi=Fyvi;
                Fyvi{1}=PxY;
                Fyvio{1}=QxY;
                Fy{1}=Y;
            end
        catch
            uiwait(errordlg({'error on the weighting step',lasterr}));
        end;
        ModelOut.prediction.xcumpress=loadi;
        
        if (ModelIn.options.rotate>0) & ~isequal(Ny,3),
            uiwait(warndlg({'No rotation core will be done:','data have to be 3-way.'}));
        elseif Ny==3,
            try
                switch ModelIn.options.rotate,
                    case 1,
                        if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))&isequal(ModelIn.nbfactors.min(3),ModelIn.nbfactors.min(2)),
                            [Gy,Oy{1},Oy{2},Oy{3}]=maxdia3(Gy);
                            [Gyvi,Oyvi{1},Oyvi{2},Oyvi{3}]=maxdia3(Gyvi);
                            [Gyvio,Oyvio{1},Oyvio{2},Oyvio{3}]=maxdia3(Gyvio);
                        else
                            uiwait(warndlg({'No rotation core will be done:','the core has to be perfectly cubic,W(1)=W(2)=W(3).'}));
                        end;
                    case 3,
                        [Gy,Oy{1},Oy{2},Oy{3}]=maxvar3(Gy);
                        [Gyvi,Oyvi{1},Oyvi{2},Oyvi{3}]=maxvar3(Gyvi);
                        [Gyvio,Oyvio{1},Oyvio{2},Oyvio{3}]=maxvar3(Gyvio);
                    case 2,
                        if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))
                            [Gy,Oy{1},Oy{2},Oy{3}]=maxswd3(Gy);
                            [Gyvi,Oyvi{1},Oyvi{2},Oyvi{3}]=maxswd3(Gyvi);
                            [Gyvio,Oyvio{1},Oyvio{2},Oyvio{3}]=maxswd3(Gyvio);
                        else,
                            uiwait(warndlg({'No rotation core will be done:','the core has to be so:W(1)=W(2).'}));
                        end;
                end;
            catch 
                uiwait(errordlg({'Error in the rotation core step.',lasterr}));
                return;
            end;
        end;
        if ModelIn.options.rotate>0,
            for i=1:Ny,
                Fy{i}=Fy{i}*Oy{i};
                Fyvi{i}=Fyvi{i}*Oyvi{i};
                Fyvio{i}=Fyvio{i}*Oyvio{i};
            end;
        end;
        
        
        
        % % ModelOut implementation
        close(gcf);
        ModelOut.model.yev=cell(1,3);
        if ~isempty(Gy),
            if isequal(size(Gy),[1 1]),
                ModelOut.model.yev{1}=(Gy.^2)*100/ssy;
            elseif ~isequal(length(size(Gy)),Ny),
                gev=zeros(Ny,max(ModelIn.nbfactors.min));
                ModelOut.model.yev{1}=gev;
            else,
                gev=zeros(Ny,max(ModelIn.nbfactors.min));
                for i=1:Ny,
                    Gfy=nshape(Gy,i);
                    for g=1:ModelIn.nbfactors.min(i),
                        gev(i,g)=sum(Gfy(g,:).^2)*100/ssy;
                    end
                end;
                ModelOut.model.yev{1}=gev;
            end;
        end;
        if ~isempty(Gyvi),
            if isequal(size(Gyvi),[1 1]),
                ModelOut.model.yev{2}=(Gyvi.^2)*100/sspxy;
            elseif ~isequal(length(size(Gyvi)),Ny),
                gev=zeros(Ny,max(ModelIn.nbfactors.min));
                ModelOut.model.yev{2}=gev;
            else,
                gev=zeros(Ny,max(ModelIn.nbfactors.min));
                for i=1:Ny,
                    Gfy=nshape(Gyvi,i);
                    for g=1:ModelIn.nbfactors.min(i),
                        gev(i,g)=sum(Gfy(g,:).^2)*100/sspxy;
                    end
                end;
                ModelOut.model.yev{2}=gev;
            end;
        end;
        if ~isempty(Gyvio),
            if isequal(size(Gyvio),[1 1]),
                ModelOut.model.yev{3}=(Gyvio.^2)*100/ssqxy;
            elseif ~isequal(length(size(Gyvio)),Ny),
                gev=zeros(Ny,max(ModelIn.nbfactors.min));
                ModelOut.model.yev{3}=gev;
            else,
                gev=zeros(Ny,max(ModelIn.nbfactors.min));
                for i=1:Ny,
                    Gfy=nshape(Gyvio,i);
                    for g=1:ModelIn.nbfactors.min(i),
                        gev(i,g)=sum(Gfy(g,:).^2)*100/ssqxy;%  changer
                    end
                end;
                ModelOut.model.yev{3}=gev;
            end;
        end;
        if ~isempty(Gx),
            if isequal(size(Gx),[1 1]),
                ModelOut.model.xev=gv;
            elseif ~isequal(length(size(Gx)),Nx),
                gev=zeros(Nx,max(ModelIn.nbfactors.min));
                ModelOut.model.xev=gev;
            else,
                gev=zeros(Nx,max(ModelIn.nbfactors.max));
                for i=1:Nx,
                    Gfx=nshape(Gx,i);
                    for g=1:ModelIn.nbfactors.max(i),
                        gev(i,g)=sum(Gfx(g,:).^2)*100/ssx;
                    end
                end;
                ModelOut.model.xev=gev;
            end;
        end;
        if ModelIn.valmethod.bootstrap>0,  %bootstrap
            setappdata(mainfig,'Model',ModelIn);
            Factors={Fy,Fyvi,Fyvio};
            set(findobj('tag','plotd3'),'enable','off'); 
            [ModelIn,ModelOut]=tuckerviboot(ModelIn,ModelOut,Factors);
        end;
        ModelOut.model.core=Gx;
        ModelOut.model.xfactors=Fx;
        ModelOut.model.yfactors{1}=Fy;
        ModelOut.model.yfactors{2}=Fyvi;
        ModelOut.model.yfactors{3}=Fyvio;
        ModelOut.model.corey={Gy,Gyvi,Gyvio};
        ModelOut.modelname='IV-Tucker';
        ModelOut.model.bcoeff=B;
        ModelOut.model.ypred=Ypred;
        ModelOut.model.xpress=cell(2,1);
        ModelOut.model.xpress{1}=VPxY;
        ModelOut.model.xpress{2}=VQxY;
        ModelOut.model(1).xpreproc.cen= mcentx;
        ModelOut.model(1).xpreproc.scal=mscalx;
        ModelOut.model(1).ypreproc.cen= mcenty;
        ModelOut.model(1).ypreproc.scal=mscaly;
        ModelOut.prediction.xcumpress=loadi;
        ModelOut.model.iterations=[itx,ity,ityvi,ityvio];
        
        % default plot installation
        defaultplot(ModelIn,ModelOut);
        
    end;%tucker model (opposite to validation)   
    
end;%tucker execution




