function [B,err,errglob,PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] = regressvctuckervi(X,Y,rx,ryvi);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% regresstuckerVI                                    %
%[PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] =                  %
%             regressvctuckerVI(X,Y,rx,ryvi,pro,cent)%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y,X  matrices
%     rx: dimensions of the subspaces 
%             obtained by pca of X
%     ryvi: dimension of pca
%             for PxY
%     pro:2-vector corresponding to the 2 modes
%             1 if we want to project Y along the 
%                 corresponding mode.
%             0 if not.
%      cent=1 means centering (if not, 0 (default))
% OUTPUTS
%     B regression coefficient matrix
%     err  error of prediction by cross validation
%     PxY   the projected of Y on X.
%     vexpvi:Explained variation
%     Avi,Bvi:score and loadings of pca(PxY).
%     vexpX:  explained variation of X.
%     Ax,Bx:loadings of tucker(X).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PCA with Instrumental Variables                 %
%   Solves the problem min||Y-pca(Y)||vv            %
%   with  linear constraints on the modes and       %
%   cross validation in order to estimate           %
%   the accurate of prediction                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    acpVIf                                          %
%    predicacpVI                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   18/09/2002   version 1.2                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


nx=size(X,1);
ny=size(Y,1);

%erreur de format
if ~isequal(nx,ny) 
   error('X and Y must have the same number of lines');
end;
n=nx;
err(1:n(1))=0;
for i=1:n,
    i
   Xvc=X([1:i-1,i+1:n],:,:);
   x=X(i,:,:);
   Yvc=Y([1:i-1,i+1:n],:,:);
   y=Y(i,:,:);
   [B,PxY,vexpvi,Avi,Fyvi,vexpX,Ax,Fx,loadi] = tuckervif(Xvc,Yvc,rx,ryvi);
   Byvi=Fyvi(2:end);
   Bx=Fx(2:end);
   [xpred,fxpred,ypred,fypred] = tuckervipredic(x,B,Byvi,Bx,loadi);
   yn=squeeze(y);

   
   
   %err(i)=100*sum((ypred(:)-yn(:)).^2)/sum((yn.^2));
   err(i)=sum(abs(ypred(:)-yn(:)))/sum(abs(yn(:)));   %MAPE
end;
errglob=mean(err);
%[B,PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] = tuckerVIf(X,Y,rx,ryvi);
