function [Fyb,Gyb,Fyvib,Gyvib,Fyviob,Gyviob,B,loadixb,loadiyb,Ypredb] = naiftuckervi(X,Y,Wx,Wy,k);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% naiftuckervi                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%   X   data
%   Y   data
%   Wx  number of components (3-vector)
%   Wy  number of components (3-vector)
%   k   common modes
% OUTPUTS
%   Factorsb: loadings of Xb bootstrapped from X
%   Gb:   core matrix  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tucker on bootstrap data of X  ( naive bootstrap) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mainfig=findobj('userdata','Cubatch');
mi=getappdata(mainfig,'Model');
Ny=ndims(Y);
Nx=ndims(X);
Ry=size(Y);
Rx=size(X);
constrf=zeros(1,Ny);
eps=mi.options.algorithm.value;
ini=mi.options.algorithm.constants;  % 0 dtld, 1 svd, 2 rand, 10 bestfit
maxit=mi.options.algorithm.maxiter;
rot=mi.options.rotate;
if isempty(mi.nbfactors.max)
   uiwait(errordlg({'mi.nbfactors.max est vide'}));
   return;
end;
[Fx,Gx,vpx]=tucker(X,Wx,[eps ini 0 0 10 maxit]);
ssx=misssum(X(:).^2);
ssy=misssum(Y(:).^2);
[PxY,B]=regression2(Y,Fx,k);
if mi.options.commonmodes,
   Wx=size(Gx);
   Yu=reshape(Y,Ry(1),prod(Ry(2:end)));
   [PxYu,B]=regression2D(Yu,Fx{1}*reshape(Gx,Wx(1),prod(Wx(2:end))));
end;
VPxY=100*sum(PxY(:).^2)/sum(Y(:).^2);
QxY=Y-PxY;
VQxY=100*sum(QxY(:).^2)/sum(Y(:).^2);
sspxy=sum(PxY(:).^2);
ssqxy=sum(QxY(:).^2);
[Fyvib,Gyvib,vpyvib]=tucker(PxY,Wy,[eps ini 0 0 10 maxit],constrf);
[Fyviob,Gyviob,vpyviob]=tucker(QxY,Wy,[eps ini 0 0 10 maxit],constrf);
[Fyb,Gyb,vpyb]=tucker(Y,Wy,[eps ini 0 0 10 maxit],constrf);
if mi.options.commonmodes    % calcul de Ypred
   Ypredb=nmodel(Fyvib,Gyvib);
end;


%  attribution des coef pour que ce soit une projection
loadiyb=Fyvib;
[Fyviob]=tuckerweight(Fyviob,Gyviob);
[Fyvib,loadiyb]=tuckerweight(Fyvib,Gyvib);
[Fyb]=tuckerweight(Fyb,Gyb);



