function [err,rx,ryvi] = choixcompvctuckerVI(Y,X,mi,mo,c);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% choixcompvctuckerVI                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y,X  matrices
%     rxmax: maximal dimensions of the subspaces 
%             obtained by pca of X
%     ryvimax: maximal dimension of pca for PxY
%      cent=1 means centering (if not, 0 (default))
% OUTPUTS
%     err  error of prediction by cross validation 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PCA with Instrumental Variables                 %
%   Solves the problem min||Y-pca(Y)||vv            %
%   with  linear constraints on the modes and       %
%   cross validation in order to estimate           %
%   the accurate of prediction                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    regressvcacpVI                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   20/12/2001   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

guinames;

Rx=size(X);
Ry=size(Y);
algo=mi.options.algorithm.name;
fx=mi.nbfactors.max;
fy=mi.nbfactors.min;
opti=struct('tol',mi.options.algorithm.value,'maxit',mi.options.algorithm.maxiter,'disp',0);
if fx>min(Rx),
    uiwait(errordlg({'Error. The number of components for X',['has to be inferior to ' int2str(min(Rx)),'.']}));
    return;
end;
if fy>min(Ry),
    uiwait(errordlg({'Error. The number of components for X',['has to be inferior to ' int2str(min(Ry)),'.']}));
    return;
end;
% centering scaling


errglob(1:mi.nbfactors.max(1),1:mi.nbfactors.max(2),1:mi.nbfactors.max(3),1:mi.nbfactors.min(1),1:mi.nbfactors.min(2),1:mi.nbfactors.min(3))=nan;
errglob(1:mi.nbfactors.max(1),1:mi.nbfactors.max(2),1:mi.nbfactors.max(3),1:mi.nbfactors.min(1),1:mi.nbfactors.min(2),1:mi.nbfactors.min(3),Rx(1))=nan;
if min([mi.nbfactors.max,mi.nbfactors.max])<1
    uiwait(errordlg({'No cross validation for Tucker 2 or Tucker1'}));
    return;
elseif length(mi.nbfactors.max)~=3|length(mi.nbfactors.min)~=3,
    uiwait(errordlg({'No cross validation for N-way data, N~=3.'}));
    return;   
elseif size(mi.nbfactors.max,1)==1,
    for l=1:mi.nbfactors.min(1),
        for m=1:mi.nbfactors.min(2),
            for n=1:mi.nbfactors.min(3),
                for i=mi.nbfactors.min(1):mi.nbfactors.max(1),
                    for j=mi.nbfactors.min(2):mi.nbfactors.max(2),
                        for k=mi.nbfactors.min(3):mi.nbfactors.max(3),
                            rx=[i,j,k];
                            ryvi=[l,m,n];
                            [B,err(rx(1),rx(2),rx(3),ryvi(1),ryvi(2),ryvi(3),:),errglob(rx(1),rx(2),rx(3),ryvi(1),ryvi(2),ryvi(3)),PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] = regressvctuckervi(X,Y,rx,ryvi);
                        end;
                    end;
                end;
            end;    
        end;
    end;
elseif size(mi.nbfactors.max,1)==2,
    for l=mi.nbfactors.min(1,1):mi.nbfactors.min(2,1),
        for m=mi.nbfactors.min(1,2):mi.nbfactors.min(2,2),
            for n=mi.nbfactors.min(1,3):mi.nbfactors.min(2,3),
                for i=mi.nbfactors.max(1,1):mi.nbfactors.max(2,1),
                    for j=mi.nbfactors.max(1,2):mi.nbfactors.max(2,2),
                        for k=mi.nbfactors.max(1,3):mi.nbfactors.max(2,3),
                            rx=[i,j,k];
                            ryvi=[l,m,n];
                            [B,err(rx(1),rx(2),rx(3),ryvi(1),ryvi(2),ryvi(3),:),errglob(rx(1),rx(2),rx(3),ryvi(1),ryvi(2),ryvi(3)),PxY,vexpvi,Avi,Bvi,vexpX,Ax,Bx] = regressvctuckervi(X,Y,rx,ryvi);
                        end;
                    end;
                end;
            end;    
        end;
    end;    
end;

err
errglob

save err err
save errglob errglob



hfig=1;
h1=uicontrol('parent', hfig,...
    'backgroundcolor',FRC,...
    'position',[10 20 180 460],...
    'tag','textfig',...
    'tooltipstring','',...  
    'style','frame');  
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Size: [',int2str(c{1}.dims),']'],...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 430 120 20],...
    'tooltipstring','',...  
    'style','text');
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Data Y:',c{2}.name],...
    'fontweight','demi',...
    'fontsize',12,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 380 160 20],...
    'tooltipstring',['Author: ',c{2}.author],...  
    'style','text');
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Size: [',int2str(c{2}.dims),']'],...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 360 120 20],...
    'tooltipstring','',...  
    'style','text');
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Validation of PCA'],...
    'fontweight','demi',...
    'fontsize',12,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 300 160 20],...
    'tooltipstring','',...  
    'style','text');
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Algorithm: ',algo],...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 280 120 20],...
    'tooltipstring','',...  
    'style','text');
if size(mi.nbfactors.max,1)==1,
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Number of PC X: [1... ',int2str(mi.nbfactors.max),'].'],...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 260 170 20],...
    'tooltipstring','',...  
    'style','text');
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Number of PC Y: [1... ',int2str(mi.nbfactors.min),'].'],...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 240 170 20],...
    'tooltipstring','',...  
    'style','text');
elseif size(mi.nbfactors.max,1)==2,
    h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Number of PC X: [',int2str(mi.nbfactors.max(1,:)),'x',int2str(mi.nbfactors.max(2,:)),'].'],...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 260 170 20],...
    'tooltipstring','',...  
    'style','text');
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',['Number of PC Y: [',int2str(mi.nbfactors.min(1,:)),'x',int2str(mi.nbfactors.min(2,:)),'].'],...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'horizontalalignment','left',...
    'position',[15 240 170 20],...
    'tooltipstring','',...  
    'style','text');
end;
pre='No preprocessing';
if mi.sam.cen==1,
    pre='Centered';
elseif mi.sam.scal==1
    pre='Scaled';
end;
if mi.sam.cen==1 & mi.sam.scal==1,
    pre='Auto-scaled';
end;
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',pre,...
    'fontweight','normal',...
    'horizontalalignment','left',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'position',[15 220 170 20],...
    'tooltipstring','',...  
    'style','text');
if strcmp(mi.valmethod.name,'nboo'),
    tex='Naive bootstrap';
    tool='';
elseif strcmp(mi.valmethod.name,'rboo'),
    tex='Residual bootstrap';
    tool='';
elseif strcmp(mi.valmethod.name,'cv'),
    tex='Cross Validation';
    tool='1 by 1 cross validation';
end;
h1=uicontrol('parent', hfig,...
    'tag','textfig',...
    'string',tex,...
    'horizontalalignment','left',...
    'fontweight','normal',...
    'fontsize',10,...
    'backgroundcolor',FRC,...
    'position',[15 200 120 20],...
    'tooltipstring',tool,...  
    'style','text');



delete(findobj(get(1,'children'),'tag','cbaxes'));
h=axes('parent',1,'position',sizeaxes{1},'tag','cbaxes');
Wx=mi.nbfactors.max(2,:);
Wy=mi.nbfactors.min(2,:);
bar(squeeze(err(Wx(1),Wx(2),Wx(3),Wy(1),Wy(2),Wy(3),:)));
xlabel(c{1}.modenames{1});
ylabel('MAPE error of prediction');