function TuckerviActivatePlots(mi,mo);

mainfig=findobj('type','figure','userdata','Cubatch');
%construction du uimenu  results
h0=findobj('tag','res');
delete(allchild(h0));
set(h0,'enable','on');
Nx=length(mo.model.xfactors);
Ny=length(mo.model.yfactors{1});
if size(mo.model.yfactors{1},2)==1,
    Ny=1;
end;


wpi=cell(1:Ny);
for i=1:Ny,
   wpi{i}=['PlotStr.nummode=',int2str(i),';'];
   nom=['Mode ',int2str(i)];
   h1 = uimenu('Parent',h0, ...
      'Label',nom);
   for j=1:3,
      wp1='PlotStr=getappdata(gcbf,''PlotStr'');';
      wp2=['PlotStr.plotdims=',int2str(j),';'];
      wp3='setappdata(gcbf,''PlotStr'',PlotStr);';
      wp4=['tuckerviplot(''graY'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
      nom=[int2str(j),'-D plots'];
      tg=['plotd',int2str(j),int2str(i)];
      h2 = uimenu('Parent',h1, ...
         'Callback',[wp1,wpi{i},wp2,wp3,wp4],...
         'Label',nom, ...
         'Tag',tg);
   end;
   if mi.nbfactors.min(i)<3, %conditions pour f petit
      set(findobj('tag',['plotd3',int2str(i)]),'enable','off');
      if mi.nbfactors.min(i)<2,
         set(findobj('tag',['plotd2',int2str(i)]),'enable','off');
         if mi.nbfactors.min(i)<1,
            set(findobj('tag',['plotd1',int2str(i)]),'enable','off');
         end;
      end;
   end;
   if mi.valmethod.bootstrap>0,   %No 3D plots for bootstrap
      set(findobj('tag',['plotd3',int2str(i)]),'enable','off');
   end
end;
h1 = uimenu('Parent',h0, ...
   'tag','mm',...
   'Label','Mixed modes');
wpi=cell(Ny,Ny);
for i=1:Ny,
   for j=[1:i-1 i+1:Ny],
      nom=['Modes ',int2str(i),'*',int2str(j)];
      h2 = uimenu('Parent',h1, ...
         'Label',nom);
      wpi{i,j}=['PlotStr.nummode=[',int2str(i),',',int2str(j),'];'];
      for k=1:3,
         wp1='PlotStr=getappdata(gcbf,''PlotStr'');';
         wp2=['PlotStr.plotdims=',int2str(k),';'];
         wp3='setappdata(gcbf,''PlotStr'',PlotStr);';
         wp4=['tuckerviplot(''graY'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
         nom=[int2str(k),'-D plots'];
         tg=['plotd',int2str(k),int2str(i),int2str(j)];
         h3 = uimenu('Parent',h2, ...
            'Callback',[wp1,wpi{i,j},wp2,wp3,wp4],...
            'Label',nom, ...
            'Tag',tg);
         so=sort([i,j]);
         pr=prod(mi.nbfactors.min([1:so(1)-1,so(1)+1:so(2)-1,so(2)+1:Ny]));
         if pr<k,
            set(h3,'enable','off');
         end;
      end;
   end;
end;

if min(mi.nbfactors.max)<1|mi.valmethod.bootstrap>0|Ny<3,   %tucker 2or bootstrap
   set(findobj('tag','mm'),'enable','off'); %mm mixed modes
end;




h1 = uimenu('Parent',h0, ...
   'Label','Explained Variation', ...
   'separator','on',...
   'Tag','Exp Var');
h2 = uimenu('Parent',h1, ...
   'Label','Tucker(Y)', ...
   'callback','tuckerviplot(''exvy'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''));',...
   'Tag','Exp Var');
h2 = uimenu('Parent',h1, ...
   'Label','Tucker(PxY)', ...
   'callback','tuckerviplot(''exvyvi'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''));',...
   'Tag','Exp Var');
h2 = uimenu('Parent',h1, ...
   'Label','Tucker(QxY)', ...
   'callback','tuckerviplot(''exvyvio'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''));',...
   'Tag','Exp Var');
h1 = uimenu('Parent',h0, ...
   'Label','Landscape of Model', ...
   'separator','on',...
   'callback','tuckerviplot(''xmo'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''));',...
   'Tag','mod');
h1 = uimenu('Parent',h0, ...
   'Label','Landscape of Residuals', ...
   'enable','on',...
   'callback','tuckerviplot(''res'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''),getappdata(gcbf,''X''));',...
   'Tag','mod');

h1 = uimenu('Parent',h0, ...
    'separator','on',...
    'Label','Prediction', ...
    'Tag','pred');
h2 = uimenu('Parent',h1, ...   %regression part
    'Label','Regressions', ...
    'callback','tuckerviplot(''reg'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''),getappdata(gcbf,''X''));');

h2 = uimenu('Parent',h1, ... %lines
    'Label',['Lines'], ...
    'callback','tuckerviplot(''lineoripred'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''),getappdata(gcbf,''X''));',...
    'Tag',['mod',int2str(i)]);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% not for the moment
% h1 = uimenu('Parent',h0, ... % unvisible
%    'Label','Model X', ...
%    'enable','off',...
%    'visible','off',...
%    'separator','on',...
%    'Tag','mod');
% wpi=cell(1:Nx);   %X
% for i=1:Nx,
%    wpi{i}=['PlotStr.nummode=',int2str(i),';'];
%    nom=['Mode ',int2str(i)];
%    h2 = uimenu('Parent',h1, ...
%       'Label',nom);
%    for j=1:3,
%       wp1='PlotStr=getappdata(gcbf,''PlotStr'');';
%       wp2=['PlotStr.plotdims=',int2str(j),';'];
%       wp3='setappdata(gcbf,''PlotStr'',PlotStr);';
%       wp4=['tuckerviplot(''graX'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
%       nom=[int2str(j),'-D plots'];
%       tg=['plotXd',int2str(j),int2str(i)];
%       h3 = uimenu('Parent',h2, ...
%          'Callback',[wp1,wpi{i},wp2,wp3,wp4],...
%          'Label',nom, ...
%          'Tag',tg);
%    end;
%    if mi.nbfactors.max(i)<3, %conditions pour f petit
%       set(findobj('tag',['plotXd3',int2str(i)]),'enable','off');
%       if mi.nbfactors.max(i)<2,
%          set(findobj('tag',['plotXd2',int2str(i)]),'enable','off');
%          if mi.nbfactors.max(i)<1,
%             set(findobj('tag',['plotXd1',int2str(i)]),'enable','off');
%          end;
%       end;
%    end;
% end;
% h2 = uimenu('Parent',h1, ...
%    'tag','mm',...
%    'Label','Mixed modes');
% wpi=cell(Nx,Nx);
% for i=1:Nx,
%    for j=1:Nx,
%       nom=['Modes ',int2str(i),'*',int2str(j)];
%       h3 = uimenu('Parent',h2, ...
%          'Label',nom);
%       wpi{i,j}=['PlotStr.nummode=[',int2str(i),',',int2str(j),'];'];
%       for k=1:3,
%          wp1='PlotStr=getappdata(gcbf,''PlotStr'');';
%          wp2=['PlotStr.plotdims=',int2str(k),';'];
%          wp3='setappdata(gcbf,''PlotStr'',PlotStr);';
%          wp4=['tuckerviplot(''graX'',getappdata(gcbf,''PlotStr''),getappdata(gcbf,''Model''),getappdata(gcbf,''Results''));'];
%          nom=[int2str(k),'-D plots'];
%          tg=['plotXd',int2str(k),int2str(i),int2str(j)];
%          h4 = uimenu('Parent',h3, ...
%             'Callback',[wp1,wpi{i,j},wp2,wp3,wp4],...
%             'Label',nom, ...
%             'Tag',tg);
%       end;
%    end;
% end;
% 
% if min(mi.nbfactors.max)<1, %tucker 2
%    set(findobj('tag','mm'),'enable','off');
% end;
% 
% h2 = uimenu('Parent',h1, ...
%    'Label','Explained Variation', ...
%    'separator','on',...
%    'callback','tuckerviplot(''exv'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''));',...
%    'Tag','Exp Var');
% h2 = uimenu('Parent',h1, ...
%    'Label','Landscape of Model', ...
%    'separator','on',...
%    'callback','tuckerviplot(''xmo'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''));',...
%    'Tag','mod');
% h2 = uimenu('Parent',h1, ...
%     'Label','Landscape of Residuals', ...
%     'enable','on',...
%     'callback','tuckerviplot(''res'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''),getappdata(gcbf,''X''));',...
%     'Tag','mod');
% h0 = uimenu('Parent',h1, ...
%     'separator','on',...
%     'Label','Prediction', ...
%     'Tag','pred');
% h2 = uimenu('Parent',h0, ...   %regression part
%     'Label','Regressions', ...
%     'callback','tuckerviplot(''reg'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''),getappdata(gcbf,''X''));');
% 
% h2 = uimenu('Parent',h0, ...
%     'Label',['Lines'], ...
%     'callback','tuckerviplot(''lineoripred'',[],getappdata(gcbf,''Model''),getappdata(gcbf,''Results''),getappdata(gcbf,''Content''),getappdata(gcbf,''X''));',...
%     'Tag',['mod',int2str(i)]);