function [Fw,load]=tuckerweight(F,G);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tuckerweight                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%    F      Loadings of tucker
%    G      Core of Tucker
% OUTPUTS
%    Fw     Weighted loadings of Tucker
%    load   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Weight loadings of tucker by values of the core    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   30/08/2002   version 1.1                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Attribution des coef pour que ce soit une projection
W=0;
Wg=size(G);
Ng=length(Wg);
N=length(F);
for i=1:N,
   W(i)=size(F{i},2);
end;
for i=1:Ng,
   Wi=W([i,1:i-1,i+1:N]);
   mi=min(Wi(1),prod(Wi([2:N])));
   %if ~isequal(W(i),1)
   Gt=permute(G,[i,1:i-1,i+1:Ng]);
   Wgt=size(Gt);
   Ngt=length(Wgt);
   Fac{i}=F{i}*reshape(Gt,[Wgt(1) prod(Wgt(2:Ngt))]);
   [U S V]=svd(Fac{i},0);
   Fw{i}=U(:,1:mi)*S(1:mi,1:mi);
   load{i}=V(:,1:mi);
end;
for i=Ng+1:N,
   Gt=G(:)';
   Fac{i}=F{i}*Gt;
   [U S V]=svd(Fac{i},0);
   Fw{i}=U(:,1)*S(1,1);
   load{i}=V(:,1);
end;
