function [xp,fxp,fxpw]=tuckerproj(typ,x,L,rab);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tuckerproj                                         %
% [ypred] = tuckerproj(x,B,Byvi,Bx);                 %
% test: [ypred] = tuckervipredic(rand(5,3),rand(4,15)%
%        {rand(5,2),rand(3,2)},{rand(5,2),rand(3,2)})%
%                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     typ! 'mm' or 'ms'  mixed/single mode
%     x :  p-vector
%     L: loadings of tucker(X)  cell (size Nx-1)
% OUTPUTS
%     xp  projection initial space (slab)
%     fxp projection new space (vector)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Projection for tucker                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE                                        %
%    regression2D                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   01/09/2002   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mo=getappdata(gcbf,'Results');
Rx=size(x);   % diff
Mx=length(L);  % diff de Ny

if strcmp(typ,'sm'),
    
    %pretreatment of x
    %if 
    
    
    for i=1:Mx,
        [Rx(i),Wx(i)]=size(L{i});
    end;
    xu=reshape(x,1,prod(Rx));
    
    %projection de x sur col[Bx]
    %[xp,fxp]=regression2D(xu',nkron(L{:}));
    
    core=mo.model.core;
    W=size(core);
    coreu=reshape(core,W(1),prod(W(2:end)));
    L=fliplr(L);
    a1 = nkron(L{:});
    a2 = coreu';
    a12 = a1*a2;
    [xp,fxp]=regression2D(xu',a12);
    
    [xp,fxpw_pre]=regression2D(xu',a1);  %weighted    
    loadi=mo.prediction.xcumpress{1};
    % loadi -- V of the SVD on Fac (?) 
    %         ....not sure, see: tuckerweight -->
    %                                evoke from tuckerb
    %
    [bibifricotin,fxpw]=regression2D(fxpw_pre,loadi);
    fxp=fxp';
    fxpw=fxpw';
    xp=reshape(xp,Rx);
elseif strcmp(typ,'mm'),  %mixed mode
     L=fliplr(L);
    [xp,fxpw]=regression2D(x',nkron(L{:}));  %weighted
    %[bibifricotin,fxpw]=regression2D(fxpw,rab);% rab=p2
    fxpw=fxpw';
    fxp=[];
    xp=xp';
end;
