function tuckerplot(typ,spl,mi,mo,c,d);

%  typ: 'gra','mod','exv','res','xmo'
%  spl for PlotStr structure
%  mi for ModelIn structure
%  mo for modelOut structure
%  c for content object 
%  d is the CBdataset object

Guinames;
mainfig=findobj(0,'type','figure','userdata','Cubatch');
if nargin==6,
    X=d{1}.data;
end;
if strcmp(typ,'gra'),  %window building
    [mi,mo,spl]= checkp(mi,mo,spl);
    tuckerplotwindow(spl,mi,mo);
    setcvdata(mainfig,'PlotStr',spl,'Results',mo,'Model',mi);
    h=findobj('tag','tuckerplot');
    set(h,'waitstatus','open');
    waitfor(h,'waitstatus','close');
else %    (graphiques)
    if ~isempty(spl),
        setcvdata(mainfig,'PlotStr',spl);
    end;
    set(0,'currentfigure',mainfig);
    delete(findobj('tag','cbaxes'));
    hhh=axes('parent',mainfig,'tag','cbaxes','nextplot','replacechildren');
    cop=get(gca,'colororder');
    [tacop,rr]=size(cop);
    set(hhh,'position',sizeaxes{1}(1,:));
    dim=c{1}.dims;
    N=length(dim);
    switch typ  % different kinds of graphics  
    case 'mod'  % 123-D plots
        dim=c{1}.dims;
        N=length(dim);
        %dimt=[0 0 0 0 0 0 0 0 0 0 0 0]; %provisoire
        nt=length(spl.batch);
        coul=3;%couleur(nt);
        %dif  0 --> no projection data
        %     1 --> projection data single mode
        %     2 --> projection data mixed mode
        if  ~isempty(mo.prediction.data),
                Nn=length(mo.prediction.data.dims);
                dif=N-Nn+1;
        else
            dif=0;
        end;
        % handle the ploting of 
        %           orig data on mixed modes  --O.K.
        % -------------------------
        if length(spl.nummode)>1,   %mixed modes
            [a1,b1]=size(mo.model.xfactors{spl.nummode(1)});
            [a2,b2]=size(mo.model.xfactors{spl.nummode(2)});
            
            % A1 -- for debuging
           %  A1=kron(mo.model.xfactors{spl.nummode(1)},mo.model.xfactors{spl.nummode(2)})
            A=kron(mo.model.xfactors{spl.nummode(1)},mo.model.xfactors{spl.nummode(2)});
            mini=min(spl.nummode);
            maxi=max(spl.nummode);
            % constrained
            % -------------
            if spl.additional.state,  
                Gd=permute(mo.model.core,[spl.nummode(1) , ...
                                          spl.nummode(2) , ...
                                          1:mini-1,mini+1:maxi-1,maxi+1:N] ...
                                          );
                %  reshape(Gd,[mi.nbfactors.min(mini)*mi.nbfactors.min(maxi),prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:N]))])
                
                Gd=reshape(Gd,[mi.nbfactors.min(mini)*mi.nbfactors.min(maxi), ...
                              prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:N]))]);
                
                A=A*Gd;
                j=prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:N]));
                [a,b]=size(A);
                if j<b,
                    A=A(:,1:j);
                end;
            % projection
            % -------------
            else 
                L=mo.model.xfactors([1:mini-1,mini+1:maxi-1,maxi+1:N]);
                L=fliplr(L);
                X=getappdata(mainfig,'X');
                X=X{1}.data;
                if sum([mi.sam(1).cen(1),mi.var.cen,mi.sam(1).scal(1),mi.var.scal])>0,
                    try
                        [X,mo.model(1).xpreproc.cen,mo.model(1).xpreproc.scal]=nprocess(X,[mi.sam(1).cen(1),mi.var(1).cen],[mi.sam(1).scal(1),mi.var(1).scal]);
                    catch
                        uiwait(errordlg({'Error in the preprocessing part.',lasterr}));
                    end;
                end;
                Rp=size(X);
                X=permute(X,[spl.nummode(2),spl.nummode(1),1:mini-1,mini+1:maxi-1,maxi+1:N]);
                Xu=reshape(X,[Rp(mini)*Rp(maxi),prod(Rp([1:mini-1,mini+1:maxi-1,maxi+1:N]))]);
                [xp,A]=regression2D(Xu',nkron(L{:}));  %weighted
                A=A';
            end;
            j=prod(mi.nbfactors.min([1:mini-1,mini+1:maxi-1,maxi+1:N]));
            [a,b]=size(A);
            if j<b,
                A=A(:,1:j);
            end; 
            % handle the ploting of 
            %           projection on mixed modes
            % -------------------------
            if  ~isempty(mo.prediction.data),
                
                
                    Nn=length(mo.prediction.data.dims);
                    if (isequal(sort(spl.nummode),[1,2])),
                        if Nn==N,
                            dd=mo.prediction.data.data;
                            if sum([mi.sam(1).cen(1),mi.var(1).cen,mi.sam(1).scal(1),mi.var(1).scal])>0,
                                dd=nprocess(dd , [mi.sam(1).cen(1),mi.var(1).cen], ...
                                    [mi.sam(1).scal(1),mi.var(1).scal] , ...
                                    mo.model.xpreproc.cen,mo.model.xpreproc.scal, ...
                                    1 );
                            end;
                            dd=reshape(dd,[prod(mo.prediction.data.dims(1:2)),prod(mo.prediction.data.dims(3:end))]);
                        elseif Nn==N-1
                            dd=mo.prediction.data.data;
                        end;
                        Nf=size(dd,1);
                        Np=ndims(mo.prediction.data);
                        for i=1:Nf,
                            ind=repmat({':'},Np,1);
                            ind{1}=i;
                            [xp,f,fw] = tuckerproj('mm',squeeze(dd(ind{:})),mo.model.xfactors(3:end)); %mm   
                            fxpredw(i,:)=fw;
                        end; 
                      
                    
                    else
                           h = msgbox('projection on mixed modes -- display only mode 1 & 2'); 

                    end; 
                
            end;
        else   %simple mode
            if spl.additional.state,
                A=mo.model.yfactors{spl.nummode};
            else
                A=mo.model.xfactors{spl.nummode};
            end;
            [a,b]=size(A);
        end;
        switch mi.valmethod.bootstrap,
        case 0,   %No bootstrap
            switch spl.plotdims
                
            % 1D plot    
            % -------    
            case 1, %1D plot
                
                if  spl.factors(1)< b+1,
                    if length(spl.nummode)<2,
                        plot(A(:,spl.factors(1)),'tag','plo','color',spl.color);
                    else
                        for j=1:a1,
                            plot(A((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                            hold on;
                        end;
                    end;
                else
                    plot(A,'tag','plo');
                end;
                
                switch spl.format(1),
                case 1 %integer
                    set(findobj('tag','plo'),'marker','none');
                    if  spl.factors(1)< b+1,
                        if length(spl.nummode)<2
                            for i=1:a,
                                text(i,A(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2','clipping','on');
                            end;
                        else % mixed modes
                            for i=1:a2
                                for j=1:a1,
                                    text(i,A((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                                end; 
                            end;
                        end;
                    else,   
                        for j=1:b
                            for i=1:a,
                                text(i,A(i,j),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                            end; 
                        end;
                    end;
                case 2,%label
                    set(findobj('tag','plo'),'marker','none');
                    if  spl.factors(1)< b+1,
                        if length(spl.nummode)<2
                            for i=1:a,
                                text(i,A(i,spl.factors(1)),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2','clipping','on');
                            end;
                        else % mixed modes
                            for i=1:a2
                                for j=1:a1,
                                    text(i,A((j-1)*a2+i,spl.factors(1)),c{1}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                                end; 
                            end;
                        end;
                    else 
                        for j=1:b
                            for i=1:a,
                                text(i,A(i,j),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                            end; 
                        end;
                    end;
                case 3 %marker
                end;
                
                %  projection
                % -------------- 
                hold on;   %  projection
                if ~isempty(mo.prediction.data) & spl.nummode==1 & length(spl.nummode)==1,
                    aa=size(mo.model.xfactors{1},1);
                    uu=size(mo.prediction.xfactors{1},1);
                    if spl.additional.state==0  % normed
                        plot(aa+1:aa+uu,mo.prediction.xfactors{1}(:,spl.factors(1)),'tag','proj');
                    elseif spl.additional.state
                        plot(aa+1:aa+uu,mo.prediction.yfactors{1}(:,spl.factors(1)),'tag','proj');
                    end;
                elseif length(spl.nummode)==2 & (spl.nummode==[1,2]|spl.nummode==[2,1]) &dif>0,
                    aa=size(A,1);
                    uu=size(fxpredw,1);
                    plot(fxpredw(aa+1:aa+uu,spl.factors(1)),'tag','proj');  
                end;
            % 2D plot    
            % -------
            case 2,   % 2D plots
                if length(spl.nummode)<2,
                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'color',spl.color,'tag','plo');
                else
                    for j=1:a1,
                        plot(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                        hold on;
                    end;
                end;
                switch spl.format(1)
                case 1 %integer
                    set(findobj('tag','plo'),'marker','none');
                    if length(spl.nummode)<2,
                        for i=1:dim(spl.nummode),
                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2','clipping','on');
                        end;
                    else %mixed modes
                        for i=1:a2
                            for j=1:a1,
                                text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                            end; 
                        end;               
                    end;
                case 2,%label
                    set(findobj('tag','plo'),'marker','none');
                    if length(spl.nummode)<2
                        for i=1:dim(spl.nummode),
                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2','clipping','on');
                        end;
                    else %mixed modes
                        for i=1:a2
                            for j=1:a1,
                                text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),c{1}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                            end; 
                        end;               
                    end;
                case 3 %marker 
                end;
                hold on;   %  projection
                mo.prediction.xfactors;
                if  spl.nummode==1 & length(spl.nummode)==1 & dif==1,
                    if spl.additional.state==0  % normed
                         plot(mo.prediction.xfactors{1}(:,spl.factors(1)),mo.prediction.xfactors{1}(:,spl.factors(2)),'tag','proj');
                    elseif spl.additional.state
                        plot(mo.prediction.yfactors{1}(:,spl.factors(1)),mo.prediction.yfactors{1}(:,spl.factors(2)),'tag','proj');
                    end;
                elseif length(spl.nummode)==2 & (spl.nummode==[1,2]|spl.nummode==[2,1]) &dif>0 ,
                    
                    % Cu_Fix_2011 (ad-hoc...)
                    
                    plot(fxpredw([1,4],spl.factors(1)),fxpredw([1,4],spl.factors(2)),'b','tag','proj');
                    plot(fxpredw([2,5],spl.factors(1)),fxpredw([2,5],spl.factors(2)),'g','tag','proj');
                    plot(fxpredw([3,6],spl.factors(1)),fxpredw([3,6],spl.factors(2)),'r','tag','proj'); 
                end;
            % 3D plot    
            % -------
            case 3,  %3D plot
                set(gca,'view',[-37.5 30])
                if length(spl.nummode)<2,
                    plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                else,
                    for j=1:a1,
                        plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                        hold on;
                    end;
                end;
                switch spl.format(1)
                case 1 %integer
                    set(findobj('tag','plo'),'marker','none');
                    if length(spl.nummode)<2,
                        for j=1:dim(spl.nummode),
                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2','clipping','on');
                        end;
                    else
                        for i=1:a2
                            for j=1:a1,
                                text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                            end; 
                        end;                  
                    end;                 
                case 2,%label
                    set(findobj('tag','plo'),'marker','none');
                    if length(spl.nummode)<2,
                        for j=1:dim(spl.nummode),
                            text(A(j,spl.factors(1)),A(j,spl.factors(2)) , ...
                                A(j,spl.factors(3)) , ...
                                c{1}.labels{spl.nummode}(j), ...
                                 'fontsize',7,'color',spl.color,'tag', ...
                                 'plo2','clipping','on');
                        end;
                    else
                        for i=1:a2
                            for j=1:a1,
                                text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),c{1}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2','clipping','on');
                            end; 
                        end;                  
                    end;
                case 3 %marker
                    
                end;
                 

                hold on;   
                %  projection - 3D (simple mode)
                %-------------------------------
                if ~isempty(mo.prediction.data) & spl.nummode==1 & length(spl.nummode)==1,
                    spl.additional.state
                    % normed 
                    
                    % xfactors -- the orignal factors
                    
                    % (Scaled)  -- O.K.
                    % --------
                    if spl.additional.state==0,   
                        plot3(mo.prediction.xfactors{1}(:,spl.factors(1)),mo.prediction.xfactors{1}(:,spl.factors(2)),mo.prediction.xfactors{1}(:,spl.factors(3)),'tag','proj');
                        
                     % yfactors -- the factors after mult. by the core
                     %      (down by tuckerapply()/tuckerweight() func. ivoked from tuckerb() )
                     
                    %  (Weighted) -- O.K.
                    %  ----------
                    elseif spl.additional.state,
                        plot3(mo.prediction.yfactors{1}(:,spl.factors(1)),mo.prediction.yfactors{1}(:,spl.factors(2)),mo.prediction.yfactors{1}(:,spl.factors(3)),'tag','proj');
                    end;  
                elseif length(spl.nummode)==2 & (spl.nummode==[1,2]|spl.nummode==[2,1]) &dif>0, 
                    % Cu_FIX_2011 (ad-hoc) 
                         
                  %  plot3(fxpredw(:,spl.factors(1)),fxpredw(:,spl.factors(2)),fxpredw(:,spl.factors(3)),'tag','proj');
                          
                  if spl.additional.state,
                        plot3(mo.prediction.yfactors{1}(:,spl.factors(1)),mo.prediction.yfactors{1}(:,spl.factors(2)),mo.prediction.yfactors{1}(:,spl.factors(3)),'tag','proj');
                  else  
                    plot3(fxpredw([1,2],spl.factors(1)),fxpredw([1,2],spl.factors(2)),fxpredw([1,2],spl.factors(3)),'.-b','tag','proj');
                    plot3(fxpredw([3,4],spl.factors(1)),fxpredw([3,4],spl.factors(2)),fxpredw([3,4],spl.factors(3)),'.-g','tag','proj');
                     plot3(fxpredw([5,6],spl.factors(1)),fxpredw([5,6],spl.factors(2)),fxpredw([5,6],spl.factors(3)),'.-r','tag','proj');
                  end;      
                     
%                     plot3(fxpredw([1],spl.factors(1)),fxpredw([1],spl.factors(2)),fxpredw([1],spl.factors(3)),'.-b','tag','proj');
%                     plot3(fxpredw([2],spl.factors(1)),fxpredw([2],spl.factors(2)),fxpredw([2],spl.factors(3)),'.-g','tag','proj');
%                     plot3(fxpredw([3],spl.factors(1)),fxpredw([3],spl.factors(2)),fxpredw([3],spl.factors(3)),'.-r','tag','proj');
        
                end; 
                if isequal(spl.additional.shadow, 1),
                    axe=axis;
                    if length(spl.nummode)<2,
                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2');
                        plot3(A(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                        plot3(axe(2)*ones(dim(spl.nummode),1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                    else
                        for j=1:a1,
                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2');
                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                            plot3(axe(2)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                        end;
                    end;
                end;
                
                hold off;
            end;
            if spl.format(1)==3,
                set(findobj('tag','plo'),'marker',spl.marker);
            end;
            set(findobj('tag','plo'),'linestyle',spl.linestyle);
            
            switch spl.format(2)
            case 2 %discrete
                set(findobj('tag','plo'),'linestyle','none');
            case 1% continuous
                %set(findobj('tag','plo'),'marker','none');
            end;
            
            
        case 1,   %Naive bootstrap tucker
            switch spl.plotdims,
            case 1, %1D plot
                spl.plotdims=1;
                plot(A(:,spl.factors(1)),'tag','plo');
                hold on;
                if isequal(spl.nummode,1),
                    for i=1:mi.valmethod.replicates,
                        uu=mo.validation.segments(:,i);
                        if spl.additional.state
                            Ab=mo.validation.yfactors{spl.nummode}(:,:,i);
                        else
                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                        end;
                        if Ab(:,spl.factors(1))'*mo.model.xfactors{spl.nummode}(uu,spl.factors(1))<0
                            Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                        end;
                        plot(uu,Ab(:,spl.factors(1)),'+b','tag','plo2');
                    end;
                elseif spl.nummode>1,
                    for i=1:mi.valmethod.replicates,
                        if spl.additional.state
                            Bb=mo.validation.yfactors{spl.nummode}(:,:,i);
                        else
                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                        end;                       
                        plot(Bb(:,spl.factors(1)),'+b','tag','plo2');
                    end;
                end;
                plot(A(:,spl.factors(1)),'tag','plo');
                set(findobj('tag','plo'),'color',spl.color);
                if spl.format(1)==3,
                    set(findobj('tag','plo'),'marker',spl.marker);
                else
                    set(findobj('tag','plo'),'marker','none');
                    if spl.format(1)==2,
                        for jj=1:c{1}.dims(spl.nummode),
                            text(jj,A(jj,spl.factors(1)),c{1}.labels{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2','clipping','on');
                        end;
                    end;
                end;
                switch spl.format(2),
                case 2 %discrete
                    set(findobj('tag','plo'),'linestyle','none');
                case 1% continuous
                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                end;  
            case 2,  %2D plot
                coul=couleur(c{1}.dims(spl.nummode));
                spl.plotdims=2;
                plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                hold on;
                if isequal(spl.nummode,1),
                    m(1:c{1}.dims(1))=0;
                    for i=1:mi.valmethod.replicates,
                        uu=mo.validation.segments(:,i);
                        Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                        for v=1:mi.nbfactors.min, % changement de signe du mode 1
                            if Ab(:,v)'*A(uu,v)<0
                                Ab(:,v)=-Ab(:,v);
                            end
                        end;
                        for j=1:c{1}.dims(1),  %on elimine les points redondants 
                            rr=uu(j);
                            if j>1 & mean(uu(j)==uu(1:j-1))>0
                            else
                                m(rr)=m(rr)+1;
                                Abstock{uu(j)}(m(rr),:)=Ab(j,:);
                            end;
                        end;
                    end;
                    for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                        Abech=Abstock{jj}(:,:);
                        tai=size(Abech);
                        if tai(1)>2,
                            k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                            aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                            fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                            hold on;
                        end;
                        if spl.format(1)==1,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');
                        elseif spl.format(1)==2,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),c{1}.labels{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                        elseif spl.format(1)==3,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on'); 
                        end;
                    end;
                elseif spl.nummode>1,
                    for i=1:mi.valmethod.replicates,
                        Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                        Bbstock(i,:,:)=Bb(:,:);	
                    end;
                    for jj=1:c{1}.dims(spl.nummode),   %tracage des enveloppes convexes
                        Bbech=squeeze(Bbstock(:,jj,:));
                        tai=size(Bbech);
                        if tai(1)>2
                            k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                            aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                            fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                            hold on;
                        end;
                        if spl.format(1)==1,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');
                        elseif spl.format(1)==2,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),c{1}.labels{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');
                        elseif spl.format(1)==3,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');                        
                        end;
                    end;
                    % mettre 
                end;  %if/elseif nummode
                plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                set(findobj('tag','plo'),'marker','none');
                switch spl.format(2),
                case 2 %discrete
                    set(findobj('tag','plo'),'linestyle','none');
                case 1% continuous
                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                    set(findobj('tag','plo'),'color',spl.color);
                end;   
            end; %switch spl.plotdims
        case 2,   %Residual bootstrap tuckerplot
            switch spl.plotdims,
            case 1, %1D plot
                spl.plotdims=1;
                plot(A(:,spl.factors(1)),'tag','plo');
                hold on;
                if isequal(spl.nummode,1),
                    for i=1:mi.valmethod.replicates,
                        Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                        if Ab(:,spl.factors(1))'*A(:,spl.factors(1))<0
                            Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                        end;
                        plot(Ab(:,spl.factors(1)),'b','tag','plo2');
                        hold on;
                    end;
                elseif spl.nummode>1,
                    for i=1:mi.valmethod.replicates,                  
                        Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                        plot(Bb(:,spl.factors(1)),'b','tag','plo2');
                        hold on;
                    end;
                end;
                plot(A(:,spl.factors(1)),'tag','plo');
                set(findobj('tag','plo'),'color',spl.color);
                if spl.format(1)==3,
                    set(findobj('tag','plo'),'marker',spl.marker);
                else
                    set(findobj('tag','plo'),'marker','none');
                    if spl.format(1)==2,
                        for jj=1:c{1}.dims(spl.nummode),
                            text(jj,A(jj,spl.factors(1)),c{1}.labels{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2','clipping','on');
                        end;
                    end;
                end;
                switch spl.format(2),
                case 2 %discrete
                    set(findobj('tag','plo'),'linestyle','none');
                case 1% continuous
                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                end;  
            case 2,  %2D plot
                coul=couleur(c{1}.dims(spl.nummode));
                spl.plotdims=2;
                plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                hold on;
                if isequal(spl.nummode,1),
                    m(1:c{1}.dims(1))=0;
                    for i=1:mi.valmethod.replicates,
                        Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                        Abstock(i,:,:)=Ab(:,:);
                        for v=1:mi.nbfactors.min, % changement de signe du mode 1
                            if Ab(:,v)'*A(:,v)<0
                                Ab(:,v)=-Ab(:,v);
                            end
                        end;
                    end;
                    for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                        Abech=squeeze(Abstock(:,jj,:));
                        tai=size(Abech);
                        if tai(1)>2,
                            k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                            aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                            fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                            hold on;
                        end;
                        if spl.format(1)==1,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');
                        elseif spl.format(1)==2,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),c{1}.labels{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');
                        elseif spl.format(1)==3,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on'); 
                        end;
                    end;
                elseif spl.nummode>1,
                    for i=1:mi.valmethod.replicates,
                        Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                        Bbstock(i,:,:)=Bb(:,:);	
                    end;
                    for jj=1:c{1}.dims(spl.nummode),   %traage des enveloppes convexes
                        Bbech=squeeze(Bbstock(:,jj,:));
                        tai=size(Bbech);
                        if tai(1)>2
                            k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                            aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                            fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                            hold on;
                        end;
                        if spl.format(1)==1,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');
                        elseif spl.format(1)==2,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),c{1}.labels{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on');
                        elseif spl.format(1)==3,
                            text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2','clipping','on'); 
                        end;
                    end
                end;  %if/elseif
                plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                set(findobj('tag','plo'),'marker','none');
                switch spl.format(2),
                case 2 %discrete
                    set(findobj('tag','plo'),'linestyle','none');
                case 1% continuous
                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                    set(findobj('tag','plo'),'color',spl.color);
                end; 
            end; %switch spl.plotdims       
        end; %switch s.bootstrap
        if spl.additional.quality.exist & length(spl.nummode)<2 % quality
            h=get(findobj('tag','cbaxes'),'children');
            hu=findobj(h,'type','text');
            nhu=length(hu);
            Ng=ndims(mo.model.core);
            F=mo.model.xfactors;
            F{spl.nummode}=mo.model.xfactors{spl.nummode}(:,spl.factors(1:spl.plotdims));
            G=permute(mo.model.core,[spl.nummode,1:spl.nummode-1,spl.nummode+1:Ng]);
            G=G(spl.factors(1:spl.plotdims),:,:);
            G=ipermute(G,[spl.nummode,1:spl.nummode-1,spl.nummode+1:Ng]);
            Xm=nmodel(F,G);
            X=getappdata(mainfig,'X');
            X=X{1}.data;
            [hh,quality]=qualitecube(X,Xm);
            for i=1:nhu,
                if quality{spl.nummode}(i)<spl.additional.quality.limqual
                    set(hu(i),'color',[0.85 0.85 0.85]);
                end;
            end;
        end;
        if length(spl.nummode)>1 |spl.factors(1)> b,
            xl=['PC',int2str(spl.factors(1))];
            if spl.factors(1)> b,
                xl=['All PC'];
                for i=1:b
                    leg{i}=['PC',int2str(i)];
                end;
                legend(leg{:},0);
            end;
        else
            xl=['PC',int2str(spl.factors(1)),':',num2str(mo.model.xev(spl.nummode,spl.factors(1))),'%'];
        end;
        xlabel(xl,'tag','xlab');
        if spl.plotdims>1
            if length(spl.nummode)>1|spl.factors(1)> b,
                yl=['PC',int2str(spl.factors(2))];
            else
                yl=['PC',int2str(spl.factors(2)),':',num2str(mo.model.xev(spl.nummode,spl.factors(2))),'%'];
            end;
            ylabel(yl,'tag','ylab');
            if spl.plotdims>2,
                if length(spl.nummode)>1|spl.factors(1)> b,
                    zl=['PC',int2str(spl.factors(3))];
                else
                    zl=['PC',int2str(spl.factors(3)),':',num2str(mo.model.xev(spl.nummode,spl.factors(3))),'%'];
                end;
                zlabel(zl,'tag','zlab');
            end;
        end;
        if length(spl.nummode)<2,
            X=getappdata(mainfig,'X');
            lab=X{1}.modenames;
            if strcmp(lab{spl.nummode}(1:3),'Mod'),
                titre=[lab{spl.nummode}];
            else 
                titre=['Mode ',int2str(spl.nummode),': ',lab{spl.nummode}];
            end;
        else,
            titre=['Modes ',int2str(spl.nummode(1)),'x',int2str(spl.nummode(2))];
        end;
        title(titre);
        hold off;
        set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
        if spl.additional.potential.exist==1 & spl.plotdims==2,  %potential functions
            axi=axis;
            hold on;
            try
                potentiel('gra',spl,A,axi);
            catch
                uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
            end;
        end;
         if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
            hold on;
            try
                hotel('gra',spl,A);
            catch
                uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
            end;
        end;
        set(findobj('tag','plo'),'visible',spl.visible);
        set(findobj('tag','plo2'),'visible',spl.visible);
        set(findobj('tag','proj'),'linestyle','none');
       %  set(findobj('tag','proj'),'color','b');
        set(findobj('tag','proj'),'marker','*');
       set(findobj('tag','proj'),'MarkerSize',20);
 
    case 'xmo',
        [sel,ok]=listdlg('liststring',mi.samlabs.labels,...
            'name',['Modelisation'],...
            'selectionmode','single',...
            'promptstring',['Choose between ',mi.samlabs.name]);
        if ok==1,
            Xm=nmodel(mo.model.xfactors,mo.model.core);
            Xm=squeeze(Xm(sel,:,:));
            surf(Xm);
            xlabel(c{1}.modenames{2});
            ylabel(c{1}.modenames{1});
            title(['Modelisation for ',mi.samlabs.labels{sel}]);
        end;
        
    case 'res',
        [sel,ok]=listdlg('liststring',mi.samlabs.labels,...
            'name',['Residuals'],...
            'selectionmode','single',...
            'promptstring',['Choose between ',mi.samlabs.name]);
        if ok==1,
            Xm=nmodel(mo.model.xfactors,mo.model.core);
            E=X-Xm;
            E=squeeze(E(sel,:,:));
            surf(E);
            xlabel(c{1}.modenames{2});
            ylabel(c{1}.modenames{1});
            title(['Residuals for ',mi.samlabs.labels{sel}]);
        end;
    case 'bplot',
        G=mo.model.core;
        ssg=sum(G(:).^2);
        G2=G.^2*100/ssg;
        [U ind]=sort(G2(:)');
        V=G(:);
        V=V(ind);
        G2lig=fliplr(U);
        V=fliplr(V);
        ind=fliplr(ind);
        ngmax=min(15,length(U));
        G2ligrac=G2lig(1:ngmax);
        V=V(1:ngmax);
        %semilogy(G2ligrac,'r');
        xlabel('Explained variance (%)');
        hold on;
        barh(G2ligrac);
%         abc=['(',',','()','()'];
%         %set(gca,'xtickslabels',str2mat(abc));
        if N==3
            titre=['Classification of triplets '];
            title(titre);   
        else
            titre=['Classification of ',int2str(N),'-uplets '];
            title(titre);   
        end;
        for i=1:ngmax,
            index{i}=int2str(decomp1(ind(i),size(mo.model.core)));     
        end;
        set(gca,'ydir','reverse');
        set(gca,'ytick',1:ngmax);
        set(gca,'yticklabel',index);
        grid on;

    case 'hotel',
        lab=get(gcbo,'label');
        i=eval(lab(6:end));
        if i==1 & ~isempty(mo.prediction.stats.hotelling) & iscell(mo.prediction.stats.hotelling)
            a=size(mo.model.stats.hotelling{i},1);
            b=size(mo.prediction.stats.hotelling{i},1);
            bar([mo.model.stats.hotelling{i}; mo.prediction.stats.hotelling{1}]);
            hold on;
            bar([a+1:a+b], mo.prediction.stats.hotelling{1},'r');
            hold off;
        else
            bar([mo.model.stats.hotelling{i}]);
        end;
        X=getappdata(mainfig,'X');
        lab=X{1}.modenames;
        ylabel('T2 Hotelling statistic');
        xlabel('Modalities');
        if strcmp(lab{i}(1:3),'Mod'),
            title(lab{i});
        else 
            title(['Mode ',int2str(i),': ',lab{i}]);
        end;    
    case 'qual',
        lab=get(gcbo,'label');
        i=eval(lab(6:end));
        if i==1 & ~isempty(mo.prediction.stats.expvar) & iscell(mo.prediction.stats.expvar)
            a=size(mo.model.stats.expvar{i},1);
            b=size(mo.prediction.stats.expvar{i},1);
            bar([mo.model.stats.expvar{i}*100; mo.prediction.stats.expvar{1}*100]);
            hold on;
            bar([a+1:a+b], mo.prediction.stats.expvar{1}*100,'r');
            hold off;
        else
            bar([mo.model.stats.expvar{i}*100]);
        end;
        X=getappdata(mainfig,'X');
        lab=X{1}.modenames;
        ylabel('Exp. Var. (%)');
        xlabel('Modalities');
        if strcmp(lab{i}(1:3),'Mod'),
            title(lab{i});
        else 
            title(['Mode ',int2str(i),': ',lab{i}]);
        end;
    case 'sse',
        lab=get(gcbo,'label');
        i=eval(lab(6:end));
        if i==1 & ~isempty(mo.prediction.stats.quality) & iscell(mo.prediction.stats.quality)
            a=size(mo.model.stats.quality{i},1);
            b=size(mo.prediction.stats.quality{i},1);
            bar([mo.model.stats.quality{i}; mo.prediction.stats.quality{1}]);
            hold on;
            bar([a+1:a+b], mo.prediction.stats.quality{1},'r');
            hold off;
        else
            bar([mo.model.stats.quality{i}]);
        end;
        X=getappdata(mainfig,'X');
        lab=X{1}.modenames;
        ylabel('RSS');
        xlabel('Modalities');
        if strcmp(lab{i}(1:3),'Mod'),
            title([lab{i},'. RSS .']);
        else 
            title(['Mode ',int2str(i),': ',lab{i}]);
        end;
    case 'exv' % Explained variance
        tai=size(mo.model.core,1);
        N=length(mo.model.xfactors');
        delete(findobj('tag','cbaxes'));
        if N==3 & tai<5,         
            switch tai,
            case 1,
                ty=1;
            case 2,
                ty=2;
            case {3,4}
                ty=4;
            case {5,6}
                ty=6;         
            end;
            for i=1:tai,
                hhh=axes('parent',1,'tag','cbaxes','nextplot','replacechildren','view',[-37.5 30],'position',sizeaxes{ty}(i,:));
                bar3(squeeze(mo.model.core(i,:,:)));
                title(['Slab ',int2str(i)]);
                xlabel('Mode 3');
                ylabel('Mode 2');
            end;
        elseif ~isequal(N,3),
            uiwait(warndlg({'No plot available.','The number of way of the core has to be more large than 3.',['Here, N=',int2str(N)]}));
        else
            uiwait(warndlg({'No plot available (size of the core is too large).','Its first dimension has to be inferior or equal to 6',['Here size of the core is ',int2str(size(mo.model.core))]}));
        end;
    end;  %switch type
    hold off;
end;  %graphiques
