function ModelIn = tuckeroptions(ModelIn)
wic=[0.5029 0.5814 0.6402];
lbc=[0.9 0.93 0.95];
frc=[0.3529 0.4314 0.4902];
h0 = figure('MenuBar','none', ...
   'Name','Tucker options', ...
   'MenuBar','none', ...
   'NumberTitle','off', ...
   'resize','off',...
   'Position',[500 350 280 280], ...
   'color',wic,...
   'Tag','tuckeroptions',...
   'toolbar','none');
h1=uicontrol('parent', h0,...   % frame initialisation
   'backgroundcolor',frc,...
   'position',[20 20 120 120],...
   'style','frame');
h2=uicontrol('parent', h0,...
   'backgroundcolor',frc,...
   'string','Initialisation:',...
   'position',[25 105 110 20],...
   'tooltipstring','',...
   'style','text');
a1=uicontrol('parent', h0,...
   'backgroundcolor',frc,...
   'string','SVD',...
   'tag','ini',...
   'callback','evalin(''caller'',''u=findobj(''''tag'''',''''ini'''');set(u,''''value'''',0);set(gcbo,''''value'''',1);ModelIn.options.algorithm.constants=1;'');',...
   'position',[25 85 110 20],...
   'tooltipstring','',...
   'style','radiobutton');
a2=uicontrol('parent', h0,...
   'backgroundcolor',frc,...
   'string','DTLD-Gram',...
   'tag','ini',...
   'tooltipstring',[''],...
   'callback','evalin(''caller'',''u=findobj(''''tag'''',''''ini'''');set(u,''''value'''',0);set(gcbo,''''value'''',1);ModelIn.options.algorithm.constants=0;'');',...
   'position',[25 65 110 20],...
   'style','radiobutton');
a3=uicontrol('parent', h0,...
   'backgroundcolor',frc,...
   'tooltipstring',[''],...
   'tag','ini',...
   'callback','evalin(''caller'',''u=findobj(''''tag'''',''''ini'''');set(u,''''value'''',0);set(gcbo,''''value'''',1);ModelIn.options.algorithm.constants=2;'');',...
   'string','Orthorand',...
   'position',[25 45 110 20],...
   'style','radiobutton');
a4=uicontrol('parent', h0,...
   'backgroundcolor',frc,...
   'tag','ini',...
   'tooltipstring',['Best initialisation between the three upper.'],...
   'callback','evalin(''caller'',''u=findobj(''''tag'''',''''ini'''');set(u,''''value'''',0);set(gcbo,''''value'''',1);ModelIn.options.algorithm.constants=10;'');',...
   'string','Bestfit',...
   'position',[25 25 110 20],...
   'style','radiobutton');
switch ModelIn.options.algorithm.constants
case 0, set(a2,'value',1);
case 1, set(a1,'value',1);   
case 2, set(a3,'value',1);   
case 10, set(a4,'value',1);
end;

h1=uicontrol('parent', h0,...   % frame Max iter
   'backgroundcolor',frc,...
   'position',[20 190 155 50],...
   'style','frame');

h1=uicontrol('parent', h0,...     %maxiter text
   'string','Maximal iteration:',...
   'fontweight','normal',...
   'backgroundcolor',frc,...
   'fontsize',12,...
   'position',[22 215 150 20],...
   'tooltipstring','',...
   'style','text');
h1=uicontrol('parent', h0,...     %maxiter
   'string',int2str(ModelIn.options.algorithm.maxiter),...
   'callback','evalin(''caller'',''ModelIn.options.algorithm.maxiter=eval([''''['''',get(gcbo,''''string''''),'''']'''']);'');',...
   'fontweight','normal',...
   'fontsize',12,...
   'backgroundcolor',lbc,...
   'tag','npc',...
   'position',[40 195 90 20],...
   'tooltipstring','',...
   'style','edit');

h1=uicontrol('parent', h0,...     %OK
   'string','OK',...
   'callback','close(gcf)',...
   'fontweight','normal',...
   'fontsize',12,...
   'tag','npc',...
   'backgroundcolor',[0.7 0.7 0.7],...
   'position',[145 20 130 30],...
   'tooltipstring','',...
   'style','pushbutton');

h1=uicontrol('parent', h0,...   % frame convergence criterion
   'backgroundcolor',frc,...
   'position',[145 100 130 70],...
   'style','frame');

h1=uicontrol('parent', h0,...     %cc text
   'string',{'Convergence','criterion:'},...
   'fontweight','normal',...
   'backgroundcolor',frc,...
   'fontsize',12,...
   'position',[147 125 125 40],...
   'tooltipstring','',...
   'style','text');
h1=uicontrol('parent', h0,...     %cc
   'string',num2str(ModelIn.options.algorithm.value),...
   'callback','evalin(''caller'',''ModelIn.options.algorithm.value=eval([''''['''',get(gcbo,''''string''''),'''']'''']);'');',...
   'fontweight','normal',...
   'fontsize',12,...
   'backgroundcolor',lbc,...
   'tag','npc',...
   'position',[153 105 90 20],...
   'tooltipstring','',...
   'style','edit');
