function TuckerDisplayInfo(mainfig,mi,mo)

GuiNames
%mainfig=findobj('type','figure','userdata','Cubatch');

%X = mo.data.dataset;
X=getappdata(mainfig,'X');
N=ndims(X{1});

delete(findobj(tg,'textfig'))
if ~isa(X,'cell')
   X = {X};
end
DisplayInfo(mainfig,X);
fnor = {'fontunits','normalized'};
vert = {'verticalalignment','cap'};
a    = findobj(tg,'textfig');
apos = get(a,'extent');
if isa(apos,'cell')
   apos = min(cat(1,apos{:}));
end
 if strcmp(mi.options.species,'met'), % def de valou (validation 1/model 0)
     valou=0;
 elseif strcmp(mi.options.species,'val'),
     valou=1;
 end;
if valou==1,
   b     = text(.5,apos(2) - 0.05,'\bf\fontsize{12}Validation: Tucker',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
else
   b     = text(.5,apos(2) - 0.05,'\bf\fontsize{12}Model: Tucker',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
end;
bpos  = get(b,'extent');
S2aa   = {'\fontsize{10}Method'};
S2a   = {'\fontsize{10}Algorithm';'N. of factors';'Expl. Var.';'Centering';'Scaling';'Conv. Crit.';'Iterations';'Initialisation';'Rotation'};
U2a   = {'Bootstrap'};
Alg =[mi.options.algorithm.name];

if length(mo.model) ~= 1
   NbFacStr = sprintf('%i - %i',mo.model(1).nbfactors,mo.model(end).nbfactors);
   EVStr    = [];
else
    NbFacStr = int2str(mi.nbfactors.min);
    if strcmp(mi.valmethod.name,'none')
        nm=sum(mo.model.xev(1,:));
         EVStr    = [sprintf('%0.5g',nm),'%'];     % global explained variation
     else
         EVStr='';
    end; 
end
switch mi.options.algorithm.constants,
case 1, ini='SVD';
case 0, ini='DTLD-GRAM';
case 2, ini='Random';
case 10,ini='Best fit';
otherwise, ini='??';    
end;
switch mi.options.rotate,
case 0,namerot='none.';
case 1,namerot='Diagonale.';
case 2,namerot='SW Diagonale.';
case 3,namerot='Variance Max.';
otherwise namerot='??';
end;
ce=[mi.sam(1).cen(1),mi.var(1).cen];
sc=[mi.sam(1).scal(1),mi.var(1).scal];
if ~isempty(ce)
   PreTrStrA = [ce(:)];
else
   PreTrStrA=0;
end
if ~isempty(sc)
   PreTrStrB = [sc(:)];
else
   PreTrStrB=0;
end

Convcrit=mi.options.algorithm.value;
iter=mo.model.iterations;
Maxiter=mi.options.algorithm.maxiter;
if mi.valmethod.bootstrap==1,
   sorboo=['Naive (',int2str(mi.valmethod.replicates),')'];
elseif mi.valmethod.bootstrap==2,
   sorboo=['Residual (',int2str(mi.valmethod.replicates),')'];
end;
if valou==1,
    switch mi.valmethod.name
        case 'nboo',
            valname=['Naive bootstrap (',int2str(mi.valmethod.replicates),')'];
        case 'rboo',
            valname=['Residual bootstrap (',int2str(mi.valmethod.replicates),')'];
        case 'cv',
            valname=['Cross-Validation'];
    end;
else
    valname='none';
end;
S2bb = { [': ',valname]}; 

S2b = { [': ',Alg];...
      [': [',NbFacStr,']'];...
      [': ',EVStr];...
      [': [ ',sprintf('%i ',PreTrStrA),']'];...
      [': [ ',sprintf('%i ',PreTrStrB),']'];...
      [': ',num2str(Convcrit)];...
      [': ',int2str(iter),'/',int2str(Maxiter)];...
      [': ',ini];...
      [': ',namerot]};

if mi.valmethod.bootstrap>0,
    U2b = { [': ',sorboo]};
   S2a = [S2a(:);U2a(:)];
   S2b = [S2b(:);U2b(:)];
end;
if valou==1,
   S2a = [S2aa(:);S2a(:)];
   S2b = [S2bb(:);S2b(:)];
end;

text(.05,bpos(2)-0.02,S2a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
c    = text(.5,bpos(2)-0.02,S2b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
cpos = get(c,'extent');S30 = [];

S3 = [];

if ~isempty(S30)
   d     = text(.5,cpos(2) - 0.05,['\bf\fontsize{12}',S30],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
   dpos  = get(d,'extent');
   text(.05,dpos(2)-0.02,S3a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
   e = text(.5,dpos(2)-0.02,S3b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
end
if ~isempty(mo.prediction.data)
    displayinfoproj(mainfig,mo,cpos);
end;

set(findobj(gcf,tg,'textfig'),'clipping','on');


