function [ModelIn,ModelOut]=tuckerb(ModelIn);
%
guinames;
mainfig=findobj('type','figure','userdata','Cubatch');
wic=[0.5029 0.5814 0.6402];
lbc=[0.9 0.93 0.95];
frc=[0.3529 0.4314 0.4902];
X=getappdata(mainfig,'X');
N=length(X{1}.dims);
ModelIn.data.sizes=X{1}.dims;
clear X;
h=findobj('tag','tucker');
if isempty(h), % tucker window building
    [ModelIn]=check(ModelIn);
    h0 = figure('MenuBar','none', ...
        'Name','Tucker', ...
        'NumberTitle','off', ...
        'Position',[400 300 360 280], ...
        'userdata','window',...
        'busyaction','cancel',...
        'resize','off',...
        'color',wic,...
        'Tag','tucker',...
        'toolbar','none');
    h1 = uimenu('Parent',h0, ...
        'Label','&Preferences', ...
        'Tag','pref');
    ModelIn.options.algorithm.name='ALS';
    ModelIn.options.algorithm.maxiter=300;
    ModelIn.options.algorithm.constants=1;
    ModelIn.options.algorithm.value=1e-10;
    h2 = uimenu('Parent',h1, ...  % 
        'Label','&Constraints', ...
        'callback','evalin(''caller'',''ModelIn = tuckerconstraints(ModelIn);'');',...
        'Tag','const');
    h2 = uimenu('Parent',h1, ...
        'separator','off',...
        'callback','evalin(''caller'',''ModelIn = tuckeroptions(ModelIn);'');',...
        'Label','&Tucker options');
    h2 = uimenu('Parent',h1, ...
        'separator','on',...
        'Label','&Bootstrap options');
    h3 = uimenu('Parent',h2, ...
        'Label','Bootstrap model');
    h4 = uimenu('Parent',h3, ...
        'Callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=1;'');set(gcbo,''checked'',''on'');set(findobj(''tag'',''rb''),''checked'',''off'');', ...
        'tag','nb',...
        'Label','Naive bootstrap');
    h4 = uimenu('Parent',h3, ...
        'Callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=2;'');set(gcbo,''checked'',''on'');set(findobj(''tag'',''nb''),''checked'',''off'');', ...
        'tag','rb',...
        'Label','Residual bootstrap');
    if isempty(ModelIn.valmethod.bootstrap),
        ModelIn.valmethod.bootstrap=0;
    end;
    if ModelIn.valmethod.bootstrap<2,
        set(findobj('tag','nb'),'checked','on');
        set(findobj('tag','rb'),'checked','off');
    elseif isequal(ModelIn.valmethod.bootstrap,2),
        set(findobj('tag','rb'),'checked','on');
        set(findobj('tag','nb'),'checked','off');
    end;
    if isempty(ModelIn.valmethod.replicates),
        ModelIn.valmethod.replicates=5; %default values
    end;
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''fnbboot(ModelIn.valmethod.replicates);'');',...
        'Label','Bootstrap replications');
    h1 = uimenu('Parent',h0, ...
        'Callback','', ...
        'Label','&Help', ...
        'Tag','help');
    ModelIn.valmethod.name='none';
    h1=uicontrol('parent', h0,...      % Frame validation
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',frc,...
        'tooltipstring','Validation window',...
        'position',[10 10 160 130],...
        'style','frame');
    h1=uicontrol('parent', h0,...      % validate
        'string','Validation',...
        'fontsize',12,...
        'callback','if get(gcbo,''value'')==1,set([findobj(''tag'',''booval1''),findobj(''tag'',''booval2'')],''enable'',''on'');set(findobj(''tag'',''bootucker''),''enable'',''off'');if get(findobj(''tag'',''booval2''),''value'')==1,evalin(''caller'',''ModelIn.valmethod.name=''''rboo'''';'');else evalin(''caller'',''ModelIn.valmethod.name=''''nboo'''';'');end;else set([findobj(''tag'',''booval1''),findobj(''tag'',''booval2'')],''enable'',''off'');set(findobj(''tag'',''bootucker''),''enable'',''on'');evalin(''caller'',''ModelIn.valmethod.name=''''none'''';'');end;',...
        'backgroundcolor',frc,...
        'position',[20 110 130 20],...
        'tag','validate',...
        'tooltipstring','Check only if You want to do a validation of tucker.',...  
        'style','checkbox');
    h1=uicontrol('parent', h0,...      % bootstrap validation:naive
        'string','Naive bootstrap',...
        'fontsize',12,...
        'callback','if get(gcbo,''value'')==1,evalin(''caller'',''ModelIn.valmethod.name=''''nboo'''';'');set(findobj(''tag'',''booval2''),''value'',0);else evalin(''caller'',''ModelIn.valmethod.name=''''rboo'''';'');set(findobj(''tag'',''booval2''),''value'',1);end;',...
        'tag','booval1',...
        'value',1,...
        'backgroundcolor',frc,...
        'enable','off',...
        'position',[35 90 130 20],...
        'tooltipstring','Resample the rows of X.',...  
        'style','radiobutton');
    h1=uicontrol('parent', h0,...      % bootstrap validation:residual
        'string','Residual bootstrap',...
        'fontsize',12,...
        'callback','if get(gcbo,''value'')==1,evalin(''caller'',''ModelIn.valmethod.name=''''rboo'''';'');set(findobj(''tag'',''booval1''),''value'',0);else evalin(''caller'',''ModelIn.valmethod.name=''''nboo'''';'');set(findobj(''tag'',''booval1''),''value'',1);end;',...
        'tag','booval2',...
        'backgroundcolor',frc,...
        'enable','off',...
        'position',[35 70 134 20],...
        'tooltipstring','Resample the rows of the residuals of tucker(X).',...  
        'style','radiobutton');
    h1=uicontrol('parent', h0,...   %num factors text
        'string', 'Num. factors',...
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',wic,...
        'position',[0 235 80 20],...
        'style','text');
    if isempty(ModelIn.nbfactors.min)|~isequal(length(ModelIn.nbfactors.min),N),
        ModelIn.nbfactors.min=3*ones(1,N);
    end;
    h1=uicontrol('parent', h0,...     %nbPC
        'string',int2str(ModelIn.nbfactors.min),...
        'callback','evalin(''caller'',''ModelIn.nbfactors.min=eval([''''['''',get(gcbo,''''string''''),'''']'''']);'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','npc',...
        'position',[90 235 70 20],...
        'tooltipstring','N integers separated by spaces or ",".',...
        'style','edit');
    h1=uicontrol('parent', h0,...      %close button
        'string','Close',...
        'callback','delete(findobj(''userdata'',''window''));',...
        'fontsize',12,...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 10 130 30],...
        'tooltipstring','close "Tucker" window',...  
        'style','pushbutton');
    h1=uicontrol('parent', h0,...   %  Tucker
        'tag','OKtucker',...
        'string','OK',...
        'fontsize',12,...
        'callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=0;[ModelIn,ModelOut]=tuckerb(ModelIn);'')',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 60 130 30],...
        'tooltipstring','Normal tucker',...  
        'style','pushbutton');
    h1=uicontrol('parent', h0,...   %  bootstrap Tucker
        'tag','sta',...
        'string','Bootstrap',...
        'fontsize',12,...
        'tag','bootucker',...
        'callback','evalin(''caller'',''if ModelIn.valmethod.bootstrap==0, ModelIn.valmethod.bootstrap=1;end;[ModelIn,ModelOut]=tuckerb(ModelIn);'')',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 95 130 30],...
        'tooltipstring','Convex hulls,etc...',...   
        'style','pushbutton');
    h1=uicontrol('parent', h0,...      %frame process
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',frc,...
        'position',[190 140 160 130],...
        'tooltipstring','Processing window',...
        'style','frame');
    h1=uicontrol('parent', h0,...   %  preprocessing window
        'tag','prep',...
        'string','Preprocessing',...
        'fontsize',12,...
        'callback','evalin(''caller'',''ModelIn=PreProcess(ModelIn,0);'');',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 230 130 30],...
        'tooltipstring','',...  
        'style','pushbutton');
    h1=uicontrol('parent', h0,...   %  postprocessing window
        'tag','postp',...
        'string','Postprocessing',...
        'fontsize',12,...
        'callback','evalin(''caller'',''postproc(ModelIn);'');',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 190 130 30],...
        'tooltipstring','Rotation of the core',...  
        'style','pushbutton');
else,
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % tuckerb                                            %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [ModelOut,PlotStr] = DefineModelOut;
    X=getappdata(mainfig,'X');
    R=X{1}.dims;
    X=X{1}.data;
    
    N=ndims(X);
    if sum([ModelIn.sam(1).cen(1),ModelIn.var.cen,ModelIn.sam(1).scal(1),ModelIn.var.scal])>0,
        try
            [X,ModelOut.model(1).xpreproc.cen,ModelOut.model(1).xpreproc.scal]=nprocess(X,[ModelIn.sam(1).cen(1),ModelIn.var.cen],[ModelIn.sam(1).scal(1),ModelIn.var.scal]);
        catch
            uiwait(errordlg({'Error in the preprocessing part.',lasterr}));
        end;
    end;
    if get(findobj('tag','validate'),'value')==1,
        if strcmp(ModelIn.valmethod.name,'nboo'),
            if N>3,
                uiwait(errordlg({'Sorry.You can''t do this (for the moment...)','since the order of your data is more than 3.'}));
                return;
            end;
            ModelIn.options.species='val';
            ModelOut.validation.stats.risk= ...
                bootcomptucker(X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'),'n');      
        elseif strcmp(ModelIn.valmethod.name,'rboo'),
            if N>3,
                uiwait(errordlg({'Sorry.You can''t do this (for the moment...)','since the order of your data is more than 3.'}));
                return;
            end;
            ModelIn.options.species='val';
            ModelOut.validation.stats.risk=bootcomptucker(X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'),'r');
        end;
    else
        ModelIn.options.species='met';
        constrf=zeros(1,N);
        for i=1:N,
            if ModelIn.constraints(4).modes(i)==1,% orthogonality is for tucker non orthogonaluty (none)
                constrf(i)=2;
            elseif ModelIn.constraints(3).modes(i)==1,
                constrf(i)=1;
            elseif ModelIn.constraints(6).modes(i)==1,
                constrf(i)=4;
            else
                constrf(i)=0;
            end;
        end;
        eps=ModelIn.options.algorithm.value;
        ini=ModelIn.options.algorithm.constants;  
        % 0 dtl, 1 svd, 2 rand, 10 choice
        maxit=ModelIn.options.algorithm.maxiter;
        try 
            % Cu_FIX_2011
            % orig: [Factors,G,gv,Xm,it]=tucker(X,ModelIn.nbfactors.min,[eps ini 0 0 10 maxit],constrf);
            it = 99;
            
            [Factors,G,gv,Xm]=tucker(X,ModelIn.nbfactors.min,[eps ini 0 0 10 maxit],constrf);
            ModelOut.model.xpred=nmodel(Factors,G);
        catch
            uiwait(errordlg(lasterr));
            return;
        end;
        ssx=misssum(X(:).^2);
        if (ModelIn.options.rotate>0) & ~isequal(N,3),
            uiwait(warndlg({'No rotation core will be done:','data have to be 3-way.'}));
            ModelIn.options.algorithm.rotate=0;
        elseif N==3,
            eee=1;
            try
                switch ModelIn.options.rotate,
                    case 1,
                        if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))&isequal(ModelIn.nbfactors.min(3),ModelIn.nbfactors.min(2)),
                            [G,Oy{1},Oy{2},Oy{3}]=maxdia3(G);
                        else
                            uiwait(warndlg({'No rotation core will be done:','the core has to be perfectly cubic,W(1)=W(2)=W(3).'}));
                            ModelIn.options.algorithm.rotate=0;
                        end;
                    case 3,
                        [G,Oy{1},Oy{2},Oy{3}]=maxvar3(G);
                    case 2,
                        if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))
                            [G,Oy{1},Oy{2},Oy{3}]=maxswd3(G);
                        else,
                            uiwait(warndlg({'No rotation core will be done:','the core has to be so:W(1)=W(2).'}));
                            ModelIn.options.algorithm.rotate=0;
                        end;
                end;
            catch
                uiwait(errordlg({'Error in the rotation core step.',lasterr}));
                return;
            end;
        end;
        
        if ModelIn.options.rotate>0,
            for i=1:N,
                Factors{i}=Factors{i}*Oy{i};
            end;
        end;
        
        
        
        %  attribution des coef pour que ce soit une projection
        try
            [Faco,loadi]=tuckerweight(Factors,G);
        catch
            Faco='impossible';
        end;
        
        
        
        % calcul des coefficients de qualits
        [qual,expv,hotel]=qualitecube(X,Xm,Faco);
        ModelOut.model.stats.quality=qual;
        ModelOut.model.stats.expvar=expv;
        ModelOut.model.stats.hotelling=hotel;
        
        
        
        if ModelIn.valmethod.bootstrap>0,  %bootstrap
            set(findobj('tag','plotd3'),'enable','off');
            nbboot=ModelIn.valmethod.replicates;
            [Factors,G]=tucker(X,ModelIn.nbfactors.min);
            Xmod=nmodel(Factors,G);
            if ModelIn.valmethod.bootstrap==1,   % naive bootstrap
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                % Bootstrap avec Reechantillonnage sur les lignes des Donnes  %
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                [Abootstrap, bootsam]=bootstrpanadon(nbboot,2,'naiftucker',X,ModelIn.nbfactors.min,ModelIn.options.rotate);
            elseif ModelIn.valmethod.bootstrap==2,  % residual bootstrap
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                % Bootstrap avec Reechantillonnage sur les lignes des Residus  %
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                E=X-Xmod;
                [Abootstrap, bootsam]=bootstrpanadon(nbboot,2,'residueltucker',E,G,Factors,ModelIn.options.rotate);
            end;
            
            
            %changement ventuel du signe des PC bootstraps
            for i=1:nbboot,
                Ab=Abootstrap{1}{1}(:,:,i);
                Bb=Abootstrap{1}{2}(:,:,i);
                Cb=Abootstrap{1}{3}(:,:,i);
                % whos Ab,whos Bb,whos Cb
                signprodscalA=diag(sign(diag(Ab'*Factors{1})));
                signprodscalB=diag(sign(diag(Bb'*Factors{2})));
                signprodscalC=diag(sign(diag(Cb'*Factors{3})));
                Ab=Ab*signprodscalA;
                Bb=Bb*signprodscalB;
                Cb=Cb*signprodscalC;
                Abootstrap{1}{1}(:,:,i)=Ab;
                Abootstrap{1}{2}(:,:,i)=Bb;
                Abootstrap{1}{3}(:,:,i)=Cb;
                % postprocessing:   attribution des coef pour que ce soit une projection
                try
                    aF={Abootstrap{1}{1}(:,:,i),Abootstrap{1}{2}(:,:,i),Abootstrap{1}{3}(:,:,i)};
                    aG=Abootstrap{2}(:,:,:,i);
                    aaF=tuckerweight(aF,aG);
                    Abootstrapn{1}{1}(:,:,i)=aaF{1};
                    Abootstrapn{1}{2}(:,:,i)=aaF{2};
                    Abootstrapn{1}{3}(:,:,i)=aaF{3};
                catch
                    lasterr
                    %{Abootstrapn{1}{1}(:,:,i),Abootstrapn{1}{2}(:,:,i),Abootstrapn{1}{3}(:,:,i)}='impossible';
                end;
            end;
            
            
            
            %  Calculus of the standard deviation (for the modes 2 to N).
            for n=1:N,
                stad{n}=std(Abootstrap{1}{n},0,3);  %unbiased estimation
            end;
            if isequal(ModelIn.valmethod.bootstrap,1), %naive bootstrap
                m(1:10*max(R)*nbboot)=0;
                AAA=cell(1,R(1));
                for n=1:nbboot,
                    u=bootsam(:,n);
                    for i=1:R(1),
                        m(u(i))=m(u(i))+1;
                        AAA{u(i)}(:,m(u(i)))=Abootstrap{1}{1}(i,:,n);
                    end;
                end;
                for i=1:R(1),
                    if ~isequal(size(AAA{i}),[0 0]),
                        stad{1}(i,:)=std(AAA{i},0,2);
                    end;
                end;
            end;
            
            %  Calcul du risque
            BC=kron(Factors{2},Factors{3});
            WW=BC*BC';
            somtrace=0;
            for b=1:nbboot,
                Bb=Abootstrap{1}{2}(:,:,b);
                Cb=Abootstrap{1}{3}(:,:,b);
                BCb=kron(Bb,Cb);
                Wb=BCb*BCb';
                traceb=trace(Wb*WW);
                somtrace=somtrace+traceb;
            end;
            risqueBC=ModelIn.nbfactors.min(2)*ModelIn.nbfactors.min(3)-(1/nbboot)*somtrace; 
            
            
            %outputs
            for i=1:N,
                ModelOut.validation.xfactors{i}=Abootstrap{1}{i};
                ModelOut.validation.yfactors{i}=Abootstrapn{1}{i};
            end;
            ModelOut.validation.core=Abootstrap{2};
            ModelOut.validation.segments=bootsam;
            ModelOut.validation.stats.std=stad;
            ModelOut.validation.stats.risk=risqueBC;            
        end;  %end bootstrap
        close(gcf);
        if ~isempty(G),
            Wg=size(G);
            Ng=length(Wg);
            if isequal(size(G),[1 1]),
                ModelOut.model.xev=gv;
            else,
                gev=zeros(N,max(ModelIn.nbfactors.min));
                for i=1:Ng,
                    Gf=nshape(G,i);
                    for g=1:Wg(i),
                        gev(i,g)=sum(Gf(g,:).^2)*100/ssx;
                    end;
                end;
                Gf=G(:)';
                for i=Ng+1:N,
                    gev(i,1)=sum(Gf(1,:).^2)*100/ssx;
                end;       
                ModelOut.model.xev=gev;
            end;
        end;
        % ModelOut implementation
        ModelOut.model.xfactors=Factors;
        ModelOut.model.yfactors=Faco;
        ModelOut.model.nbfactors=ModelIn.nbfactors;
        ModelOut.model.core=G;
        ModelOut.model.iterations=it;
        ModelOut.model.xpred=Xm;
        ModelOut.modelname='Tucker';
        ModelOut.prediction.xcumpress=loadi;
        
        % default plot installation
        defaultplot(ModelIn,ModelOut);
        
    end;%tucker model (opposite to validation)   
    ModelOut.modelname='Tucker';
    tuckerdisplayInfo(mainfig,ModelIn,ModelOut);
end;%tucker execution




