function [mi,mo] = tuckerapply(mi,mo,spl);


Guinames;
mainfig=findobj('userdata','Cubatch');
X=getappdata(mainfig,'X');
DimX=X{1}.dims;
N=length(DimX);

%try
if length(mo.model) ~= 1  %
    ListProp = {'selectionmode','single','name','Choose model','promptstring','Select the model to apply'};
    ReqTit   = 'Choose model';
    Cont     = cellstr(num2str(cat(1,mo.model.nbfactors)));
    [RankPos,Ok] = listdlg('Liststring',Cont,ListProp{:});
    if ~Ok
        return
    end
end
ListProp          = {'selectionmode','single','name','Load array','promptstring','Select the array to load'};
ReqTit            = 'Load data';
[Xt,Yt,Xfil,Yfil] = deal({});
try % modification CD
    cd data
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);   % chargement des donnes
    cd ..
catch
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);   % chargement des donnes
end;
RankPos           = 1;
if Xfil{1} ~= 0
    Cont = who('-file',[Xfil{:}]);
    Ok   = 1;
    Sel  = 1;
    if length(Cont) > 1
        [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
    end
    if Ok,
        Xt   = load([Xfil{:}],Cont{Sel});
        Xt   = getfield(Xt,Cont{Sel});
        if ~isempty(Xt),
            if iscell(Xt)
                if ~isa(Xt{1},'cbdataset'),
                    return;
                else
                    Xn=Xt{1};
                end;
            else 
                if isa(Xt,'cbdataset'),
                    Xn=Xt;
                else
                    Xn=cbdataset(Xt);
                end;
            end;
            if length(Xn.dims) ~= length(mo.model(RankPos).xfactors) & length(Xn.dims) ~= length(mo.model(RankPos).xfactors)-1
                uiwait(errordlg({'1The current model cannot be applied to this data set:','the dimensions are not compatible'}));
                return
            else 
                Nn=length(Xn.dims);
                %--------MODIFICATION BY CD - 29 08 02
                DimM = X{1}.dims;
                Np=length(DimM);
                if Xn.dims(3:end) ~= DimM(3:end) ,%& ~(Np==Nx-1 & DimX(2:end) == DimM),
                    %if assouplissement de la contrainte  faire 
                    uiwait(errordlg({'2The current model cannot be applied to this data set:','the dimensions are not compatible'}))
                    return
                end
            end
        else %  empty
            return
        end
    else 
        return
    end
else
    return
end
mo=getappdata(mainfig,'Results');
if isempty(mo.prediction.data),
    mo.prediction.data = Xn;
    Rpold=0;
else 
    Rpold=mo.prediction.data.dims;
    try
        mo.prediction.data=cat(1,mo.prediction.data,Xn);
    catch
        uiwait(errordlg({'Dimensions not compatible with precedings data.','Clear projected data before.'}));
        return;
    end;
end;

% calculate the model
Rp=mo.prediction.data.dims;
Np=length(Rp);
dd=mo.prediction.data.data;
dif=N-Np;
if sum([mi.sam(1).cen(1),mi.var(1).cen,mi.sam(1).scal(1),mi.var(1).scal])>0,
    try
        [dd]=nprocess(dd,[mi.sam(1).cen(1),mi.var(1).cen],[mi.sam(1).scal(1),mi.var(1).scal],mo.model.xpreproc.cen,mo.model.xpreproc.scal,1);
    catch
        uiwait(errordlg({'Error in the preprocessing of the projection part.',lasterr}));
    end;
end;

for i=Rpold(1)+1:Rp(1),
    if dif==0,
        ind=repmat({':'},Np,1);
        ind{1}=i;
        spl.additional.typeproj='sm';  %simple mode 
        dta = squeeze(dd(ind{:}));
        fct = mo.model.xfactors(2:end);
        [xpred,fxpred,fxpredw] = tuckerproj('sm',dta,fct);  %sm
        if isempty(mo.prediction.xfactors),
            mo.prediction.xfactors=cell(1,1);
        end;
        if isempty(mo.prediction.yfactors),
            mo.prediction.yfactors=cell(1,1);
        end;
        mo.prediction.xfactors{1}(i,:)=fxpred;
        mo.prediction.yfactors{1}(i,:)=fxpredw;
        mo.prediction.xpred(ind{:})=xpred;
    else    
       
        spl.additional.typeproj='mm';  %mixed mode
         ind=repmat({':'},Np,1);
        ind{1}=i;
         [xpred,fxpred,fxpredw] = tuckerproj('mm',squeeze(dd(ind{:})),mo.model.xfactors(3:end));  %mm
         if isempty(mo.prediction.xfactors),
             mo.prediction.xfactors=cell(1,1);
         end;
         if isempty(mo.prediction.yfactors),
             mo.prediction.yfactors=cell(1,1);
         end;
         mo.prediction.yfactors{1}(i,:)=fxpredw;
    end;
end;

if strcmp(spl.additional.typeproj,'sm'),
    try
        % Estimation de la qualit des nouveaux echantillons
        [qual,expv,hotel]=qualitecubepredic(dd,mo.prediction.xpred,mo.model.xfactors{1},mo.prediction.xfactors{1});
        mo.prediction.stats.quality=qual;
        mo.prediction.stats.expvar=expv;
        mo.prediction.stats.hotelling=hotel; 
    catch
        uiwait(errordlg({'Error in the calculus of quality of projected points',lasterr}));
    end;
else
    mo.prediction.stats.quality={[]};
    mo.prediction.stats.expvar={[]};
    mo.prediction.stats.hotelling={[]};
end;
% Actualize the current plot
defaultplot(mi,mo);



return
