function [Factorsb,Gb] = residueltucker(E,G,Factors);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% residueltucker                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%   E  residuals of a tucker model
%   G  core matrix of tucker model
%   Factors: cell loadings of the tucker model
% OUTPUTS
%   Factorsb: bootstrap loadings of Xb=A*B*C+Eb
%   Gb:new core
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tucker on bootstrap data Xb=A*B*C+Eb              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
N=length(Factors);
mainfig=findobj('type','figure','userdata','Cubatch');
W=zeros(1,N);
for i=1:N,
   [n,W(i)]=size(Factors{i});
end
Xmod=nmodel(Factors,G);
Xb=E+Xmod;
[Factorsb,Gb]=tucker(Xb,W);
g=getappdata(mainfig,'Model');
rot=g.options.rotate;
if (rot>0) & isequal(N,3),  %postprocessing
   switch rot,
   case 1,
      if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))&isequal(ModelIn.nbfactors.min(3),ModelIn.nbfactors.min(2)),
         [Gb,Factorsb{1},Factorsb{2},Factorsb{3}]=maxdia3(Gb);
      end;
   case 3,
      [Gb,Factorsb{1},Factorsb{2},Factorsb{3}]=maxvar3(Gb);
   case 2,
      if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))
         [Gb,Factorsb{1},Factorsb{2},Factorsb{3}]=maxswd3(Gb);
      end;
   end;
end;
 
