function [Factorsb,Gb] = naiftucker(X,W,rot);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% naiftucker                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%   X  unfolded data
%   R  dimension of X (3-vector)
%   W  number of components (3-vector)
% OUTPUTS
%   Ab,Bb,Cb: loadings of Xb bootstrapped from X
%   Gb   core matrix  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tucker on bootstrap data of X  ( naive bootstrap) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[Factorsb,Gb]=tucker(X,W);


if (rot>0) & isequal(N,3),  %postprocessing
   switch rot,
   case 1,
      if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))&isequal(ModelIn.nbfactors.min(3),ModelIn.nbfactors.min(2)),
         [Gb,Factorsb{1},Factorsb{2},Factorsb{3}]=maxdia3(Gb);
      end;
   case 3,
      [Gb,Factorsb{1},Factorsb{2},Factorsb{3}]=maxvar3(Gb);
   case 2,
      if isequal(ModelIn.nbfactors.min(1),ModelIn.nbfactors.min(2))
         [Gb,Factorsb{1},Factorsb{2},Factorsb{3}]=maxswd3(Gb);
      end;
   end;
end;