function [risqueBC]=bootcomptucker(X,mi,mo,c,model);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% bootcomptucker                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%    X  3-way data
%    Wmax2 and Wmax3  maximal tested values fior the
%         parameters of mode 2 and 3.
%    nbboot   number of bootstrap resamplings 
% OUTPUT
%    risqueBC measures the angle between the 
%          subspaces spanned 
%          by loadings (see Canonical Analysis),for 
%          each different couples of parameters 
%          of modes 2 & 3.It is also a matrix. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Residual bootstraps with 3-way data for tucker,   %
%       with different values for the parameters.   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
N=ndims(X);
R=size(X);
nbboot=mi.valmethod.replicates;
cent=mi.sam(1).cen(1);
scale=mi.sam(1).scal(1);
% preprocessing..
Wint=mi.nbfactors.min;
sizeWint=size(Wint);
if size(sizeWint)>1,
   Wmin=Wint(1,:);
   Wmax=Wint(2,:);
else
   Wmin=ones(1,N);
   Wmax=Wint;
end;

for f=Wmin(1):Wmax(1),
   for g=Wmin(2):Wmax(2),
      W=[max([f,g]),f,g];
      [Factors,G]=tucker(X,W);
      Xmod=nmodel(Factors,G);
      E=X-Xmod;
      if strcmp(model,'r'),
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         % Bootstrap avec Reechantillonnage sur les lignes des Residus  %
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         [Abootstrap, bootsam]=bootstrpanadon(nbboot,2,'residueltucker',E,G,Factors);
      elseif strcmp(model,'n'),
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         % Bootstrap avec Reechantillonnage sur les lignes de X         %
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         [Abootstrap, bootsam]=bootstrpanadon(nbboot,2,'tucker',X,W);         
      end;
      somBC=0;
      for b=1:nbboot,
         Bb=Abootstrap{1}{2}(:,:,b);
         Cb=Abootstrap{1}{3}(:,:,b);
         [VBb,VB,cosanglesB]=canonique(Bb,Factors{2});
         [VCb,VC,cosanglesC]=canonique(Cb,Factors{3});
         difBC=0;
         for i=1:f,
            for j=1:g,
               corrBC=cosanglesB(i)*cosanglesC(j);
               difBC=difBC+(1-corrBC^2);
            end;
         end;
         somBC=somBC+difBC;
      end;
      risqueBC(f,g)=sqrt(abs(somBC)/nbboot);
   end;
end;

%graphiques
hfig=findobj('userdata','Cubatch');
set(0,'currentfigure',hfig);
delete(findobj('tag','cbaxes'));
hhh=axes('parent',hfig,'tag','cbaxes','nextplot','replacechildren');
set(hhh,'position',[0.3,0.11,0.685,0.815]);
surf(risqueBC);
xlab=['Number of factors for mode 3'];
ylab=['Number of factors for mode 2'];
zlab=['Bootstrap estimation of the risk of the model'];
xlabel(xlab);
ylabel(ylab);
zlabel(zlab);
if strcmp(model,'n')
   title('Naive bootstrap');
else
   title('Residual bootstrap');
end;



