function parafac2plot(typ,spl,mi,mo,c,d);
%
% This function is used to plot PARAFAC2 results
%
% typ: 'gra','mod','exv','res','xmo'
%  spl for PlotStr structure
%  mi for ModelIn structure
%  mo for ModelOut structure
%  c for content object
%  d is the CBdataset object
%
% Author:
% Sbastien Gourvnec
% ChemoAC, V.U.B.
% Laarbeeklaan 103
% B-1090 Brussels
% Belgium
% 
% Last modified: 2002
% 
% Contact: Sbastien Gourvnec, sebastien.gourvenec@vub.ac.be

warning off MATLAB:mir_warning_variable_used_as_function

Guinames

global ModelIn ModelOut

if size(ModelIn.data.dataparafac2,1)<3
    
    sizemode3=size(ModelIn.data.dataparafac2,2);
    sizemode1=[];
    for i=1:sizemode3
        sizemode1=[sizemode1;(size(ModelIn.data.dataparafac2{i},2))];
    end
    sizemode1=max(sizemode1);
    
    sizemode2=size(ModelIn.data.dataparafac2{1},1);
    
    seb{1}=cell(sizemode1,1,sizemode3);%%% Sizes of mode1(max of all batches =60), mode2 (common size=201) and mode3 (3 batches)
    seb{2}=cell(sizemode2,1);
    seb{3}=cell(sizemode3,1);
    
    truc=getappdata(1,'X');
    
    for j=1:sizemode3
        for i=1:sizemode1
            seb{1}(i,1,j)=cellstr([truc{1}.description{j},'/Sam. ', num2str(i)]);
        end
    end
    
    for i=1:sizemode2
        seb{2}(i)=cellstr(['Var. ',num2str(i)]);
    end
    
    for i=1:sizemode3
        seb{3}(i)=cellstr(['Mat. ',truc{1}.description{i}]);
    end
    
    sebprime{1}=seb{2};
    sebprime{2}=seb{1};
    seb{1}=sebprime{1};
    seb{2}=sebprime{2};
    
else
    
    sizemode1=size(ModelIn.data.dataparafac2,1);
    sizemode2=size(ModelIn.data.dataparafac2,2);
    sizemode3=size(ModelIn.data.dataparafac2,3);
    
    seb{1}=cell(sizemode1,1,sizemode3);%%% Sizes of mode1(max of all batches =60), mode2 (common size=201) and mode3 (3 batches)
    seb{2}=cell(sizemode2,1);
    seb{3}=cell(sizemode3,1);
    
    truc=getappdata(1,'X');
    
    for j=1:sizemode3
        for i=1:sizemode1
            seb{1}(i,1,j)=cellstr([truc{1}.labobj{3}.labels{j},'/Sam. ', num2str(i)]);
        end
    end
    
    for i=1:sizemode2
        seb{2}(i)=cellstr(['Var. ',num2str(i)]);
    end
    
    for i=1:sizemode3
        seb{3}(i)=cellstr(['Mat. ',truc{1}.labobj{3}.labels{i}]);
    end
    
end

if isempty(ModelOut.prediction.data)
    
    if size(ModelIn.data.dataparafac2)>2
        
        if nargin==6,
            X=d{1}.data;
        end;
        WIC=[0.5029 0.5814 0.6402];
        lbc=[0.9 0.93 0.95];
        frc=[0.3529 0.4314 0.4902];
        
        ModelIn.nbfactors.min(1)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(2)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(3)=ModelIn.nbfactors.min(1);
        
        if typ=='gra',
            h=findobj('tag','parafac2plot');
            if ~isempty(h),  
                delete(h);
            end;
            wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',spl)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
            if length(spl.nummode)>1,
                nom=['Modes ', int2str(spl.nummode(1)),'x', int2str(spl.nummode(2)),' - ',int2str(spl.plotdims),'D plots'];
                for i=1:mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2)),
                    st{i}=['PC',int2str(i)];
                end;
            else,
                nom=['Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
                if spl.nummode ==2
                    for i=1:size(ModelOut.model.xfactors{2},2),
                        st2{i}=['Mode3 - Modality',int2str(i)];
                    end;
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                else
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                    if isequal(spl.plotdims,1) & mi.valmethod.bootstrap==0,
                        st{mi.nbfactors.min(spl.nummode)+1}='All';
                    end;
                end;
            end;
            
            
            h0 = figure('MenuBar','none', 'Name',nom, 'MenuBar','none', 'NumberTitle','off', 'Position',[400 300 320 320], 'color',WIC,'Tag','parafac2plot','toolbar','none');
            h1 = uimenu('Parent',h0,'Label','&Tools','Tag','toolp');
            h2 = uimenu('Parent',h1,'Label','&Process control');
            if spl.plotdims==2,
                h3 = uimenu('Parent',h2, ...
                    'enable','on',...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.hotelling.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.hotelling.exist=1;'');end;',...
                    'Label','&Hotelling''s T2');   
                if spl.additional.hotelling.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            if spl.plotdims==2,
                h3 = uimenu('Parent',h2, ...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.potential.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.potential.exist=1;'');end;',...
                    'tag','pot',...
                    'Label','&Potential functions');
                if spl.additional.potential.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            h1 = uimenu('Parent',h0,'Label','&Preferences','Tag','prefp');
            h2 = uimenu('Parent',h1,'Label','&Color');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''b'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','b','Label','&Blue');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''r'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','r','Label','&Red');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''g'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','g','Label','&Green');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''m'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','m','Label','&Magenta');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''c'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','c','Label','&Cyan');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''k'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','k','Label','&Black');
            set(findobj('tag',spl.color),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Marker');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''^'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','^','Label','Triangle');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''p'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','p','Label','Pentagram');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''d'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','d','Label','Diamond');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''*'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','*','Label','Star (*)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''o'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','o','Label','Circle (o)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','.','Label','Point (.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''+'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','+','Label','Plus (+)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''none'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','none','Label','None');
            set(findobj('tag',spl.marker),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Line style');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-','Label','Solid (-)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle='''':'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag',':','Label','Dotted (:)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-.','Label','Dashdotted (-.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''--'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','--','Label','Dashed (--)');
            set(findobj('tag',spl.linestyle),'checked','on');
            h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.grid=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.grid=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','tag','grid','separator','on','Label','&Grid');
            if strcmp(spl.grid,'on'),
                set(findobj('tag','grid'),'checked','on');
            end;
            if isequal(spl.plotdims,3),
                h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.shadow=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.shadow=0;set(gcbo,''''checked'''',''''off'''');end;'')','tag','shadow','Label','&Shadow');
                if isequal(spl.additional.shadow,1),
                    set(findobj('tag','shadow'),'checked','on');
                end;
            end;
            h2 = uimenu('Parent',h1,'Label','&Visible','callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.visible=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.visible=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','Tag','vispca');
            if strcmp(spl.visible,'on'),
                set(findobj('tag','vispca'),'checked','on');
            end;
            h2 = uimenu('Parent',h1, ...
                'Label','&Process control options', ...
                'separator','on',...
                'Tag','pco');
            h3 = uimenu('Parent',h2, ...
                'Label','&Hotelling''s T2 options', ...
                'callback','evalin(''caller'',''hotel(''''win'''',spl,mo);'');',...
                'Tag','ho');
            h3 = uimenu('Parent',h2, ...
                'Label','&Potential options', ...
                'callback','evalin(''caller'',''potentiel(''''win'''',spl,mo);'');',...
                'Tag','po');
            
            if spl.nummode==2
                cb0='evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''');'')';
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'tag','batch','string',st2,'fontsize',12,'callback','evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''')'');','backgroundcolor',lbc,'position',[80 185 170 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            else
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            end;
            cb1='evalin(''caller'',''spl.factors(1)=get(gcbo,''''value'''');'')';
            cb2='evalin(''caller'',''spl.factors(2)=get(gcbo,''''value'''');'')';
            cb3='evalin(''caller'',''spl.factors(3)=get(gcbo,''''value'''');'')';
            mini=min(mi.nbfactors.min);
            if spl.factors(1)>mini,
                spl.factors(1)=1;
            end;
            if spl.factors(2)>mini,
                spl.factors(2)=2;
            end;
            if spl.factors(3)>mini,
                spl.factors(3)=3;
            end;
            switch spl.plotdims,
                case 1
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[120 230 50 50],'backgroundcolor',lbc,'value',spl.factors(1),'string',st,'Tag','1d1');
                case 2,     
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[70 230 50 50],'callback',cb1,'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','2d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[170 230 50 50],'value',spl.factors(2),'callback',cb2,'backgroundcolor',lbc,'string',st,'Tag','2d2');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[120 258 50 19],'backgroundcolor',WIC,'Tag','tool');
                case 3,
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[30 230 50 50],'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','3d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb2,'Position',[130 230 50 50],'backgroundcolor',lbc,'string',st,'Tag','3d2');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb3,'Position',[230 230 50 50],'backgroundcolor',lbc,'value',spl.factors(3),'string',st,'Tag','3d3');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[80 258 50 19],'string','versus','backgroundcolor',WIC,'Tag','tool');
                    h1 = uicontrol('Parent',h0, 'style','text','Position',[180 258 50 19],'backgroundcolor',WIC,'string','versus','Tag','tool');
            end;
            h=findobj('tag','parafac2plot');
            set(h,'waitstatus','open');
            waitfor(h,'waitstatus','close');
        else %    (graphs)
            if ~isempty(spl),
                setcvdata(1,'PlotStr',spl);
            end;
            h=findobj('tag','parafac2plot');
            delete(findobj('tag','textfig'));
            cc=struct(c{1});
            hfig=1;
            set(0,'currentfigure',hfig);
            
            delete(gca);
            delete(findobj('tag','cbaxes'));
            
            hhh=axes('parent',1);
            cop=get(gca,'colororder');
            [tacop,rr]=size(cop);
            set(hhh,'position',[0.3,0.11,0.685,0.815]);
            
            switch typ  % different kinds of graphs
                
                case 'mod'  % 123-D plots
                    dim=cc.dims;
                    dimt=[0 0 0 0 0 0 0 0 0 0 0 0];
                    nt=length(spl.batch);
                    coul=3;%color(nt);
                    
                    if length(spl.nummode)>1,
                        [a1,b1]=size(mo.model.xfactors{spl.nummode(1)})
                        [a2,b2]=size(mo.model.xfactors{spl.nummode(2)})
                        A=kron(mo.model.xfactors{spl.nummode(1)},mo.model.xfactors{spl.nummode(2)});
                        [A p1 p2]=svd(A,0);
                        clear p2;
                        j=mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2));
                        [a,b]=size(A);
                        if j<b,
                            A=A(:,1:j);
                        end;
                    else
                        if spl.nummode == 2
                            if isempty(spl.additional.batch)
                                spl.additional.batch=1;
                            end
                            A= ModelOut.model.xfactors{2}{spl.additional.batch}*ModelOut.model.core;
                            [a,b]=size(A);
                        else
                            A=mo.model.xfactors{spl.nummode};
                            [a,b]=size(A);
                        end
                    end;
                    
                    mi.valmethod.bootstrap=0;
                    
                    switch mi.valmethod.bootstrap,
                        case 0,   %No bootstrap
                            switch spl.plotdims
                                case 1,
                                    if  spl.factors(1)< b+1,
                                        if length(spl.nummode)<2,
                                            plot(A(:,spl.factors(1)),'tag','plo','color',spl.color);
                                        else
                                            for j=1:a1,
                                                plot(A((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                                hold on;
                                            end;
                                        end;
                                    else
                                        plot(A,'tag','plo');
                                    end;
                                    switch spl.format(1),
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    for i=1:a,
                                                        text(i,A(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else,   
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    for i=1:a,
                                                        text(i,A(i,spl.factors(1)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),seb{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else 
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),seb{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 3 %marker
                                    end;
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(dim(spl.nummode)+1:dim(spl.nummode)+dimt(spl.nummode),s.Fproj{spl.nummode}(:,spl.factors(1)),'r*');
                                    end;
                                    hold off;
                                case 2,
                                    if length(spl.nummode)<2,
                                        plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'color',spl.color,'tag','plo');
                                    else
                                        for j=1:a1,
                                            plot(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            hold on;
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;               
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                    end; 
                                                end;               
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(s.Fproj{spl.nummode}(:,spl.factors(1)),mo.prediction.xfactors{spl.nummode}(:,spl.factors(2)),'r*');
                                    end;   
                                    hold off;
                                case 3,
                                    if length(spl.nummode)<2,
                                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                    else,
                                        for j=1:a1,
                                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            hold on;
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for j=1:dim(spl.nummode),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;                  
                                            end;                 
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for j=1:size(A,1)
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),seb{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;                  
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot3(s.Fproj{spl.nummode}(:,spl.factors(1)),s.Fproj{spl.nummode}(:,spl.factors(2)),s.Fproj{spl.nummode}(:,spl.factors(3)),'r*');
                                    end;
                                    if isequal(spl.additional.shadow, 1),
                                        axe=axis;
                                        if length(spl.nummode)<2,
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(axe(2)*ones(dim(spl.nummode),1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                        else
                                            for j=1:a1,
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(axe(2)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            end;
                                        end;
                                    end;
                                    
                                    hold off;
                            end;
                            if spl.format(1)==3,
                                set(findobj('tag','plo'),'marker',spl.marker);
                            end;
                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                            
                            switch spl.format(2)
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                            end;
                            
                            
                        case 1,   %Naive bootstrap parafac2
                            switch spl.plotdims,
                                case 1, %1D plot
                                    spl.plotdims=1;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        for i=1:mi.valmethod.replicates,
                                            uu=mo.validation.segments(:,i);
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            if Ab(:,spl.factors(1))'*mo.model.xfactors{spl.nummode}(uu,spl.factors(1))<0
                                                Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                            end;
                                            plot(uu,Ab(:,spl.factors(1)),'+b','tag','plo2');
                                        end;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,                  
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            plot(Bb(:,spl.factors(1)),'+b','tag','plo2');
                                        end;
                                    end;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    set(findobj('tag','plo'),'color',spl.color);
                                    
                                    if spl.format(1)==3,
                                        set(findobj('tag','plo'),'marker',spl.marker);
                                    else
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.format(1)==2,
                                            for jj=1:c{1}.dims(spl.nummode),
                                                text(jj,A(jj,spl.factors(1)),seb{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                            end;
                                        end;
                                    end;
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    end;  
                                case 2,  %2D plot
                                    coul=couleur(c{1}.dims(spl.nummode));
                                    spl.plotdims=2;
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        m(1:c{1}.dims(1))=0;
                                        for i=1:mi.valmethod.replicates,
                                            uu=mo.validation.segments(:,i);
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            for v=1:mi.nbfactors.min, % changement de signe du mode 1
                                                if Ab(:,v)'*A(uu,v)<0
                                                    Ab(:,v)=-Ab(:,v);
                                                end
                                            end;
                                            for j=1:c{1}.dims(1),  %on elimine les points redondants 
                                                rr=uu(j);
                                                if j>1 & mean(uu(j)==uu(1:j-1))>0
                                                else
                                                    m(rr)=m(rr)+1;
                                                    Abstock{uu(j)}(m(rr),:)=Ab(j,:);
                                                end;
                                            end;
                                        end;
                                        for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                                            Abech=Abstock{jj}(:,:);
                                            tai=size(Abech);
                                            if tai(1)>2,
                                                k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end;
                                        axis equal;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Bbstock(i,:,:)=Bb(:,:);	
                                        end;
                                        for jj=1:c{1}.dims(2),   %tracage des enveloppes convexes
                                            Bbech=squeeze(Bbstock(:,jj,:));
                                            tai=size(Bbech);
                                            if tai(1)>2
                                                k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2');                        
                                            end;
                                        end;
                                    end;  %if/elseif nummode
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    set(findobj('tag','plo'),'marker','none');
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                            set(findobj('tag','plo'),'color',spl.color);
                                    end;   
                            end; %switch spl.plotdims
                        case 2,   %Residual bootstrap parafac2plot
                            switch spl.plotdims,
                                case 1, %1D plot
                                    spl.plotdims=1;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        for i=1:mi.valmethod.replicates,
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            if Ab(:,spl.factors(1))'*A(:,spl.factors(1))<0
                                                Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                            end;
                                            plot(Ab(:,spl.factors(1)),'b','tag','plo2');
                                            hold on;
                                        end;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,                  
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            plot(Bb(:,spl.factors(1)),'b','tag','plo2');
                                            hold on;
                                        end;
                                    end;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    set(findobj('tag','plo'),'color',spl.color);
                                    if spl.format(1)==3,
                                        set(findobj('tag','plo'),'marker',spl.marker);
                                    else
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.format(1)==2,
                                            for jj=1:c{1}.dims(spl.nummode),
                                                text(jj,A(jj,spl.factors(1)),seb{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                            end;
                                        end;
                                    end;
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    end;  
                                case 2,  %2D plot
                                    coul=couleur(c{1}.dims(spl.nummode));
                                    spl.plotdims=2;
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        m(1:c{1}.dims(1))=0;
                                        for i=1:mi.valmethod.replicates,
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Abstock(i,:,:)=Ab(:,:);
                                            for v=1:mi.nbfactors.min, % mode 1 changes sign
                                                if Ab(:,v)'*A(:,v)<0
                                                    Ab(:,v)=-Ab(:,v);
                                                end
                                            end;
                                        end;
                                        for jj=1:c{1}.dims(1),   %convex envelops
                                            Abech=squeeze(Abstock(:,jj,:));
                                            tai=size(Abech);
                                            if tai(1)>2,
                                                k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end;
                                        axis equal;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Bbstock(i,:,:)=Bb(:,:);	
                                        end;
                                        for jj=1:c{1}.dims(2),   %convex envelops
                                            Bbech=squeeze(Bbstock(:,jj,:));
                                            tai=size(Bbech);
                                            if tai(1)>2
                                                k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end
                                    end;  %if/elseif
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    set(findobj('tag','plo'),'marker','none');
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                            set(findobj('tag','plo'),'color',spl.color);
                                    end; 
                            end; %switch spl.plotdims
                            
                    end; %switch s.bootstrap
                    if length(spl.nummode)>1 |spl.factors(1)> b,
                        xl=['PC',int2str(spl.factors(1))];
                        if spl.factors(1)> b,
                            xl=['All PC'];
                        end;
                    else
                        xl=['Mode ',num2str(spl.nummode),', PC',int2str(spl.factors(1))];
                        
                    end;
                    xlabel(xl,'tag','xlab');
                    if spl.plotdims>1
                        if length(spl.nummode)>1|spl.factors(1)> b,
                            yl=['PC',int2str(spl.factors(2))];
                        else
                            yl=['PC',int2str(spl.factors(2))];
                        end;
                        ylabel(yl,'tag','ylab');
                        if spl.plotdims>2,
                            if length(spl.nummode)>1|spl.factors(1)> b,
                                zl=['PC',int2str(spl.factors(3))];
                            else
                                zl=['PC',int2str(spl.factors(3))];
                            end;
                            zlabel(zl,'tag','zlab');
                        end;
                    end;
                    if length(spl.nummode)<2,
                        titre=['Mode ',int2str(spl.nummode)];
                    else,
                        titre=['Modes ',int2str(spl.nummode(1)),'x',int2str(spl.nummode(2))];
                    end;
                    title(titre);
                    if spl.additional.potential.exist==1 & spl.plotdims==2,
                        axi=axis;
                        hold on;
                        try
                            potentiel('gra',spl,A,axi);
                        catch
                            uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
                        end;
                    end;
                    if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
                        hold on;
                        try
                            hotel('gra',spl,A);
                        catch
                            uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
                        end;
                    end;
                    hold off;
                    set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                    set(findobj('tag','plo'),'visible',spl.visible);
                    set(findobj('tag','plo2'),'visible',spl.visible);
                case 'xmo',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.model.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Model'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        % Cu_FIX_2011
                        %   mod1 instead of mod (mod is a func. name)
                        for k=1:size(ModelIn.data.dataparafac2,3)
                            mod1{k}=((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                        end
                        surf(mod1{sel})
                        axis tight
                        title(['Model of ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                    end
                    
                case 'res',
                    [sel,ok]=listdlg('liststring',mi.samlabs.labels,...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between ',mi.samlabs.name]);
                    if ok==1,
                        E={[],[],[]};
                        for k=1:size(ModelIn.data.dataparafac2,3)
                            E{k}=ModelIn.data.dataparafac2(:,:,k)-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                        end
                        Res=[];
                        for k=1:size(ModelIn.data.dataparafac2,3)
                            Res(:,:,k)=E{k};
                        end
                        surf(reshape(Res(sel,:,:),size(ModelIn.data.dataparafac2,2),size(ModelIn.data.dataparafac2,3))');grid on;
                        axis tight
                        title(['Residuals for ',mi.samlabs.labels{sel}]);
                        xlabel('Mode 1');
                    end;
                case 'all',
                    E=cell(1,size(ModelIn.data.dataparafac2,3));
                    
                    for k=1:size(ModelIn.data.dataparafac2,3)
                        E{k}=ModelIn.data.dataparafac2(:,:,k)-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                    end
                    Res=[];
                    for k=1:size(ModelIn.data.dataparafac2,3)
                        Res=[Res;E{k}'];
                    end
                    plot(Res');grid on;
                    title('Residuals for all samples');
                    xlabel('Mode 2')
                    ylabel('Mode 1')
                case 'bat',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.model.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        for k=1:size(ModelIn.data.dataparafac2,3)
                            E{k}=ModelIn.data.dataparafac2(:,:,k)-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                        end
                        surf(E{sel})
                        axis tight
                        title(['Residuals for ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                    end
            end;  %switch type
            hold off;
            
            
            set(gca,tg,'cbaxes');
            PARAFAC2DisplayInfo(gcbf,ModelOut)
            
            
        end;  %graphs
    else
        
        if nargin==6,
            X=d{1}.data;
        end;
        WIC=[0.5029 0.5814 0.6402];
        lbc=[0.9 0.93 0.95];
        frc=[0.3529 0.4314 0.4902];
        
        ModelIn.nbfactors.min(1)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(2)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(3)=ModelIn.nbfactors.min(1);
        
        spl.additional.batch=1;
        
        if typ=='gra',
            h=findobj('tag','parafac2plot');
            if ~isempty(h),  
                delete(h);
            end;
            wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',spl)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
            if length(spl.nummode)>1,
                nom=['Modes ', int2str(spl.nummode(1)),'x', int2str(spl.nummode(2)),' - ',int2str(spl.plotdims),'D plots'];
                for i=1:mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2)),
                    st{i}=['PC',int2str(i)];
                end;
            else,
                nom=['Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
                if spl.nummode ==2
                    for i=1:size(ModelOut.model.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                else
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                    if isequal(spl.plotdims,1) & mi.valmethod.bootstrap==0,
                        st{mi.nbfactors.min(spl.nummode)+1}='All';
                    end;
                end;
            end;
            
            
            h0 = figure('MenuBar','none', 'Name',nom, 'MenuBar','none', 'NumberTitle','off', 'Position',[400 300 320 320], 'color',WIC,'Tag','parafac2plot','toolbar','none');
            h1 = uimenu('Parent',h0,'Label','&Tools','Tag','toolp');
            h2 = uimenu('Parent',h1,'Label','&Process control');
            if spl.plotdims==2, 
                h3 = uimenu('Parent',h2, ...
                    'enable','on',...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.hotelling.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.hotelling.exist=1;'');end;',...
                    'Label','&Hotelling''s T2');   
                if spl.additional.hotelling.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            if spl.plotdims==2,  
                h3 = uimenu('Parent',h2, ...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.potential.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.potential.exist=1;'');end;',...
                    'tag','pot',...
                    'Label','&Potential functions');
                if spl.additional.potential.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            h1 = uimenu('Parent',h0,'Label','&Preferences','Tag','prefp');
            h2 = uimenu('Parent',h1,'Label','&Color');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''b'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','b','Label','&Blue');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''r'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','r','Label','&Red');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''g'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','g','Label','&Green');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''m'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','m','Label','&Magenta');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''c'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','c','Label','&Cyan');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''k'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','k','Label','&Black');
            set(findobj('tag',spl.color),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Marker');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''^'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','^','Label','Triangle');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''p'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','p','Label','Pentagram');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''d'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','d','Label','Diamond');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''*'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','*','Label','Star (*)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''o'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','o','Label','Circle (o)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','.','Label','Point (.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''+'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','+','Label','Plus (+)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''none'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','none','Label','None');
            set(findobj('tag',spl.marker),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Line style');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-','Label','Solid (-)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle='''':'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag',':','Label','Dotted (:)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-.','Label','Dashdotted (-.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''--'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','--','Label','Dashed (--)');
            set(findobj('tag',spl.linestyle),'checked','on');
            h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.grid=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.grid=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','tag','grid','separator','on','Label','&Grid');
            if strcmp(spl.grid,'on'),
                set(findobj('tag','grid'),'checked','on');
            end;
            if isequal(spl.plotdims,3),
                h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.shadow=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.shadow=0;set(gcbo,''''checked'''',''''off'''');end;'')','tag','shadow','Label','&Shadow');
                if isequal(spl.additional.shadow,1),
                    set(findobj('tag','shadow'),'checked','on');
                end;
            end;
            h2 = uimenu('Parent',h1,'Label','&Visible','callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.visible=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.visible=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','Tag','vispca');
            if strcmp(spl.visible,'on'),
                set(findobj('tag','vispca'),'checked','on');
            end;
            h2 = uimenu('Parent',h1, ...
                'Label','&Process control options', ...
                'separator','on',...
                'Tag','pco');
            h3 = uimenu('Parent',h2, ...
                'Label','&Hotelling''s T2 options', ...
                'callback','evalin(''caller'',''hotel(''''win'''',spl,mo);'');',...
                'Tag','ho');
            h3 = uimenu('Parent',h2, ...
                'Label','&Potential options', ...
                'callback','evalin(''caller'',''potentiel(''''win'''',spl,mo);'');',...
                'Tag','po');
            if spl.nummode==2
                
                cb0='evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''');'')';
                
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'tag','batch','string',st2,'fontsize',12,'callback','evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[80 185 170 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                % h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Label','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            else
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            end;
            cb1='evalin(''caller'',''spl.factors(1)=get(gcbo,''''value'''');'')';
            cb2='evalin(''caller'',''spl.factors(2)=get(gcbo,''''value'''');'')';
            cb3='evalin(''caller'',''spl.factors(3)=get(gcbo,''''value'''');'')';
            mini=min(mi.nbfactors.min);
            if spl.factors(1)>mini,
                spl.factors(1)=1;
            end;
            if spl.factors(2)>mini,
                spl.factors(2)=2;
            end;
            if spl.factors(3)>mini,
                spl.factors(3)=3;
            end;
            switch spl.plotdims,
                case 1
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[120 230 50 50],'backgroundcolor',lbc,'value',spl.factors(1),'string',st,'Tag','1d1');
                case 2,     
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[70 230 50 50],'callback',cb1,'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','2d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[170 230 50 50],'value',spl.factors(2),'callback',cb2,'backgroundcolor',lbc,'string',st,'Tag','2d2');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[120 258 50 19],'backgroundcolor',WIC,'Tag','tool');
                case 3,
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[30 230 50 50],'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','3d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb2,'Position',[130 230 50 50],'backgroundcolor',lbc,'string',st,'Tag','3d2');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb3,'Position',[230 230 50 50],'backgroundcolor',lbc,'value',spl.factors(3),'string',st,'Tag','3d3');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[80 258 50 19],'string','versus','backgroundcolor',WIC,'Tag','tool');
                    h1 = uicontrol('Parent',h0, 'style','text','Position',[180 258 50 19],'backgroundcolor',WIC,'string','versus','Tag','tool');
            end;
            h=findobj('tag','parafac2plot');
            set(h,'waitstatus','open');
            waitfor(h,'waitstatus','close');
        else %    (graphs)
            if ~isempty(spl),
                setcvdata(1,'PlotStr',spl);
            end;
            h=findobj('tag','parafac2plot');
            delete(findobj('tag','textfig'));
            cc=struct(c{1});
            hfig=1;
            set(0,'currentfigure',hfig);
            
            delete(gca);
            delete(findobj('tag','cbaxes'));
            
            hhh=axes('parent',1);
            cop=get(gca,'colororder');
            [tacop,rr]=size(cop);
            set(hhh,'position',[0.3,0.11,0.685,0.815]);
            
            switch typ  % different kinds of graphics
                
                case 'mod'  % 123-D plots
                    dim=cc.dims;
                    dimt=[0 0 0 0 0 0 0 0 0 0 0 0]; 
                    nt=length(spl.batch);
                    coul=3;%color(nt);
                    
                    if length(spl.nummode)>1,
                        [a1,b1]=size(mo.model.xfactors{spl.nummode(1)})
                        [a2,b2]=size(mo.model.xfactors{spl.nummode(2)})
                        A=kron(mo.model.xfactors{spl.nummode(1)},mo.model.xfactors{spl.nummode(2)});
                        [A p1 p2]=svd(A,0);
                        clear p2;
                        j=mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2));
                        [a,b]=size(A);
                        if j<b,
                            A=A(:,1:j);
                        end;
                    else
                        if spl.nummode == 2
                            if isempty(spl.additional.batch)
                                spl.additional.batch=1;
                            end
                            A= ModelOut.model.xfactors{2}{spl.additional.batch}*ModelOut.model.core;
                            [a,b]=size(A);
                        else
                            A=mo.model.xfactors{spl.nummode};
                            [a,b]=size(A);
                        end
                    end;
                    
                    mi.valmethod.bootstrap=0;
                    
                    switch mi.valmethod.bootstrap,
                        case 0,   %No bootstrap
                            switch spl.plotdims
                                case 1,
                                    if  spl.factors(1)< b+1,
                                        if length(spl.nummode)<2,
                                            plot(A(:,spl.factors(1)),'tag','plo','color',spl.color);
                                            set(gca,'Xlim',[1 size(A(:,spl.factors(1)),1)]);
                                        else
                                            for j=1:a1,
                                                plot(A((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                                hold on;
                                                set(gca,'Xlim',[1 size(A((j-1)*a2+1:j*a2,spl.factors(1)),1)]);
                                            end;
                                        end;
                                    else
                                        plot(A,'tag','plo');
                                        set(gca,'Xlim',[1 size(A,1)]);
                                    end;
                                    switch spl.format(1),
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    for i=1:a,
                                                        text(i,A(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else,   
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    if spl.nummode==2
                                                        for i=1:a,
                                                            text(i,A(i,spl.factors(1)),seb{spl.nummode}(i,spl.additional.batch),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:a,
                                                            text(i,A(i,spl.factors(1)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),seb{spl.nummode(2)}(i,spl.additional.batch),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else 
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),seb{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 3 %marker
                                    end;
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(dim(spl.nummode)+1:dim(spl.nummode)+dimt(spl.nummode),s.Fproj{spl.nummode}(:,spl.factors(1)),'r*');
                                    end;
                                    hold off;
                                case 2,
                                    if length(spl.nummode)<2,
                                        plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'color',spl.color,'tag','plo');
                                    else
                                        for j=1:a1,
                                            plot(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            hold on;
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode+1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;               
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i,spl.additional.batch),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode+1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                        % text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),c{1}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;               
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(s.Fproj{spl.nummode}(:,spl.factors(1)),mo.prediction.xfactors{spl.nummode}(:,spl.factors(2)),'r*');
                                    end;   
                                    hold off;
                                case 3,
                                    if length(spl.nummode)<2,
                                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                    else,
                                        for j=1:a1,
                                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            hold on;
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for j=1:dim(spl.nummode+1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;                  
                                            end;                 
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j,spl.additional.batch),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for j=1:dim(spl.nummode+1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),seb{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;                  
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot3(s.Fproj{spl.nummode}(:,spl.factors(1)),s.Fproj{spl.nummode}(:,spl.factors(2)),s.Fproj{spl.nummode}(:,spl.factors(3)),'r*');
                                    end;
                                    if isequal(spl.additional.shadow, 1),
                                        axe=axis;
                                        if length(spl.nummode)<2,
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(axe(2)*ones(dim(spl.nummode),1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                        else
                                            for j=1:a1,
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(axe(2)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            end;
                                        end;
                                    end;
                                    
                                    hold off;
                            end;
                            if spl.format(1)==3,
                                set(findobj('tag','plo'),'marker',spl.marker);
                            end;
                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                            
                            switch spl.format(2)
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                            end;
                            
                            
                            if length(spl.nummode)>1 |spl.factors(1)> b,
                                xl=['PC',int2str(spl.factors(1))];
                                if spl.factors(1)> b,
                                    xl=['All PC'];
                                end;
                            else
                                xl=['Mode ',num2str(spl.nummode),', PC',int2str(spl.factors(1))];
                                
                            end;
                            xlabel(xl,'tag','xlab');
                            if spl.plotdims>1
                                if length(spl.nummode)>1|spl.factors(1)> b,
                                    yl=['PC',int2str(spl.factors(2))];
                                else
                                    yl=['PC',int2str(spl.factors(2))];
                                end;
                                ylabel(yl,'tag','ylab');
                                if spl.plotdims>2,
                                    if length(spl.nummode)>1|spl.factors(1)> b,
                                        zl=['PC',int2str(spl.factors(3))];
                                    else
                                        zl=['PC',int2str(spl.factors(3))];
                                    end;
                                    zlabel(zl,'tag','zlab');
                                end;
                            end;
                            if length(spl.nummode)<2,
                                titre=['Mode ',int2str(spl.nummode)];
                            else,
                                titre=['Modes ',int2str(spl.nummode(1)),'x',int2str(spl.nummode(2))];
                            end;
                            title(titre);
                            if spl.additional.potential.exist==1 & spl.plotdims==2,
                                axi=axis;
                                hold on;
                                try
                                    potentiel('gra',spl,A,axi);
                                catch
                                    uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
                                end;
                            end;
                            if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
                                hold on;
                                try
                                    hotel('gra',spl,A);
                                catch
                                    uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
                                end;
                            end;
                            hold off;
                            set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                            set(findobj('tag','plo'),'visible',spl.visible);
                            set(findobj('tag','plo2'),'visible',spl.visible);
                    end
                case 'xmo',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.model.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Model'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        % Cu_FIX_2011
                        %   mod1 instead of mod (mod is a func. name)
                        for k=1:size(ModelIn.data.dataparafac2,2)
                            mod1{k}=((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                        end
                        surf(mod1{sel})
                        axis tight
                        title(['Model of ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                    end
                    
                case 'res',
                    [sel,ok]=listdlg('liststring',mi.samlabs.labels,...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between ',mi.samlabs.name]);
                    if ok==1,
                        E={[],[],[]};
                        for k=1:size(ModelIn.data.dataparafac2,2)
                            E{k}=ModelIn.data.dataparafac2{k}-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                        end
                        Res=[];
                        for k=1:size(ModelIn.data.dataparafac2,2)
                            Res=[Res;E{k}'];
                        end
                        plot(Res(sel,:));grid on;
                        set(gca,'Xlim',[1 size(Res(sel,:),2)]);
                        title(['Residuals for ',mi.samlabs.labels{sel}]);
                        xlabel('Mode 1');
                    end;
                case 'all',
                    E=cell(1,size(ModelIn.data.dataparafac2,2));
                    
                    for k=1:size(ModelIn.data.dataparafac2,2)
                        E{k}=ModelIn.data.dataparafac2{k}-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                    end
                    Res=[];
                    for k=1:size(ModelIn.data.dataparafac2,2)
                        Res=[Res;E{k}'];
                    end
                    surf(Res');grid on;
                    axis tight
                    title('Residuals for all samples');
                    xlabel('Mode 2');
                    ylabel('Mode 1');
                case 'bat',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.model.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        for k=1:size(ModelIn.data.dataparafac2,2)
                            E{k}=ModelIn.data.dataparafac2{k}-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                        end
                        surf(E{sel})
                        axis tight
                        title(['Residuals for ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                    end
            end;  %switch type
            hold off;
            
            set(gca,tg,'cbaxes');
            PARAFAC2DisplayInfo(gcbf,ModelOut)
            
            
        end;  %graphs
    end
    
    %-----------------------------------------------------------------------
    
else
    
    if size(ModelIn.data.dataparafac2)>2
        
        if nargin==6,
            X=d{1}.data;
        end;
        WIC=[0.5029 0.5814 0.6402];
        lbc=[0.9 0.93 0.95];
        frc=[0.3529 0.4314 0.4902];
        
        ModelIn.nbfactors.min(1)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(2)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(3)=ModelIn.nbfactors.min(1);
        
        
        if typ=='gra',
            h=findobj('tag','parafac2plot');
            if ~isempty(h),  
                delete(h);
            end;
            wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',spl)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
            if length(spl.nummode)>1,
                nom=['Modes ', int2str(spl.nummode(1)),'x', int2str(spl.nummode(2)),' - ',int2str(spl.plotdims),'D plots'];
                for i=1:mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2)),
                    st{i}=['PC',int2str(i)];
                end;
            else,
                nom=['Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
                if spl.nummode ==2
                    for i=1:size(ModelOut.prediction.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                else
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                    if isequal(spl.plotdims,1) & mi.valmethod.bootstrap==0,
                        st{mi.nbfactors.min(spl.nummode)+1}='All';
                    end;
                end;
            end;
            
            
            h0 = figure('MenuBar','none', 'Name',nom, 'MenuBar','none', 'NumberTitle','off', 'Position',[400 300 320 320], 'color',WIC,'Tag','parafac2plot','toolbar','none');
            h1 = uimenu('Parent',h0,'Label','&Tools','Tag','toolp');
            h2 = uimenu('Parent',h1,'Label','&Process control');
            if spl.plotdims==2, 
                h3 = uimenu('Parent',h2, ...
                    'enable','on',...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.hotelling.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.hotelling.exist=1;'');end;',...
                    'Label','&Hotelling''s T2');   
                if spl.additional.hotelling.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            if spl.plotdims==2,  
                h3 = uimenu('Parent',h2, ...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.potential.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.potential.exist=1;'');end;',...
                    'tag','pot',...
                    'Label','&Potential functions');
                if spl.additional.potential.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            h1 = uimenu('Parent',h0,'Label','&Preferences','Tag','prefp');
            h2 = uimenu('Parent',h1,'Label','&Color');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''b'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','b','Label','&Blue');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''r'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','r','Label','&Red');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''g'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','g','Label','&Green');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''m'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','m','Label','&Magenta');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''c'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','c','Label','&Cyan');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''k'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','k','Label','&Black');
            set(findobj('tag',spl.color),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Marker');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''^'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','^','Label','Triangle');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''p'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','p','Label','Pentagram');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''d'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','d','Label','Diamond');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''*'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','*','Label','Star (*)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''o'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','o','Label','Circle (o)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','.','Label','Point (.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''+'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','+','Label','Plus (+)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''none'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','none','Label','None');
            set(findobj('tag',spl.marker),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Line style');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-','Label','Solid (-)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle='''':'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag',':','Label','Dotted (:)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-.','Label','Dashdotted (-.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''--'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','--','Label','Dashed (--)');
            set(findobj('tag',spl.linestyle),'checked','on');
            h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.grid=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.grid=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','tag','grid','separator','on','Label','&Grid');
            if strcmp(spl.grid,'on'),
                set(findobj('tag','grid'),'checked','on');
            end;
            if isequal(spl.plotdims,3),
                h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.shadow=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.shadow=0;set(gcbo,''''checked'''',''''off'''');end;'')','tag','shadow','Label','&Shadow');
                if isequal(spl.additional.shadow,1),
                    set(findobj('tag','shadow'),'checked','on');
                end;
            end;
            h2 = uimenu('Parent',h1,'Label','&Visible','callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.visible=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.visible=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','Tag','vispca');
            if strcmp(spl.visible,'on'),
                set(findobj('tag','vispca'),'checked','on');
            end;
            h2 = uimenu('Parent',h1, ...
                'Label','&Process control options', ...
                'separator','on',...
                'Tag','pco');
            h3 = uimenu('Parent',h2, ...
                'Label','&Hotelling''s T2 options', ...
                'callback','evalin(''caller'',''hotel(''''win'''',spl,mo);'');',...
                'Tag','ho');
            h3 = uimenu('Parent',h2, ...
                'Label','&Potential options', ...
                'callback','evalin(''caller'',''potentiel(''''win'''',spl,mo);'');',...
                'Tag','po');
            if spl.nummode==2
                cb0='evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''');'')';
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'tag','batch','string',st2,'fontsize',12,'callback','evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''')'');','backgroundcolor',lbc,'position',[80 185 170 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            else
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            end;
            cb1='evalin(''caller'',''spl.factors(1)=get(gcbo,''''value'''');'')';
            cb2='evalin(''caller'',''spl.factors(2)=get(gcbo,''''value'''');'')';
            cb3='evalin(''caller'',''spl.factors(3)=get(gcbo,''''value'''');'')';
            mini=min(mi.nbfactors.min);
            if spl.factors(1)>mini,
                spl.factors(1)=1;
            end;
            if spl.factors(2)>mini,
                spl.factors(2)=2;
            end;
            if spl.factors(3)>mini,
                spl.factors(3)=3;
            end;
            switch spl.plotdims,
                case 1
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[120 230 50 50],'backgroundcolor',lbc,'value',spl.factors(1),'string',st,'Tag','1d1');
                case 2,     
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[70 230 50 50],'callback',cb1,'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','2d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[170 230 50 50],'value',spl.factors(2),'callback',cb2,'backgroundcolor',lbc,'string',st,'Tag','2d2');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[120 258 50 19],'backgroundcolor',WIC,'Tag','tool');
                case 3,
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[30 230 50 50],'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','3d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb2,'Position',[130 230 50 50],'backgroundcolor',lbc,'string',st,'Tag','3d2');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb3,'Position',[230 230 50 50],'backgroundcolor',lbc,'value',spl.factors(3),'string',st,'Tag','3d3');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[80 258 50 19],'string','versus','backgroundcolor',WIC,'Tag','tool');
                    h1 = uicontrol('Parent',h0, 'style','text','Position',[180 258 50 19],'backgroundcolor',WIC,'string','versus','Tag','tool');
            end;
            h=findobj('tag','parafac2plot');
            set(h,'waitstatus','open');
            waitfor(h,'waitstatus','close');
        else %    (graphs)
            if ~isempty(spl),
                setcvdata(1,'PlotStr',spl);
            end;
            h=findobj('tag','parafac2plot');
            delete(findobj('tag','textfig'));
            cc=struct(c{1});
            hfig=1;
            set(0,'currentfigure',hfig);
            delete(gca);
            delete(findobj('tag','cbaxes'));
            
            hhh=axes('parent',1);
            cop=get(gca,'colororder');
            [tacop,rr]=size(cop);
            set(hhh,'position',[0.3,0.11,0.685,0.815]);
            
            switch typ  % different kinds of graphics
                
                case 'mod'  % 123-D plots
                    dim=cc.dims;
                    dimt=[0 0 0 0 0 0 0 0 0 0 0 0]; 
                    nt=length(spl.batch);
                    coul=3;%color(nt);
                    
                    if length(spl.nummode)>1,
                        [a1,b1]=size(mo.model.xfactors{spl.nummode(1)})
                        [a2,b2]=size(mo.model.xfactors{spl.nummode(2)})
                        A=kron(mo.model.xfactors{spl.nummode(1)},mo.model.xfactors{spl.nummode(2)});
                        [A p1 p2]=svd(A,0);
                        clear p2;
                        j=mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2));
                        [a,b]=size(A);
                        if j<b,
                            A=A(:,1:j);
                        end;
                    else
                        if spl.nummode == 2
                            A= ModelOut.model.xfactors{2}{spl.additional.batch}*ModelOut.model.core;
                            [a,b]=size(A);
                            Anew=ModelOut.prediction.xfactors{2}{spl.additional.batch}*ModelOut.prediction.info.H;
                            [anew,bnew]=size(Anew);
                        else
                            A=mo.model.xfactors{spl.nummode};
                            [a,b]=size(A);
                            Anew=ModelOut.prediction.xfactors{spl.nummode};
                            [anew,bnew]=size(Anew);
                        end
                    end;
                    
                    mi.valmethod.bootstrap=0;
                    
                    switch mi.valmethod.bootstrap,
                        case 0,   %No bootstrap
                            switch spl.plotdims
                                case 1,
                                    if  spl.factors(1)< b+1,
                                        if length(spl.nummode)<2,
                                            plot(A(:,spl.factors(1)),'tag','plo','color','b');
                                            hold on
                                            plot(Anew(:,spl.factors(1)),'tag','plo','color','r');
                                            set(gca,'Xlim',[1 a]);
                                            legend('calibration', 'test');
                                        else
                                            for j=1:a1,
                                                plot(A((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color','b');
                                                hold on;
                                                plot(Anew((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color','r');
                                                legend('calibration', 'test');
                                            end;
                                        end;
                                    else
                                        plot(A,'tag','plo');
                                    end;
                                    switch spl.format(1),
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    for i=1:a,
                                                        text(i,A(i,spl.factors(1)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                        text(i,Anew(i,spl.factors(1)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                    end;
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                            text(i,Anew((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else,   
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                        text(i,Anew(i,j),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    for i=1:a,
                                                        text(i,A(i,spl.factors(1)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),seb{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else 
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),seb{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 3 %marker
                                    end;
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(dim(spl.nummode)+1:dim(spl.nummode)+dimt(spl.nummode),s.Fproj{spl.nummode}(:,spl.factors(1)),'r*');
                                    end;
                                    hold off;
                                case 2,
                                    if length(spl.nummode)<2,
                                        plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'color','b','tag','plo');
                                        hold on
                                        plot(Anew(:,spl.factors(1)),Anew(:,spl.factors(2)),'color','r','tag','plo');
                                        legend('calibration','test'); 
                                    else
                                        for j=1:a1,
                                            plot(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color','b');
                                            hold on;
                                            plot(Anew((j-1)*a2+1:j*a2,spl.factors(1)),Anew((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color','r');
                                            legend('calibration','test'); 
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                        text(Anew(i,spl.factors(1)),Anew(i,spl.factors(2)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                            text(Anew(i,spl.factors(1)),Anew(i,spl.factors(2)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                            text(Anew(i,spl.factors(1)),Anew(i,spl.factors(2)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;               
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode+1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                        % text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),c{1}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;               
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(s.Fproj{spl.nummode}(:,spl.factors(1)),mo.prediction.xfactors{spl.nummode}(:,spl.factors(2)),'r*');
                                    end;   
                                    hold off;
                                case 3,
                                    if length(spl.nummode)<2,
                                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color','b','tag','plo');
                                        hold on
                                        plot3(Anew(:,spl.factors(1)),Anew(:,spl.factors(2)),Anew(:,spl.factors(3)),'color','r','tag','plo');
                                        legend('calibration','test');
                                    else,
                                        for j=1:a1,
                                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color','b');
                                            hold on;
                                            plot3(Anew((j-1)*a2+1:j*a2,spl.factors(1)),Anew((j-1)*a2+1:j*a2,spl.factors(2)),Anew((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color','r');
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color','b','tag','plo2');
                                                    end;
                                                    for j=1:anew
                                                        text(Anew(j,spl.factors(1)),Anew(j,spl.factors(2)),Anew(j,spl.factors(3)),int2str(j),'fontsize',7,'color','r','tag','plo2');
                                                    end
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color','b','tag','plo2');
                                                        end;
                                                        for j=1:size(Anew,1),
                                                            text(Anew(j,spl.factors(1)),Anew(j,spl.factors(2)),Anew(j,spl.factors(3)),int2str(j),'fontsize',7,'color','r','tag','plo2');
                                                        end                                                    
                                                    else
                                                        for j=1:dim(spl.nummode),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color','b','tag','plo2');
                                                        end;
                                                        for j=1:dim(spl.nummode),
                                                            text(Anew(j,spl.factors(1)),Anew(j,spl.factors(2)),Anew(j,spl.factors(3)),int2str(j),'fontsize',7,'color','r','tag','plo2');
                                                        end
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;                  
                                            end;                 
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for j=1:dim(spl.nummode+1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),seb{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;                  
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot3(s.Fproj{spl.nummode}(:,spl.factors(1)),s.Fproj{spl.nummode}(:,spl.factors(2)),s.Fproj{spl.nummode}(:,spl.factors(3)),'r*');
                                    end;
                                    if isequal(spl.additional.shadow, 1),
                                        axe=axis;
                                        if length(spl.nummode)<2,
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(axe(2)*ones(dim(spl.nummode),1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                        else
                                            for j=1:a1,
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(axe(2)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            end;
                                        end;
                                    end;
                                    
                                    hold off;
                            end;
                            if spl.format(1)==3,
                                set(findobj('tag','plo'),'marker',spl.marker);
                            end;
                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                            
                            switch spl.format(2)
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                                    %set(findobj('tag','plo'),'marker','none');
                            end;
                            
                            
                        case 1,   %Naive bootstrap parafac2
                            switch spl.plotdims,
                                case 1, %1D plot
                                    spl.plotdims=1;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        for i=1:mi.valmethod.replicates,
                                            uu=mo.validation.segments(:,i);
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            if Ab(:,spl.factors(1))'*mo.model.xfactors{spl.nummode}(uu,spl.factors(1))<0
                                                Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                            end;
                                            plot(uu,Ab(:,spl.factors(1)),'+b','tag','plo2');
                                        end;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,                  
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            plot(Bb(:,spl.factors(1)),'+b','tag','plo2');
                                        end;
                                    end;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    set(findobj('tag','plo'),'color',spl.color);
                                    
                                    if spl.format(1)==3,
                                        set(findobj('tag','plo'),'marker',spl.marker);
                                    else
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.format(1)==2,
                                            for jj=1:c{1}.dims(spl.nummode),
                                                text(jj,A(jj,spl.factors(1)),seb{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                            end;
                                        end;
                                    end;
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    end;  
                                case 2,  %2D plot
                                    coul=couleur(c{1}.dims(spl.nummode));
                                    spl.plotdims=2;
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        m(1:c{1}.dims(1))=0;
                                        for i=1:mi.valmethod.replicates,
                                            uu=mo.validation.segments(:,i);
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            for v=1:mi.nbfactors.min, % changement de signe du mode 1
                                                if Ab(:,v)'*A(uu,v)<0
                                                    Ab(:,v)=-Ab(:,v);
                                                end
                                            end;
                                            for j=1:c{1}.dims(1),  %on elimine les points redondants 
                                                rr=uu(j);
                                                if j>1 & mean(uu(j)==uu(1:j-1))>0
                                                else
                                                    m(rr)=m(rr)+1;
                                                    Abstock{uu(j)}(m(rr),:)=Ab(j,:);
                                                end;
                                            end;
                                        end;
                                        for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                                            Abech=Abstock{jj}(:,:);
                                            tai=size(Abech);
                                            if tai(1)>2,
                                                k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end;
                                        axis equal;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Bbstock(i,:,:)=Bb(:,:);	
                                        end;
                                        for jj=1:c{1}.dims(2),   %tracage des enveloppes convexes
                                            Bbech=squeeze(Bbstock(:,jj,:));
                                            tai=size(Bbech);
                                            if tai(1)>2
                                                k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2');                        
                                            end;
                                        end;
                                        % mettre 
                                    end;  %if/elseif nummode
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    set(findobj('tag','plo'),'marker','none');
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                            set(findobj('tag','plo'),'color',spl.color);
                                    end;   
                            end; %switch spl.plotdims
                        case 2,   %Residual bootstrap parafac2plot
                            switch spl.plotdims,
                                case 1, %1D plot
                                    spl.plotdims=1;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        for i=1:mi.valmethod.replicates,
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            if Ab(:,spl.factors(1))'*A(:,spl.factors(1))<0
                                                Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                            end;
                                            plot(Ab(:,spl.factors(1)),'b','tag','plo2');
                                            hold on;
                                        end;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,                  
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            plot(Bb(:,spl.factors(1)),'b','tag','plo2');
                                            hold on;
                                        end;
                                    end;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    set(findobj('tag','plo'),'color',spl.color);
                                    if spl.format(1)==3,
                                        set(findobj('tag','plo'),'marker',spl.marker);
                                    else
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.format(1)==2,
                                            for jj=1:c{1}.dims(spl.nummode),
                                                text(jj,A(jj,spl.factors(1)),seb{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                            end;
                                        end;
                                    end;
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    end;  
                                case 2,  %2D plot
                                    coul=couleur(c{1}.dims(spl.nummode));
                                    spl.plotdims=2;
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        m(1:c{1}.dims(1))=0;
                                        for i=1:mi.valmethod.replicates,
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Abstock(i,:,:)=Ab(:,:);
                                            for v=1:mi.nbfactors.min, % changement de signe du mode 1
                                                if Ab(:,v)'*A(:,v)<0
                                                    Ab(:,v)=-Ab(:,v);
                                                end
                                            end;
                                        end;
                                        for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                                            Abech=squeeze(Abstock(:,jj,:));
                                            tai=size(Abech);
                                            if tai(1)>2,
                                                k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end;
                                        axis equal;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Bbstock(i,:,:)=Bb(:,:);	
                                        end;
                                        for jj=1:c{1}.dims(2),   %traage des enveloppes convexes
                                            Bbech=squeeze(Bbstock(:,jj,:));
                                            tai=size(Bbech);
                                            if tai(1)>2
                                                k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end
                                    end;  %if/elseif
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    set(findobj('tag','plo'),'marker','none');
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                            set(findobj('tag','plo'),'color',spl.color);
                                    end; 
                            end; %switch spl.plotdims
                            
                    end; %switch s.bootstrap
                    if length(spl.nummode)>1 |spl.factors(1)> b,
                        xl=['PC',int2str(spl.factors(1))];
                        if spl.factors(1)> b,
                            xl=['All PC'];
                        end;
                    else
                        xl=['Mode ',num2str(spl.nummode),', PC',int2str(spl.factors(1))];
                        
                    end;
                    xlabel(xl,'tag','xlab');
                    if spl.plotdims>1
                        if length(spl.nummode)>1|spl.factors(1)> b,
                            yl=['PC',int2str(spl.factors(2))];
                        else
                            yl=['PC',int2str(spl.factors(2))];
                        end;
                        ylabel(yl,'tag','ylab');
                        if spl.plotdims>2,
                            if length(spl.nummode)>1|spl.factors(1)> b,
                                zl=['PC',int2str(spl.factors(3))];
                            else
                                zl=['PC',int2str(spl.factors(3))];
                            end;
                            zlabel(zl,'tag','zlab');
                        end;
                    end;
                    if length(spl.nummode)<2,
                        titre=['Mode ',int2str(spl.nummode)];
                    else,
                        titre=['Modes ',int2str(spl.nummode(1)),'x',int2str(spl.nummode(2))];
                    end;
                    title(titre);
                    if spl.additional.potential.exist==1 & spl.plotdims==2,
                        axi=axis;
                        hold on;
                        try
                            potentiel('gra',spl,A,axi);
                        catch
                            uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
                        end;
                    end;
                    if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
                        hold on;
                        try
                            hotel('gra',spl,A);
                        catch
                            uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
                        end;
                    end;
                    hold off;
                    set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                    set(findobj('tag','plo'),'visible',spl.visible);
                    set(findobj('tag','plo2'),'visible',spl.visible);
                case 'xmo',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.prediction.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Model'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        % Cu_FIX_2011
                        %   mod1 instead of mod (mod is a func. name)
                        
                        for k=1:size(ModelOut.prediction.data.data,3)
                            mod1{k}=((ModelOut.prediction.xfactors{1})*(diag(ModelOut.prediction.xfactors{3}(k,:)))*(ModelOut.prediction.xfactors{2}{k}*ModelOut.prediction.info.H)');
                        end
                        surf(mod1{sel})
                        axis tight
                        title(['Model of ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                    end
                    
                case 'ind',
                    [sel,ok]=listdlg('liststring',mi.samlabs.labels,...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between ',mi.samlabs.name]);
                    if ok==1,
                        E={[],[],[]};
                        a=ModelOut.prediction.data.data;
                        for k=1:size(ModelOut.prediction.data.data,3)
                            E{k}=a(:,:,k)-((ModelOut.prediction.xfactors{1})*(diag(ModelOut.prediction.xfactors{3}(k,:)))*(ModelOut.prediction.xfactors{2}{k}*ModelOut.prediction.info.H)');
                        end
                        Res=[];
                        for k=1:size(ModelOut.prediction.data.data,3)
                            Res(:,:,k)=E{k};
                        end
                        surf(reshape(Res(sel,:,:),size(ModelOut.prediction.data.data,2),size(ModelOut.prediction.data.data,3))');grid on;
                        axis tight
                        title(['Residuals for ',mi.samlabs.labels{sel}]);
                        clear a
                    end;
                case 'all',
                    E=cell(1,size(ModelOut.prediction.data.data,3));
                    
                    for k=1:size(ModelOut.prediction.data.data,3)
                        E{k}=ModelOut.prediction.data.data(:,:,k)-((ModelOut.prediction.xfactors{1})*(diag(ModelOut.prediction.xfactors{3}(k,:)))*(ModelOut.prediction.xfactors{2}{k}*ModelOut.prediction.info.H)');
                    end
                    Res=[];
                    for k=1:size(ModelOut.prediction.data.data,3)
                        Res=[Res;E{k}'];
                    end
                    plot(Res');grid on;
                    title('Residuals for all samples');
                    xlabel('Mode 2')
                    ylabel('Mode 1')
                case 'bat',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.prediction.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        a=ModelOut.prediction.data.data;
                        for k=1:size(ModelOut.prediction.data.data,3)
                            E{k}=a(:,:,k)-((ModelOut.prediction.xfactors{1})*(diag(ModelOut.prediction.xfactors{3}(k,:)))*(ModelOut.prediction.xfactors{2}{k}*ModelOut.prediction.info.H)');
                        end
                        surf(E{sel})
                        axis tight
                        title(['Residuals for ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                        clear a
                    end
                    
            end;  %switch type
            hold off;
            
            
            set(gca,tg,'cbaxes');
            PARAFAC2DisplayInfo(gcbf,ModelOut)
            
            
        end;  %graphs
    else
        if nargin==6,
            X=d{1}.data;
        end;
        WIC=[0.5029 0.5814 0.6402];
        lbc=[0.9 0.93 0.95];
        frc=[0.3529 0.4314 0.4902];
        
        ModelIn.nbfactors.min(1)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(2)=ModelIn.nbfactors.min(1);
        ModelIn.nbfactors.min(3)=ModelIn.nbfactors.min(1);
        
        %Default value 
        spl.additional.batch=1; %Supposing that PARAFAC2 model can only be applied to one batch at the time
        %----------------------
        
        if typ=='gra',
            h=findobj('tag','parafac2plot');
            if ~isempty(h),  
                delete(h);
            end;
            wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',spl)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
            if length(spl.nummode)>1,
                nom=['Modes ', int2str(spl.nummode(1)),'x', int2str(spl.nummode(2)),' - ',int2str(spl.plotdims),'D plots'];
                for i=1:mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2)),
                    st{i}=['PC',int2str(i)];
                end;
            else,
                nom=['Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
                if spl.nummode ==2
                    for i=1:size(ModelOut.prediction.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                else
                    st={};
                    for i=1:mi.nbfactors.min,
                        st{i}=['PC',int2str(i)];
                    end;
                    if isequal(spl.plotdims,1) & mi.valmethod.bootstrap==0,
                        st{mi.nbfactors.min(spl.nummode)+1}='All';
                    end;
                end;
            end;
            
            
            h0 = figure('MenuBar','none', 'Name',nom, 'MenuBar','none', 'NumberTitle','off', 'Position',[400 300 320 320], 'color',WIC,'Tag','parafac2plot','toolbar','none');
            h1 = uimenu('Parent',h0,'Label','&Tools','Tag','toolp');
            h2 = uimenu('Parent',h1,'Label','&Process control');
            if spl.plotdims==2,
                h3 = uimenu('Parent',h2, ...
                    'enable','on',...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.hotelling.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.hotelling.exist=1;'');end;',...
                    'Label','&Hotelling''s T2');   
                if spl.additional.hotelling.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            if spl.plotdims==2,
                h3 = uimenu('Parent',h2, ...
                    'callback','if isequal(get(gcbo,''checked''),''on''),set(gcbo,''checked'',''off'');evalin(''caller'',''spl.additional.potential.exist=0;'');else set(gcbo,''checked'',''on'');evalin(''caller'',''spl.additional.potential.exist=1;'');end;',...
                    'tag','pot',...
                    'Label','&Potential functions');
                if spl.additional.potential.exist==1,
                    set(h3,'checked','on');
                end;
            end;
            h1 = uimenu('Parent',h0,'Label','&Preferences','Tag','prefp');
            h2 = uimenu('Parent',h1,'Label','&Color');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''b'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','b','Label','&Blue');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''r'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','r','Label','&Red');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''g'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','g','Label','&Green');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''m'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','m','Label','&Magenta');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''c'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','c','Label','&Cyan');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''k'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','k','Label','&Black');
            set(findobj('tag',spl.color),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Marker');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''^'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','^','Label','Triangle');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''p'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','p','Label','Pentagram');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''d'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','d','Label','Diamond');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''*'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','*','Label','Star (*)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''o'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','o','Label','Circle (o)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','.','Label','Point (.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''+'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','+','Label','Plus (+)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''none'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','none','Label','None');
            set(findobj('tag',spl.marker),'checked','on');
            h2 = uimenu('Parent',h1,'Label','&Line style');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-','Label','Solid (-)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle='''':'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag',':','Label','Dotted (:)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-.','Label','Dashdotted (-.)');
            h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''--'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','--','Label','Dashed (--)');
            set(findobj('tag',spl.linestyle),'checked','on');
            h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.grid=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.grid=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','tag','grid','separator','on','Label','&Grid');
            if strcmp(spl.grid,'on'),
                set(findobj('tag','grid'),'checked','on');
            end;
            if isequal(spl.plotdims,3),
                h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.shadow=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.shadow=0;set(gcbo,''''checked'''',''''off'''');end;'')','tag','shadow','Label','&Shadow');
                if isequal(spl.additional.shadow,1),
                    set(findobj('tag','shadow'),'checked','on');
                end;
            end;
            h2 = uimenu('Parent',h1,'Label','&Visible','callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.visible=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.visible=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','Tag','vispca');
            
            if strcmp(spl.visible,'on'),
                set(findobj('tag','vispca'),'checked','on');
            end;
            h2 = uimenu('Parent',h1, ...
                'Label','&Process control options', ...
                'separator','on',...
                'Tag','pco');
            h3 = uimenu('Parent',h2, ...
                'Label','&Hotelling''s T2 options', ...
                'callback','evalin(''caller'',''hotel(''''win'''',spl,mo);'');',...
                'Tag','ho');
            h3 = uimenu('Parent',h2, ...
                'Label','&Potential options', ...
                'callback','evalin(''caller'',''potentiel(''''win'''',spl,mo);'');',...
                'Tag','po');
            if spl.nummode==2
                cb0='evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''');'')';
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'tag','batch','string',st2,'fontsize',12,'callback','evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''')'');','backgroundcolor',lbc,'position',[80 185 170 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            else
                h1=uimenu('Parent',h0,'Label','&Help','Tag','helpparafac2plot');
                h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[250 30 50 30],'tooltipstring','close ','style','pushbutton');  
                h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[50 30 50 30],'tooltipstring','','style','pushbutton');
                h1=uicontrol('Parent',h0,'style','text','backgroundcolor',WIC,'Position',[0 247 290 41]);
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
                h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
                h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
                h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Labels','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
                h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
            end;
            cb1='evalin(''caller'',''spl.factors(1)=get(gcbo,''''value'''');'')';
            cb2='evalin(''caller'',''spl.factors(2)=get(gcbo,''''value'''');'')';
            cb3='evalin(''caller'',''spl.factors(3)=get(gcbo,''''value'''');'')';
            mini=min(mi.nbfactors.min);
            if spl.factors(1)>mini,
                spl.factors(1)=1;
            end;
            if spl.factors(2)>mini,
                spl.factors(2)=2;
            end;
            if spl.factors(3)>mini,
                spl.factors(3)=3;
            end;
            switch spl.plotdims,
                case 1
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[120 230 50 50],'backgroundcolor',lbc,'value',spl.factors(1),'string',st,'Tag','1d1');
                case 2,     
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[70 230 50 50],'callback',cb1,'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','2d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[170 230 50 50],'value',spl.factors(2),'callback',cb2,'backgroundcolor',lbc,'string',st,'Tag','2d2');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[120 258 50 19],'backgroundcolor',WIC,'Tag','tool');
                case 3,
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[30 230 50 50],'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','3d1');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb2,'Position',[130 230 50 50],'backgroundcolor',lbc,'string',st,'Tag','3d2');
                    h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb3,'Position',[230 230 50 50],'backgroundcolor',lbc,'value',spl.factors(3),'string',st,'Tag','3d3');
                    h1 = uicontrol('Parent',h0,'style','text','Position',[80 258 50 19],'string','versus','backgroundcolor',WIC,'Tag','tool');
                    h1 = uicontrol('Parent',h0, 'style','text','Position',[180 258 50 19],'backgroundcolor',WIC,'string','versus','Tag','tool');
            end;
            h=findobj('tag','parafac2plot');
            set(h,'waitstatus','open');
            waitfor(h,'waitstatus','close');
        else %    (graphs)
            if ~isempty(spl),
                setcvdata(1,'PlotStr',spl);
            end;
            h=findobj('tag','parafac2plot');
            delete(findobj('tag','textfig'));
            cc=struct(c{1});
            hfig=1;
            set(0,'currentfigure',hfig);
            delete(gca);
            delete(findobj('tag','cbaxes'));
            
            hhh=axes('parent',1);
            cop=get(gca,'colororder');
            [tacop,rr]=size(cop);
            set(hhh,'position',[0.3,0.11,0.685,0.815]);
            
            switch typ  % different kinds of graphics
                
                case 'mod'  % 123-D plots
                    dim=cc.dims;
                    dimt=[0 0 0 0 0 0 0 0 0 0 0 0];
                    nt=length(spl.batch);
                    coul=3;%color(nt);
                    
                    if length(spl.nummode)>1,
                        [a1,b1]=size(mo.model.xfactors{spl.nummode(1)})
                        [a2,b2]=size(mo.model.xfactors{spl.nummode(2)})
                        A=kron(mo.model.xfactors{spl.nummode(1)},mo.model.xfactors{spl.nummode(2)});
                        [A p1 p2]=svd(A,0);
                        clear p2;
                        j=mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2));
                        [a,b]=size(A);
                        if j<b,
                            A=A(:,1:j);
                        end;
                    else
                        if spl.nummode == 2
                            A= ModelOut.model.xfactors{2}{spl.additional.batch}*ModelOut.model.core;
                            [a,b]=size(A);
                            Anew= ModelOut.prediction.xfactors{2}{spl.additional.batch}*ModelOut.prediction.info.H;
                            [anew,bnew]=size(Anew);
                        else
                            A=mo.model.xfactors{spl.nummode};
                            [a,b]=size(A);
                            Anew=ModelOut.prediction.xfactors{spl.nummode};
                            [anew,bnew]=size(Anew);
                        end
                    end;
                    
                    mi.valmethod.bootstrap=0;
                    
                    switch mi.valmethod.bootstrap,
                        case 0,   %No bootstrap
                            switch spl.plotdims
                                case 1,
                                    if  spl.factors(1)< b+1,
                                        if length(spl.nummode)<2,
                                            plot(A(:,spl.factors(1)),'tag','plo','color','b');
                                            hold on
                                            plot(Anew(:,spl.factors(1)),'tag','plo','color','r');
                                            legend('calibration','test');
                                        else
                                            for j=1:a1,
                                                plot(A((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color','b');
                                                hold on;
                                                plot(Anew((j-1)*a2+1:j*a2,spl.factors(1)),'tag','plo','color','r');
                                                legend('calibration','test');
                                            end;
                                        end;
                                    else
                                        plot(A,'tag','plo');
                                    end;
                                    switch spl.format(1),
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    for i=1:a,
                                                        text(i,A(i,spl.factors(1)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                    end
                                                    for i=1:anew
                                                        text(i,Anew(i,spl.factors(1)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                    end;
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else,   
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                    end
                                                end
                                                for j=1:bnew
                                                    for i=1:anew
                                                        text(i,Anew(i,j),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if  spl.factors(1)< b+1,
                                                if length(spl.nummode)<2
                                                    for i=1:a,
                                                        text(i,A(i,spl.factors(1)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else % mixed modes
                                                    for i=1:a2
                                                        for j=1:a1,
                                                            text(i,A((j-1)*a2+i,spl.factors(1)),seb{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                        end; 
                                                    end;
                                                end;
                                            else 
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),seb{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        case 3 %marker
                                    end;
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(dim(spl.nummode)+1:dim(spl.nummode)+dimt(spl.nummode),s.Fproj{spl.nummode}(:,spl.factors(1)),'r*');
                                    end;
                                    hold off;
                                case 2,
                                    if length(spl.nummode)<2,
                                        plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'color','b','tag','plo');
                                        hold on
                                        plot(Anew(:,spl.factors(1)),Anew(:,spl.factors(2)),'color','r','tag','plo');
                                        legend('calibration','test'); 
                                    else
                                        for j=1:a1,
                                            plot(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color','b');
                                            hold on;
                                        end
                                        for j=1:anew
                                            plot(Anew((j-1)*a2+1:j*a2,spl.factors(1)),Anew((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color','r');
                                            legend('calibration','test'); 
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                    end
                                                    for i=1:anew
                                                        text(Anew(i,spl.factors(1)),Anew(i,spl.factors(2)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                        end
                                                        for i=1:size(Anew,1)
                                                            text(Anew(i,spl.factors(1)),Anew(i,spl.factors(2)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode+1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                        end
                                                        for j=1:dim(spl.nummode+1)
                                                            text(Anew(j,spl.factors(1)),Anew(j,spl.factors(2)),int2str(j),'fontsize',7,'color','r','tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;               
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode+1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),seb{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else %mixed modes
                                                for i=1:a2
                                                    for j=1:a1,
                                                        % text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),c{1}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;               
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot(s.Fproj{spl.nummode}(:,spl.factors(1)),mo.prediction.xfactors{spl.nummode}(:,spl.factors(2)),'r*');
                                    end;   
                                    hold off;
                                case 3,
                                    if length(spl.nummode)<2,
                                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color','b','tag','plo');
                                        hold on
                                        plot3(Anew(:,spl.factors(1)),Anew(:,spl.factors(2)),Anew(:,spl.factors(3)),'color','r','tag','plo');
                                        legend('calibration','test');
                                    else,
                                        for j=1:a1,
                                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color','b');
                                            hold on;
                                            plot3(Anew((j-1)*a2+1:j*a2,spl.factors(1)),Anew((j-1)*a2+1:j*a2,spl.factors(2)),Anew((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color','r');
                                            legend('calibration','test');
                                        end;
                                    end;
                                    switch spl.format(1)
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color','b','tag','plo2');
                                                    end
                                                    for j=1:anew
                                                        text(Anew(j,spl.factors(1)),Anew(j,spl.factors(2)),Anew(j,spl.factors(3)),int2str(j),'fontsize',7,'color','r','tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color','b','tag','plo2');
                                                        end
                                                        for j=1:anew
                                                            text(Anew(j,spl.factors(1)),Anew(j,spl.factors(2)),Anew(j,spl.factors(3)),int2str(j),'fontsize',7,'color','r','tag','plo2');
                                                        end;
                                                    else
                                                        for j=1:dim(spl.nummode+1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color','b','tag','plo2');
                                                        end
                                                        for j=dim(spl.nummode+1),
                                                            text(Anew(j,spl.factors(1)),Anew(j,spl.factors(2)),Anew(j,spl.factors(3)),int2str(j),'fontsize',7,'color','r','tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color','b','tag','plo2');
                                                        text(Anew((j-1)*a2+i,spl.factors(1)),Anew((j-1)*a2+i,spl.factors(2)),Anew((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color','r','tag','plo2');
                                                    end; 
                                                end;                  
                                            end;                 
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            if length(spl.nummode)<2,
                                                if spl.nummode == 3,
                                                    for j=1:a,
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for j=1:size(A,1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for j=1:dim(spl.nummode+1),
                                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),seb{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            else
                                                for i=1:a2
                                                    for j=1:a1,
                                                        text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),seb{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;                  
                                            end;
                                        case 3 %marker
                                            
                                    end;
                                    
                                    
                                    hold on;
                                    if dimt(spl.nummode)>0,
                                        plot3(s.Fproj{spl.nummode}(:,spl.factors(1)),s.Fproj{spl.nummode}(:,spl.factors(2)),s.Fproj{spl.nummode}(:,spl.factors(3)),'r*');
                                    end;
                                    if isequal(spl.additional.shadow, 1),
                                        axe=axis;
                                        if length(spl.nummode)<2,
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(axe(2)*ones(dim(spl.nummode),1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                        else
                                            for j=1:a1,
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(axe(2)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                                plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                            end;
                                        end;
                                    end;
                                    
                                    hold off;
                            end;
                            if spl.format(1)==3,
                                set(findobj('tag','plo'),'marker',spl.marker);
                            end;
                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                            
                            switch spl.format(2)
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                                    %set(findobj('tag','plo'),'marker','none');
                            end;
                            
                            
                        case 1,   %Naive bootstrap parafac2
                            switch spl.plotdims,
                                case 1, %1D plot
                                    spl.plotdims=1;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        for i=1:mi.valmethod.replicates,
                                            uu=mo.validation.segments(:,i);
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            if Ab(:,spl.factors(1))'*mo.model.xfactors{spl.nummode}(uu,spl.factors(1))<0
                                                Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                            end;
                                            plot(uu,Ab(:,spl.factors(1)),'+b','tag','plo2');
                                        end;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,                  
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            plot(Bb(:,spl.factors(1)),'+b','tag','plo2');
                                        end;
                                    end;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    set(findobj('tag','plo'),'color',spl.color);
                                    
                                    if spl.format(1)==3,
                                        set(findobj('tag','plo'),'marker',spl.marker);
                                    else
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.format(1)==2,
                                            for jj=1:c{1}.dims(spl.nummode),
                                                text(jj,A(jj,spl.factors(1)),seb{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                            end;
                                        end;
                                    end;
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    end;  
                                case 2,  %2D plot
                                    coul=couleur(c{1}.dims(spl.nummode));
                                    spl.plotdims=2;
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        m(1:c{1}.dims(1))=0;
                                        for i=1:mi.valmethod.replicates,
                                            uu=mo.validation.segments(:,i);
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            for v=1:mi.nbfactors.min, % changement de signe du mode 1
                                                if Ab(:,v)'*A(uu,v)<0
                                                    Ab(:,v)=-Ab(:,v);
                                                end
                                            end;
                                            for j=1:c{1}.dims(1),  %on elimine les points redondants 
                                                rr=uu(j);
                                                if j>1 & mean(uu(j)==uu(1:j-1))>0
                                                else
                                                    m(rr)=m(rr)+1;
                                                    Abstock{uu(j)}(m(rr),:)=Ab(j,:);
                                                end;
                                            end;
                                        end;
                                        for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                                            Abech=Abstock{jj}(:,:);
                                            tai=size(Abech);
                                            if tai(1)>2,
                                                k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end;
                                        axis equal;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Bbstock(i,:,:)=Bb(:,:);	
                                        end;
                                        for jj=1:c{1}.dims(2),   %tracage des enveloppes convexes
                                            Bbech=squeeze(Bbstock(:,jj,:));
                                            tai=size(Bbech);
                                            if tai(1)>2
                                                k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2');                        
                                            end;
                                        end;
                                        % mettre 
                                    end;  %if/elseif nummode
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    set(findobj('tag','plo'),'marker','none');
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                            set(findobj('tag','plo'),'color',spl.color);
                                    end;   
                            end; %switch spl.plotdims
                        case 2,   %Residual bootstrap parafac2plot
                            switch spl.plotdims,
                                case 1, %1D plot
                                    spl.plotdims=1;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        for i=1:mi.valmethod.replicates,
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            if Ab(:,spl.factors(1))'*A(:,spl.factors(1))<0
                                                Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                            end;
                                            plot(Ab(:,spl.factors(1)),'b','tag','plo2');
                                            hold on;
                                        end;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,                  
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            plot(Bb(:,spl.factors(1)),'b','tag','plo2');
                                            hold on;
                                        end;
                                    end;
                                    plot(A(:,spl.factors(1)),'tag','plo');
                                    set(findobj('tag','plo'),'color',spl.color);
                                    if spl.format(1)==3,
                                        set(findobj('tag','plo'),'marker',spl.marker);
                                    else
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.format(1)==2,
                                            for jj=1:c{1}.dims(spl.nummode),
                                                text(jj,A(jj,spl.factors(1)),seb{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                            end;
                                        end;
                                    end;
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    end;  
                                case 2,  %2D plot
                                    coul=couleur(c{1}.dims(spl.nummode));
                                    spl.plotdims=2;
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    hold on;
                                    if isequal(spl.nummode,1),
                                        m(1:c{1}.dims(1))=0;
                                        for i=1:mi.valmethod.replicates,
                                            Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Abstock(i,:,:)=Ab(:,:);
                                            for v=1:mi.nbfactors.min, % changement de signe du mode 1
                                                if Ab(:,v)'*A(:,v)<0
                                                    Ab(:,v)=-Ab(:,v);
                                                end
                                            end;
                                        end;
                                        for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                                            Abech=squeeze(Abstock(:,jj,:));
                                            tai=size(Abech);
                                            if tai(1)>2,
                                                k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                                fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end;
                                        axis equal;
                                    elseif isequal(spl.nummode,2),
                                        for i=1:mi.valmethod.replicates,
                                            Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                            Bbstock(i,:,:)=Bb(:,:);	
                                        end;
                                        for jj=1:c{1}.dims(2),   %traage des enveloppes convexes
                                            Bbech=squeeze(Bbstock(:,jj,:));
                                            tai=size(Bbech);
                                            if tai(1)>2
                                                k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                                fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                                hold on;
                                            end;
                                            if spl.format(1)==1,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==2,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),seb{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                            elseif spl.format(1)==3,
                                                text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                            end;
                                        end
                                    end;  %if/elseif
                                    plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                                    set(findobj('tag','plo'),'marker','none');
                                    switch spl.format(2),
                                        case 2 %discrete
                                            set(findobj('tag','plo'),'linestyle','none');
                                        case 1% continuous
                                            set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                            set(findobj('tag','plo'),'color',spl.color);
                                    end; 
                            end; %switch spl.plotdims
                            
                    end; %switch s.bootstrap
                    if length(spl.nummode)>1 |spl.factors(1)> b,
                        xl=['PC',int2str(spl.factors(1))];
                        if spl.factors(1)> b,
                            xl=['All PC'];
                        end;
                    else
                        xl=['Mode ',num2str(spl.nummode),', PC',int2str(spl.factors(1))];
                        
                    end;
                    xlabel(xl,'tag','xlab');
                    if spl.plotdims>1
                        if length(spl.nummode)>1|spl.factors(1)> b,
                            yl=['PC',int2str(spl.factors(2))];
                        else
                            yl=['PC',int2str(spl.factors(2))];
                        end;
                        ylabel(yl,'tag','ylab');
                        if spl.plotdims>2,
                            if length(spl.nummode)>1|spl.factors(1)> b,
                                zl=['PC',int2str(spl.factors(3))];
                            else
                                zl=['PC',int2str(spl.factors(3))];
                            end;
                            zlabel(zl,'tag','zlab');
                        end;
                    end;
                    if length(spl.nummode)<2,
                        titre=['Mode ',int2str(spl.nummode)];
                    else,
                        titre=['Modes ',int2str(spl.nummode(1)),'x',int2str(spl.nummode(2))];
                    end;
                    title(titre);
                    if spl.additional.potential.exist==1 & spl.plotdims==2,
                        axi=axis;
                        hold on;
                        try
                            potentiel('gra',spl,A,axi);
                        catch
                            uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
                        end;
                    end;
                    if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
                        hold on;
                        try
                            hotel('gra',spl,A);
                        catch
                            uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
                        end;
                    end;
                    hold off;
                    set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                    set(findobj('tag','plo'),'visible',spl.visible);
                    set(findobj('tag','plo2'),'visible',spl.visible);
                case 'xmo',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.prediction.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Model'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        % Cu_FIX_2011
                        %   mod1 instead of mod (mod is a func. name)
                        for k=1:size(ModelOut.prediction.data.data,3)
                            mod1{k}=((ModelOut.prediction.xfactors{1})*(diag(ModelOut.prediction.xfactors{3}(k,:)))*(ModelOut.prediction.xfactors{2}{k}*ModelOut.prediction.info.H)');
                        end
                        surf(mod1{sel})
                        axis tight
                        title(['Model of ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                    end
                    
                case 'ind',
                    [sel,ok]=listdlg('liststring',ModelOut.prediction.data.labels{1},...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between ',mi.samlabs.name]);
                    if ok==1,
                        Res=ModelOut.prediction.data.data'-((ModelOut.prediction.xfactors{1})*(diag(ModelOut.prediction.xfactors{3}(1,:)))*(ModelOut.prediction.xfactors{2}{1}*ModelOut.prediction.info.H)');
                        Res=Res';
                        plot(Res(sel,:));grid on;
                        set(gca,'Xlim',[1 size(Res(sel,:),2)]);
                        title(['Residuals for ',mi.samlabs.labels{sel}]);
                    end;
                case 'all',
                    Res=ModelOut.prediction.data.data'-((ModelOut.prediction.xfactors{1})*(diag(ModelOut.prediction.xfactors{3}(1,:)))*(ModelOut.prediction.xfactors{2}{1}*ModelOut.prediction.info.H)');
                    Res=Res';
                    surf(Res');grid on;
                    axis tight
                    title('Residuals for all samples');
                    xlabel('Mode 2');
                    ylabel('Mode 1');
                case 'bat',
                    wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',PlotStr)'');parafac2plot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
                    for i=1:size(ModelOut.model.xfactors{2},2),
                        st2{i}=['Mode 3 - Modality ',int2str(i)];
                    end;
                    [sel,ok]=listdlg('liststring',st2,...
                        'name',['Residuals'],...
                        'selectionmode','single',...
                        'promptstring',['Choose between Mode 3 - Modalities']);
                    if ok==1,
                        for k=1:size(ModelIn.data.dataparafac2,3)
                            E{k}=ModelIn.data.dataparafac2(:,:,k)-((ModelOut.model.xfactors{1})*(diag(ModelOut.model.xfactors{3}(k,:)))*(ModelOut.model.xfactors{2}{k}*ModelOut.model.core)');
                        end
                        surf(E{sel})
                        axis tight
                        title(['Residuals for ' st2{sel}])
                        xlabel('Mode 2')
                        ylabel('Mode 1')
                    end
                    
            end;  %switch type
            hold off;
            
            
            set(gca,tg,'cbaxes');
            PARAFAC2DisplayInfo(gcbf,ModelOut)
            
        end;  %graphiques
    end
end



